/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.facet.widgets.internal.ImageProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.internal.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.IPutOnTheTopQuestionDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.internal.SortedColumnContentProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.dialogs.PutOnTheTopQuestionDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnsToHideDialog
extends ListSelectionDialog
implements IColumnsToHideDialog {
    private final SortedColumnContentProvider contentProvider;
    private boolean setAtTheTop;
    private List<Column> initialSelection;
    private final boolean askToPutOnTheTopTheLocalCustomization;
    private boolean mustAskTheUserNextTime;
    private PutOnTheTopQuestionDialog putOnTheTopQuestionDialog;

    public ColumnsToHideDialog(Shell parentShell, Object input, ILabelProvider labelProvider, SortedColumnContentProvider contentProvider, boolean askToPutOnTheTopTheLocalCustomization, boolean localCustomizatinMustBeOnTheTop) {
        super(parentShell, input, (IStructuredContentProvider)contentProvider, labelProvider, Messages.NatTableWidget_selectColumnToShowHide);
        this.contentProvider = contentProvider;
        this.setAtTheTop = localCustomizatinMustBeOnTheTop;
        this.askToPutOnTheTopTheLocalCustomization = askToPutOnTheTopTheLocalCustomization;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImage(ImageProvider.getInstance().getSelectColumnsToHide());
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        final Button checkBox = new Button((Composite)control, 32);
        checkBox.setText("Sort Columns By Name");
        checkBox.pack();
        checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToHideDialog.this.contentProvider.setIsSorted(checkBox.getSelection());
                ColumnsToHideDialog.this.getViewer().refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return control;
    }

    public int open() {
        if (this.askToPutOnTheTopTheLocalCustomization) {
            this.putOnTheTopQuestionDialog = this.openPutOnTheTopQuestionDialog();
        }
        this.initialSelection = this.getVisibleColumns(this.setAtTheTop);
        this.setInitialElementSelections(this.initialSelection);
        return super.open();
    }

    private PutOnTheTopQuestionDialog openPutOnTheTopQuestionDialog() {
        String message = "When you select the hidden columns, the information is stored in a local uiCustom file. This file needs to be on the top of the custom stack to be correctly applied.\n\nSet the local custom file at the top of the custom stack ?";
        String toggleMessage = "Don't display this warning the next time and save the answer.";
        final PutOnTheTopQuestionDialog dialog = new PutOnTheTopQuestionDialog(this.getShell(), Messages.NatTableWidget_selectColumnToShowHide, ImageProvider.getInstance().getSelectColumnsToHide(), message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, toggleMessage, false){

            public boolean close() {
                ColumnsToHideDialog.this.setAtTheTop = this.getUserAnswer();
                ColumnsToHideDialog.this.mustAskTheUserNextTime = this.getMustAskTheUserNextTime();
                return super.close();
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog;
    }

    @Override
    public boolean getPutOnTheTop() {
        return this.setAtTheTop;
    }

    public List<Column> getInitialSelection() {
        return this.initialSelection;
    }

    @Override
    public IPutOnTheTopQuestionDialog getPutOnTheTopQuestionDialog() {
        return this.putOnTheTopQuestionDialog;
    }

    @Override
    public void ok() {
        this.okPressed();
    }

    public abstract List<Column> getVisibleColumns(boolean var1);

    @Override
    public List<Column> getSelectedColumns() {
        ArrayList<Column> resultList = new ArrayList<Column>();
        Object[] objectArray = this.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object result = objectArray[n2];
            if (result instanceof Column) {
                Column column = (Column)result;
                resultList.add(column);
            }
            ++n2;
        }
        return resultList;
    }

    @Override
    public boolean getMustAskTheUserNextTime() {
        return this.mustAskTheUserNextTime;
    }

    @Override
    public void selectAll() {
        this.getViewer().setAllChecked(true);
    }

    @Override
    public void deselectAll() {
        this.getViewer().setAllChecked(false);
    }
}

