/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.custom.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.facet.infra.browser.custom.ui.Messages;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySetsSelectionControl
extends Composite {
    private static final String COMBO_ALL = Messages.QuerySetsSelectionControl_allExistingQuerySets;
    private static final String COMBO_SELECTED = Messages.QuerySetsSelectionControl_querySetsSelectedBelowOnly;
    private static final int COMBO_ALL_INDEX = 0;
    private static final int COMBO_SELECTED_INDEX = 1;
    private final Combo comboQuerySets;
    private final CheckboxTableViewer importsList;
    private final Button buttonSelectAll;
    private final Button buttonDeselectAll;

    public QuerySetsSelectionControl(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        Composite comboComposite = new Composite((Composite)this, 0);
        comboComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        comboComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(comboComposite, 0);
        label.setText(Messages.QuerySetsSelectionControl_availableQuerySets);
        this.comboQuerySets = new Combo(comboComposite, 12);
        this.comboQuerySets.setLayoutData((Object)new GridData(4, 4, true, false));
        this.comboQuerySets.add(COMBO_ALL);
        this.comboQuerySets.add(COMBO_SELECTED);
        this.setAllQuerySetsAvailable(true);
        this.importsList = CheckboxTableViewer.newCheckList((Composite)this, (int)2818);
        this.importsList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonsComposite = new Composite((Composite)this, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buttonSelectAll = new Button(buttonsComposite, 8);
        this.buttonSelectAll.setText(Messages.QuerySetsSelectionControl_selectAll);
        this.buttonDeselectAll = new Button(buttonsComposite, 8);
        this.buttonDeselectAll.setText(Messages.QuerySetsSelectionControl_deselectAll);
        this.comboQuerySets.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuerySetsSelectionControl.this.updateQuerySetsControlsEnablement();
            }
        });
        this.buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySetsSelectionControl.this.importsList.setAllChecked(true);
            }
        });
        this.buttonDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySetsSelectionControl.this.importsList.setAllChecked(false);
            }
        });
        List<String> querySets = this.loadQuerySets();
        Collections.sort(querySets);
        this.importsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List serviceSets = (List)inputElement;
                return serviceSets.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.importsList.setInput(querySets);
        this.updateQuerySetsControlsEnablement();
    }

    private List<String> loadQuerySets() {
        ArrayList<String> querySets = new ArrayList<String>();
        Collection allModelQuerySet = ModelQuerySetCatalog.getSingleton().getAllModelQuerySets();
        for (ModelQuerySet modelQuerySet : allModelQuerySet) {
            if (modelQuerySet == null) continue;
            querySets.add(modelQuerySet.getName());
        }
        return querySets;
    }

    private void updateQuerySetsControlsEnablement() {
        boolean enabled = this.comboQuerySets.getSelectionIndex() == 1;
        this.importsList.getControl().setEnabled(enabled);
        this.buttonSelectAll.setEnabled(enabled);
        this.buttonDeselectAll.setEnabled(enabled);
    }

    public void setAllQuerySetsAvailable(boolean value) {
        if (value) {
            this.comboQuerySets.select(0);
        } else {
            this.comboQuerySets.select(1);
        }
    }

    public boolean getAllQuerySetsAvailable() {
        return this.comboQuerySets.getSelectionIndex() == 0;
    }

    public void setSelectedQuerySets(List<String> querySets) {
        this.importsList.setCheckedElements(querySets.toArray());
    }

    public String[] getSelectedQuerySets() {
        Object[] checkedElements = this.importsList.getCheckedElements();
        ArrayList<String> importedQuerySetsList = new ArrayList<String>();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            importedQuerySetsList.add(object.toString());
            ++n2;
        }
        return importedQuerySetsList.toArray(new String[importedQuerySetsList.size()]);
    }
}

