/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.uicore.internal.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.uicore.internal.Activator;
import org.eclipse.emf.facet.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ColorProvider;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.emf.facet.infra.common.core.internal.utils.StringUtils;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeItem
implements ITreeElement,
IAdaptable {
    private final EAttribute attribute;
    private final EObject parent;
    private final ITreeElement treeParent;
    private final AppearanceConfiguration appearanceConfiguration;
    private int cachedCount = -1;
    private Object cachedValue = null;

    public AttributeItem(EObject parent, ITreeElement treeParent, EAttribute attribute, AppearanceConfiguration appearanceConfiguration) {
        this.parent = parent;
        this.attribute = attribute;
        this.treeParent = treeParent;
        this.appearanceConfiguration = appearanceConfiguration;
    }

    public EAttribute getAttribute() {
        return this.attribute;
    }

    public int getCount() {
        if (this.cachedCount == -1) {
            Object value = this.localGet();
            this.cachedCount = this.attribute.isMany() ? ((List)value).size() : (value != null ? 1 : 0);
        }
        return this.cachedCount;
    }

    private Object localGet() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        if (this.attribute instanceof FacetAttribute) {
            try {
                this.cachedValue = this.appearanceConfiguration.getFacetContext().get(this.parent, (EStructuralFeature)this.attribute);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                this.cachedValue = null;
            }
        } else {
            this.cachedValue = this.parent.eGet((EStructuralFeature)this.attribute);
        }
        return this.cachedValue;
    }

    @Override
    public String getText() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        String customizedLabel = customizationEngine.getAttributeLabel(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        String staticText = AttributeItem.getStaticText(this.attribute, this.appearanceConfiguration.isShowMultiplicity(), customizedLabel);
        String strCount = this.attribute.isMany() ? " (" + this.getCount() + ")" : "";
        String strValue = this.getValueText();
        strValue = StringUtils.truncateBeforeNewline((String)strValue);
        return String.valueOf(staticText) + strCount + " = " + strValue;
    }

    public String getValueText() {
        Object value;
        String strValue = !this.attribute.isMany() ? ((value = this.localGet()) != null ? value.toString() : "") : "";
        return strValue;
    }

    public static String getStaticText(EAttribute attribute, boolean showMultiplicity, String customizedName) {
        String multiplicity = "";
        if (showMultiplicity) {
            String multLow = attribute.isRequired() ? "1" : "0";
            String multHigh = attribute.isMany() ? "*" : "1";
            multiplicity = " [" + multLow + ".." + multHigh + "]";
        }
        String prefix = attribute.isDerived() ? "/" : "";
        String attributeName = customizedName != null ? customizedName : attribute.getName();
        return String.valueOf(prefix) + attributeName + multiplicity;
    }

    @Override
    public Image getImage() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Image customizedIcon = customizationEngine.getAttributeIcon(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        if (customizedIcon != null) {
            return customizedIcon;
        }
        if (this.attribute instanceof FacetAttribute) {
            return ImageProvider.getInstance().getFacetAttributeIcon();
        }
        return ImageProvider.getInstance().getAttributeIcon();
    }

    public EObject getParent() {
        return this.parent;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    @Override
    public boolean hasChildren() {
        return this.attribute.isMany() && this.getCount() > 0;
    }

    @Override
    public List<?> getChildren() {
        if (this.attribute.isMany()) {
            List children = (List)this.parent.eGet((EStructuralFeature)this.attribute);
            return Collections.unmodifiableList(children);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Color getForeground() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getAttributeColor(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        if (color != null) {
            return color;
        }
        if (this.getCount() == 0) {
            return ColorProvider.getInstance().getGray();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getAttributeBackgroundColor(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        return color;
    }

    @Override
    public Font getFont() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Font customizedFont = customizationEngine.getCustomizedAttributeFont(this.facetOrParentClass(), this.attribute.getName(), this.appearanceConfiguration.getCustomFont(), this.parent);
        return customizedFont;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeItem) {
            AttributeItem other = (AttributeItem)obj;
            return this.attribute.equals(other.attribute) && this.parent.equals(other.parent);
        }
        return false;
    }

    public int hashCode() {
        int hashPrime1 = 47;
        int hashPrime2 = 13;
        return this.attribute.hashCode() * 47 + this.parent.hashCode() + 13;
    }

    public EClass facetOrParentClass() {
        if (this.attribute instanceof FacetAttribute) {
            Facet facet = (Facet)this.attribute.eContainer();
            return facet;
        }
        return this.parent.eClass();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EAttribute.class) {
            return this.attribute;
        }
        return null;
    }
}

