/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.util.core.internal.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderUtils {
    private static final int COPY_BUFFER_SIZE = 524288;

    private FolderUtils() {
    }

    public static final void clearFolder(File folder) {
        File[] files;
        assert (folder != null);
        assert (folder.exists());
        assert (folder.isDirectory());
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderUtils.clearFolder(file);
            }
            file.delete();
            ++n2;
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.getParent().exists()) {
            FolderUtils.createFolder((IFolder)folder.getParent());
        }
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static final void copyDirectory(File srcDir, File destDir) throws IOException {
        FolderUtils.copyDirectory(srcDir, destDir, new IFilter<String>(){

            @Override
            public boolean filter(String object) {
                return true;
            }
        });
    }

    public static final void copyDirectory(File srcDir, File destDir, IFilter<String> filter) throws IOException {
        File[] filesList;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] fileArray = filesList = srcDir.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            File dest = new File(String.valueOf(destDir.getPath()) + File.separator + src.getName());
            if (filter.filter(dest.getAbsolutePath())) {
                if (src.isDirectory()) {
                    FolderUtils.copyDirectory(src, dest, filter);
                } else {
                    FolderUtils.copyFile(src, dest);
                }
            }
            ++n2;
        }
    }

    public static final boolean copyFile(File source, File destination) {
        boolean result = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            try {
                int nbRead;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbRead = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbRead);
                }
                result = true;
            }
            catch (FileNotFoundException f) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e) {
                    result = false;
                }
            }
            catch (IOException e) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e2) {
                    result = false;
                }
            }
        }
        finally {
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
                if (destinationFile != null) {
                    destinationFile.close();
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }
}

