/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;

import org.eclipse.emf.facet.infra.facet.Facet;

import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Table Instance</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getTableConfiguration <em>Table Configuration</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getCustomizations <em>Customizations</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getFacets <em>Facets</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getContext <em>Context</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getParameter <em>Parameter</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isHideEmptyColumns <em>Hide Empty Columns</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isOnlyShowCommonColumns <em>Only Show Common Columns</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getColumns <em>Columns</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getRows <em>Rows</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getElements <em>Elements</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getLocalCustomization <em>Local Customization</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance()
 * @model
 * @generated
 */
public interface TableInstance extends EObject {
	/**
	 * Returns the value of the '<em><b>Table Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Table Configuration</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Table Configuration</em>' reference.
	 * @see #setTableConfiguration(TableConfiguration)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_TableConfiguration()
	 * @model
	 * @generated
	 */
	TableConfiguration getTableConfiguration();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getTableConfiguration <em>Table Configuration</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Table Configuration</em>' reference.
	 * @see #getTableConfiguration()
	 * @generated
	 */
	void setTableConfiguration(TableConfiguration value);

	/**
	 * Returns the value of the '<em><b>Customizations</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.infra.browser.custom.MetamodelView}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Customizations</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Customizations</em>' reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Customizations()
	 * @model
	 * @generated
	 */
	EList<MetamodelView> getCustomizations();

	/**
	 * Returns the value of the '<em><b>Facets</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Facets</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Facets</em>' reference.
	 * @see #setFacets(Facet)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Facets()
	 * @model
	 * @generated
	 */
	Facet getFacets();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getFacets <em>Facets</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Facets</em>' reference.
	 * @see #getFacets()
	 * @generated
	 */
	void setFacets(Facet value);

	/**
	 * Returns the value of the '<em><b>Context</b></em>' reference.
	 * <!-- begin-model-doc -->
	 * Context is the parameter given to the instantiationMethod's query to be the instantiated element's container.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Context</em>' reference.
	 * @see #setContext(EObject)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Context()
	 * @model
	 * @generated
	 */
	EObject getContext();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getContext <em>Context</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Context</em>' reference.
	 * @see #getContext()
	 * @generated
	 */
	void setContext(EObject value);

	/**
	 * Returns the value of the '<em><b>Parameter</b></em>' attribute.
	 * <!-- begin-model-doc -->
	 * The parameterValues parameter contains a value that you can retrieve using the key InstantiationMethodParameters.getEditingDomainParameter().getName().
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Parameter</em>' attribute.
	 * @see #setParameter(Object)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Parameter()
	 * @model
	 * @generated
	 */
	Object getParameter();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getParameter <em>Parameter</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parameter</em>' attribute.
	 * @see #getParameter()
	 * @generated
	 */
	void setParameter(Object value);

	/**
	 * Returns the value of the '<em><b>Hide Empty Columns</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hide Empty Columns</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to hide columns which don't contain any elements.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Hide Empty Columns</em>' attribute.
	 * @see #setHideEmptyColumns(boolean)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_HideEmptyColumns()
	 * @model default="false"
	 * @generated
	 */
	boolean isHideEmptyColumns();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isHideEmptyColumns <em>Hide Empty Columns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Hide Empty Columns</em>' attribute.
	 * @see #isHideEmptyColumns()
	 * @generated
	 */
	void setHideEmptyColumns(boolean value);

	/**
	 * Returns the value of the '<em><b>Only Show Common Columns</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Only Show Common Columns</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 *  Whether to show columns which are specific to a few elements (false), or only columns which are common to all the elements (true).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Only Show Common Columns</em>' attribute.
	 * @see #setOnlyShowCommonColumns(boolean)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_OnlyShowCommonColumns()
	 * @model default="false"
	 * @generated
	 */
	boolean isOnlyShowCommonColumns();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isOnlyShowCommonColumns <em>Only Show Common Columns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Only Show Common Columns</em>' attribute.
	 * @see #isOnlyShowCommonColumns()
	 * @generated
	 */
	void setOnlyShowCommonColumns(boolean value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The description of the tableInstance (content, purpose, uses  ... )
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Columns</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Columns</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Columns</em>' containment reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Columns()
	 * @model containment="true"
	 * @generated
	 */
	EList<Column> getColumns();

	/**
	 * Returns the value of the '<em><b>Rows</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Rows</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rows</em>' containment reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Rows()
	 * @model containment="true"
	 * @generated
	 */
	EList<Row> getRows();

	/**
	 * Returns the value of the '<em><b>Elements</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.EObject}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Elements</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Elements</em>' reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_Elements()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	EList<EObject> getElements();

	/**
	 * Returns the value of the '<em><b>Local Customization</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Local Customization</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Local Customization</em>' containment reference.
	 * @see #setLocalCustomization(MetamodelView)
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage#getTableInstance_LocalCustomization()
	 * @model containment="true" required="true"
	 * @generated
	 */
	MetamodelView getLocalCustomization();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getLocalCustomization <em>Local Customization</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Local Customization</em>' containment reference.
	 * @see #getLocalCustomization()
	 * @generated
	 */
	void setLocalCustomization(MetamodelView value);

} // TableInstance
