/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.browser.custom.AttributeView;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.CustomizableFeatures;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.StaticFeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomPackage;
import org.eclipse.emf.facet.infra.browser.custom.util.UicustomUtil;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryException;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableInstanceCommandFactory {
    protected static final String DEBUG_OPTION = "org.eclipse.emf.facet.widgets.nattable/debug/TableInstanceCommandFactory";
    protected static final boolean DEBUG = Activator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.widgets.nattable/debug/TableInstanceCommandFactory"));

    public static Command createLoadCustomizationsCommand(List<MetamodelView> customizationsToLoad, NatTableWidget natTableWidget) {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        List<MetamodelView> localCustomizations = natTableWidget.getLocalCustomizations();
        if (!localCustomizations.isEmpty() && !customizationsToLoad.containsAll(localCustomizations)) {
            customizationsToLoad.addAll(0, localCustomizations);
        }
        if (!customizationsToLoad.isEmpty()) {
            return commandFactory.createSetCommand(natTableWidget.getEditingDomain(), (Object)natTableWidget.getTableInstance(), (Object)TableinstancePackage.eINSTANCE.getTableInstance_Customizations(), customizationsToLoad);
        }
        return null;
    }

    public static Command createDeleteSelectedColumnCommand(NatTableWidget natTableWidget) {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (Column column : natTableWidget.getSelectedColumns()) {
            Command removeRowCommand = commandFactory.createRemoveCommand(natTableWidget.getEditingDomain(), (Object)natTableWidget.getTableInstance(), (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)column);
            compoundCommand.append(removeRowCommand);
        }
        return compoundCommand;
    }

    public static Command createDeleteSelectedElementCommand(NatTableWidget natTableWidget, ICommandFactory commandFactory) throws CoreException {
        PositionCoordinate[] selectedCells;
        ArrayList<Integer> toBeDeleted = null;
        CompoundCommand compoundCommand = new CompoundCommand();
        toBeDeleted = new ArrayList<Integer>();
        PositionCoordinate[] positionCoordinateArray = selectedCells = natTableWidget.getBodyLayer().getSelectionLayer().getSelectedCells();
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate positionCoordinate = positionCoordinateArray[n2];
            if (!toBeDeleted.contains(positionCoordinate.rowPosition)) {
                toBeDeleted.add(positionCoordinate.rowPosition);
            }
            ++n2;
        }
        TableInstance tableInstance = natTableWidget.getTableInstance();
        int i = 0;
        while (i < tableInstance.getRows().size()) {
            if (toBeDeleted.contains(i)) {
                Command deleteEltCommand = commandFactory.createDeleteCommand(natTableWidget.getEditingDomain(), (Object)((Row)tableInstance.getRows().get(i)).getElement());
                compoundCommand.append(deleteEltCommand);
            }
            ++i;
        }
        return compoundCommand;
    }

    public static Command createRemoveLineCommand(NatTableWidget natTableWidget) throws CoreException {
        PositionCoordinate[] selectedCells;
        CompoundCommand compoundCommand = new CompoundCommand();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        TableInstance tableInstance = natTableWidget.getTableInstance();
        ArrayList<Integer> toBeRemoved = new ArrayList<Integer>();
        PositionCoordinate[] positionCoordinateArray = selectedCells = natTableWidget.getBodyLayer().getSelectionLayer().getSelectedCells();
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate positionCoordinate = positionCoordinateArray[n2];
            if (!toBeRemoved.contains(positionCoordinate.rowPosition)) {
                toBeRemoved.add(positionCoordinate.rowPosition);
            }
            ++n2;
        }
        int i = 0;
        while (i < tableInstance.getElements().size()) {
            if (toBeRemoved.contains(i)) {
                Command removeRowCommand = commandFactory.createRemoveCommand(natTableWidget.getEditingDomain(), (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Rows(), tableInstance.getRows().get(i));
                compoundCommand.append(removeRowCommand);
            }
            ++i;
        }
        CompoundCommand updateColumnCommand = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(natTableWidget, toBeRemoved);
        if (updateColumnCommand != null) {
            compoundCommand.append((Command)updateColumnCommand);
        }
        return compoundCommand;
    }

    public static CompoundCommand createRemoveUselessColumnsCommand(NatTableWidget natTableWidget, List<Integer> toBeRemoved) throws CoreException {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        TableInstance tableInstance = natTableWidget.getTableInstance();
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        if (toBeRemoved != null) {
            for (Integer i : toBeRemoved) {
                rowsToRemove.add((Row)tableInstance.getRows().get(Integer.valueOf(i).intValue()));
            }
        }
        CompoundCommand result = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(tableInstance, rowsToRemove, commandFactory, editingDomain);
        return result;
    }

    public static CompoundCommand createRemoveUselessColumnsCommand(TableInstance tableInstance, List<Row> rowsToRemove, ICommandFactory commandFactory, EditingDomain editingDomain) throws MultiModelQueryException {
        CompoundCommand compoundCommand = new CompoundCommand();
        ArrayList rowsToKeep = new ArrayList(tableInstance.getRows());
        rowsToKeep.removeAll(rowsToRemove);
        ArrayList columns = new ArrayList(tableInstance.getColumns());
        if (rowsToKeep.isEmpty()) {
            for (Column column : columns) {
                Command removeColumnCommand = commandFactory.createRemoveCommand(editingDomain, (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)column);
                compoundCommand.append(removeColumnCommand);
            }
            return compoundCommand;
        }
        ArrayList<Status> statusList = new ArrayList<Status>();
        HashSet<EStructuralFeature> eStructuralFeatures = new HashSet<EStructuralFeature>();
        for (Row row : rowsToKeep) {
            EList allStructuralFeatures = row.getElement().eClass().getEAllStructuralFeatures();
            eStructuralFeatures.addAll((Collection<EStructuralFeature>)allStructuralFeatures);
            try {
                ArrayList<Facet> appliedFacets = new ArrayList<Facet>();
                if (tableInstance instanceof TableInstance2) {
                    TableInstance2 tableInstance2 = (TableInstance2)tableInstance;
                    appliedFacets.addAll((Collection<Facet>)tableInstance2.getFacets2());
                } else {
                    appliedFacets.add(tableInstance.getFacets());
                }
                List<EStructuralFeature> facetStructuralFetures = TableInstanceCommandFactory.getStructuralFeatures(row.getElement(), appliedFacets);
                eStructuralFeatures.addAll(facetStructuralFetures);
            }
            catch (ModelQueryException e) {
                Status status = new Status(4, "org.eclipse.emf.facet.widgets.nattable", "An exception has occured while retrieving structural features of:" + row.getElement(), (Throwable)e);
                statusList.add(status);
            }
        }
        if (!statusList.isEmpty()) {
            MultiStatus globalStatus = new MultiStatus("org.eclipse.emf.facet.widgets.nattable", 0, "An exception has occured while retrieving structural features of the eObjects", (Throwable)new Exception());
            throw new MultiModelQueryException((IStatus)globalStatus);
        }
        for (Column column : columns) {
            if (!(column instanceof FeatureColumn)) continue;
            EStructuralFeature structuralFeature = ((FeatureColumn)column).getFeature();
            if ((structuralFeature = (EStructuralFeature)EcoreUtil.resolve((EObject)structuralFeature, (EObject)tableInstance)).eIsProxy()) {
                throw new RuntimeException("The current structural feature should have been resolved. " + EcoreUtil.getURI((EObject)structuralFeature));
            }
            if (eStructuralFeatures.contains(structuralFeature)) continue;
            if (DEBUG) {
                System.out.println("org.eclipse.emf.facet.widgets.nattable.internal.TableInstanceCommandFactory.createCheckColumnIntegrityCommand(TableInstance, List<Row>, ICommandFactory, EditingDomain): column to remove: " + EcoreUtil.getURI((EObject)structuralFeature));
            }
            Command removeColumnCommand = commandFactory.createRemoveCommand(editingDomain, (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)column);
            compoundCommand.append(removeColumnCommand);
        }
        if (compoundCommand.getCommandList().size() == 0) {
            compoundCommand = null;
        }
        return compoundCommand;
    }

    private static List<EStructuralFeature> getStructuralFeatures(EObject eObject, List<Facet> appliedFacets) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Facet facet : appliedFacets) {
            if (!TableInstanceCommandFactory.isInstance(eObject, facet)) continue;
            result.addAll((Collection)facet.getEStructuralFeatures());
        }
        return result;
    }

    private static boolean isInstance(EObject eObject, Facet facet) throws ModelQueryException {
        ModelQuery modelQuery = facet.getConditionQuery();
        boolean result = false;
        boolean isSuperType = false;
        for (EClass superType : facet.getESuperTypes()) {
            if (!superType.isSuperTypeOf(eObject.eClass())) continue;
            isSuperType = true;
            break;
        }
        if (isSuperType) {
            if (modelQuery == null) {
                result = true;
            } else {
                AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
                try {
                    Object queryResult = abstractModelQuery.basicEvaluate(eObject);
                    if (queryResult instanceof Boolean) {
                        result = (Boolean)queryResult;
                    } else {
                        String message = "Query " + abstractModelQuery.toString() + " didn't return a boolean result as expected.";
                        Logger.logError((String)message, (Plugin)Activator.getDefault());
                    }
                }
                catch (ModelQueryException e) {
                    result = false;
                    throw e;
                }
                catch (Exception e) {
                    result = false;
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    throw new ModelQueryException("FacetContext failed to execute a query", (Throwable)e);
                }
            }
        }
        return result;
    }

    public static CompoundCommand createAddRowsCommand(List<EObject> newElements, NatTableWidget natTableWidget) {
        CompoundCommand addNonFeatureColumnCommand;
        CompoundCommand compoundCommand = new CompoundCommand();
        HashSet<EPackage> alreadyDone = new HashSet<EPackage>();
        TableInstance tableInstance = natTableWidget.getTableInstance();
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        ArrayList<EStructuralFeature> processedEStructuralFeatures = new ArrayList<EStructuralFeature>();
        for (EObject eObject : newElements) {
            if (tableInstance.getElements().contains((Object)eObject)) continue;
            Row row = TableinstanceFactory.eINSTANCE.createRow();
            Command setEobjectToRowCMD = commandFactory.createSetCommand(editingDomain, (Object)row, (Object)TableinstancePackage.eINSTANCE.getRow_Element(), (Object)eObject);
            compoundCommand.append(setEobjectToRowCMD);
            Command addRowCMD = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Rows(), (Object)row);
            compoundCommand.append(addRowCMD);
            for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                Command cmd;
                if (processedEStructuralFeatures.contains(eStructuralFeature)) continue;
                processedEStructuralFeatures.add(eStructuralFeature);
                if (natTableWidget.isColumnAlreadyDeclared(eStructuralFeature)) continue;
                if (eStructuralFeature instanceof EReference) {
                    ReferenceColumn referenceColumn = TableinstanceFactory.eINSTANCE.createReferenceColumn();
                    referenceColumn.setReference((EReference)eStructuralFeature);
                    cmd = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)referenceColumn);
                    compoundCommand.append(cmd);
                } else if (eStructuralFeature instanceof EAttribute) {
                    AttributeColumn attributeColumn = TableinstanceFactory.eINSTANCE.createAttributeColumn();
                    attributeColumn.setAttribute((EAttribute)eStructuralFeature);
                    cmd = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)attributeColumn);
                    compoundCommand.append(cmd);
                }
                if (!(tableInstance instanceof TableInstance2)) continue;
                List<MetamodelView> localCustoms = natTableWidget.getLocalCustomizations();
                EObject container = eStructuralFeature.eContainer();
                if (container == null || !((container = container.eContainer()) instanceof EPackage) || alreadyDone.contains(container) || UicustomUtil.getMetamodelViewByEPackage(localCustoms, (EPackage)((EPackage)container)) != null) continue;
                Command cmd2 = TableInstanceCommandFactory.createMetamodelViewCommand(((EPackage)container).getNsURI(), natTableWidget);
                if (cmd2.canExecute()) {
                    compoundCommand.append(cmd2);
                }
                alreadyDone.add((EPackage)container);
            }
        }
        if (!newElements.isEmpty() && (addNonFeatureColumnCommand = TableInstanceCommandFactory.createAddNonFeatureColumnIfNeeded(natTableWidget)) != null) {
            compoundCommand.append((Command)addNonFeatureColumnCommand);
        }
        return compoundCommand;
    }

    private static CompoundCommand createAddNonFeatureColumnIfNeeded(NatTableWidget natTableWidget) {
        Command addCommand;
        CompoundCommand result = new CompoundCommand();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        EditingDomain editingdomain = natTableWidget.getEditingDomain();
        TableInstance tableInstance = natTableWidget.getTableInstance();
        EContainerColumn eContainerColumn = null;
        MetaClassColumn metaClassColumn = null;
        DefaultLabelColumn defaultLabelColumn = null;
        for (Column column : tableInstance.getColumns()) {
            if (column instanceof EContainerColumn) {
                eContainerColumn = (EContainerColumn)column;
                continue;
            }
            if (column instanceof MetaClassColumn) {
                metaClassColumn = (MetaClassColumn)column;
                continue;
            }
            if (!(column instanceof DefaultLabelColumn)) continue;
            defaultLabelColumn = (DefaultLabelColumn)column;
        }
        if (eContainerColumn == null) {
            eContainerColumn = TableinstanceFactory.eINSTANCE.createEContainerColumn();
            addCommand = commandFactory.createAddCommand(editingdomain, (Object)tableInstance, (Object)8, (Object)eContainerColumn);
            result.append(addCommand);
        }
        if (metaClassColumn == null) {
            metaClassColumn = TableinstanceFactory.eINSTANCE.createMetaClassColumn();
            addCommand = commandFactory.createAddCommand(editingdomain, (Object)tableInstance, (Object)8, (Object)metaClassColumn);
            result.append(addCommand);
        }
        if (defaultLabelColumn == null) {
            defaultLabelColumn = TableinstanceFactory.eINSTANCE.createDefaultLabelColumn();
            addCommand = commandFactory.createAddCommand(editingdomain, (Object)tableInstance, (Object)8, (Object)defaultLabelColumn);
            result.append(addCommand);
        }
        if (result.getCommandList().isEmpty()) {
            result = null;
        }
        return result;
    }

    private static Command createMetamodelViewCommand(String nsURI, NatTableWidget natTableWidget) {
        CompoundCommand compoundCommand = new CompoundCommand();
        TableInstance tableInstance = natTableWidget.getTableInstance();
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        MetamodelView newMetamodelView = UicustomFactory.eINSTANCE.createMetamodelView();
        Command createMetamodelView = commandFactory.createSetCommand(editingDomain, (Object)newMetamodelView, (Object)UicustomPackage.eINSTANCE.getMetamodelView_MetamodelURI(), (Object)nsURI);
        compoundCommand.append(createMetamodelView);
        if (tableInstance instanceof TableInstance2) {
            Command setMetamodelViewLocalCmd = commandFactory.createAddCommand(editingDomain, (Object)tableInstance, (Object)Tableinstance2Package.eINSTANCE.getTableInstance2_LocalCustomizations(), (Object)newMetamodelView);
            compoundCommand.append(setMetamodelViewLocalCmd);
            ArrayList<MetamodelView> views = new ArrayList<MetamodelView>();
            views.addAll((Collection<MetamodelView>)tableInstance.getCustomizations());
            List<MetamodelView> localCustom = natTableWidget.getLocalCustomizations();
            int i = 0;
            while (i < views.size()) {
                if (localCustom.contains(views.get(i))) break;
                ++i;
            }
            views.add(i, newMetamodelView);
            Command setMetamodelViewCmd = commandFactory.createSetCommand(editingDomain, (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Customizations(), views);
            compoundCommand.append(setMetamodelViewCmd);
        } else {
            Command setMetamodelView = commandFactory.createSetCommand(editingDomain, (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_LocalCustomization(), (Object)newMetamodelView);
            compoundCommand.append(setMetamodelView);
        }
        return compoundCommand;
    }

    public static Command createShowHideColumnCommand(NatTableWidget natTableWidget, List<Column> columnsToShow, List<Column> columnsToHide, boolean putOnTheTop) {
        Command cmd;
        HashMap<EClass, TypeView> typeViewMap = new HashMap<EClass, TypeView>();
        CompoundCommand compoundCommand = new CompoundCommand();
        TableInstance tableInstance = natTableWidget.getTableInstance();
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        if (tableInstance instanceof TableInstance2) {
            Command cmd2;
            Command tmp;
            for (Column current : columnsToShow) {
                if (current instanceof FeatureColumn) {
                    tmp = TableInstanceCommandFactory.getShowHideColumnCommand(natTableWidget, current, false, typeViewMap);
                    if (tmp == null || !tmp.canExecute()) continue;
                    compoundCommand.append(tmp);
                    continue;
                }
                cmd2 = commandFactory.createSetCommand(editingDomain, (Object)current, (Object)TableinstancePackage.eINSTANCE.getColumn_IsHidden(), (Object)false);
                if (!cmd2.canExecute()) continue;
                compoundCommand.append(cmd2);
            }
            for (Column current : columnsToHide) {
                if (current instanceof FeatureColumn) {
                    tmp = TableInstanceCommandFactory.getShowHideColumnCommand(natTableWidget, current, true, typeViewMap);
                    if (tmp == null || !tmp.canExecute()) continue;
                    compoundCommand.append(tmp);
                    continue;
                }
                cmd2 = commandFactory.createSetCommand(natTableWidget.getEditingDomain(), (Object)current, (Object)TableinstancePackage.eINSTANCE.getColumn_IsHidden(), (Object)true);
                if (!cmd2.canExecute()) continue;
                compoundCommand.append(cmd2);
            }
        } else {
            Command cmd3;
            for (Column current : columnsToShow) {
                cmd3 = commandFactory.createSetCommand(editingDomain, (Object)current, (Object)TableinstancePackage.eINSTANCE.getColumn_IsHidden(), (Object)false);
                if (!cmd3.canExecute()) continue;
                compoundCommand.append(cmd3);
            }
            for (Column current : columnsToHide) {
                cmd3 = commandFactory.createSetCommand(editingDomain, (Object)current, (Object)TableinstancePackage.eINSTANCE.getColumn_IsHidden(), (Object)true);
                if (!cmd3.canExecute()) continue;
                compoundCommand.append(cmd3);
            }
        }
        if (putOnTheTop && (cmd = TableInstanceCommandFactory.createPutLocalCustomizationOnTheTopCommand(natTableWidget)).canExecute()) {
            compoundCommand.append(cmd);
        }
        return compoundCommand;
    }

    public static Command createPutLocalCustomizationOnTheTopCommand(NatTableWidget natTableWidget) {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        List<MetamodelView> locals = natTableWidget.getLocalCustomizations();
        ArrayList<MetamodelView> views = new ArrayList<MetamodelView>();
        views.addAll((Collection<MetamodelView>)natTableWidget.getTableInstance().getCustomizations());
        views.removeAll(locals);
        views.addAll(0, locals);
        return commandFactory.createSetCommand(natTableWidget.getEditingDomain(), (Object)natTableWidget.getTableInstance(), (Object)TableinstancePackage.eINSTANCE.getTableInstance_Customizations(), views);
    }

    public static Command createSetFacetsCommand(Collection<Facet> facets, NatTableWidget natTableWidget) throws CoreException {
        return TableInstanceCommandFactory.createSetFacetsCommand(facets, null, natTableWidget);
    }

    public static Command createSetFacetsCommand(Collection<Facet> facets, List<EObject> newElements, NatTableWidget natTableWidget) throws CoreException {
        FacetAttributeColumn facetAttributeColumn;
        Command command;
        FacetReferenceColumn facetReferenceColumn;
        Command command2;
        CompoundCommand compoundCommand = new CompoundCommand();
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        TableInstance2 tableInstance = (TableInstance2)natTableWidget.getTableInstance();
        for (Facet facet : facets) {
            if (tableInstance.getFacets2().contains((Object)facet)) continue;
            command2 = commandFactory.createAddCommand(natTableWidget.getEditingDomain(), (Object)tableInstance, (Object)Tableinstance2Package.eINSTANCE.getTableInstance2_Facets2(), (Object)facet);
            compoundCommand.append(command2);
        }
        for (Facet facet : tableInstance.getFacets2()) {
            if (facets.contains(facet)) continue;
            command2 = commandFactory.createRemoveCommand(natTableWidget.getEditingDomain(), (Object)tableInstance, (Object)Tableinstance2Package.eINSTANCE.getTableInstance2_Facets2(), (Object)facet);
            compoundCommand.append(command2);
        }
        HashSet eReferences = new HashSet();
        HashSet eAttributes = new HashSet();
        ArrayList<Status> statusList = new ArrayList<Status>();
        ArrayList<EObject> elementsInTable = new ArrayList<EObject>();
        elementsInTable.addAll((Collection<EObject>)tableInstance.getElements());
        if (newElements != null) {
            elementsInTable.addAll(newElements);
        }
        for (EObject eObject : elementsInTable) {
            try {
                eAttributes.addAll(natTableWidget.getFacetContext().getAttributes(eObject));
                eReferences.addAll(natTableWidget.getFacetContext().getReferences(eObject));
            }
            catch (ModelQueryException e) {
                Status status = new Status(4, "org.eclipse.emf.facet.widgets.nattable", "An exception has occured while retrieving structural features of:" + eObject, (Throwable)e);
                statusList.add(status);
            }
        }
        if (!statusList.isEmpty()) {
            MultiStatus globalStatus = new MultiStatus("org.eclipse.emf.facet.widgets.nattable", 0, "An exception has occured while retrieving structural features of the eObjects", (Throwable)new Exception());
            throw new CoreException((IStatus)globalStatus);
        }
        for (Column c : tableInstance.getColumns()) {
            if (c instanceof FacetReferenceColumn) {
                facetReferenceColumn = (FacetReferenceColumn)c;
                if (eReferences.contains(facetReferenceColumn.getReference())) continue;
                command = commandFactory.createRemoveCommand(natTableWidget.getEditingDomain(), (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)c);
                compoundCommand.append(command);
                continue;
            }
            if (!(c instanceof FacetAttributeColumn) || eAttributes.contains((facetAttributeColumn = (FacetAttributeColumn)c).getAttribute())) continue;
            command = commandFactory.createRemoveCommand(natTableWidget.getEditingDomain(), (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)c);
            compoundCommand.append(command);
        }
        for (EAttribute eAttribute : eAttributes) {
            if (natTableWidget.isColumnAlreadyDeclared((EStructuralFeature)eAttribute)) continue;
            facetAttributeColumn = TableinstanceFactory.eINSTANCE.createFacetAttributeColumn();
            facetAttributeColumn.setAttribute((FacetAttribute)eAttribute);
            command = commandFactory.createAddCommand(natTableWidget.getEditingDomain(), (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)facetAttributeColumn);
            compoundCommand.append(command);
        }
        for (EReference eReference : eReferences) {
            if (natTableWidget.isColumnAlreadyDeclared((EStructuralFeature)eReference)) continue;
            facetReferenceColumn = TableinstanceFactory.eINSTANCE.createFacetReferenceColumn();
            facetReferenceColumn.setReference((FacetReference)eReference);
            command = commandFactory.createAddCommand(natTableWidget.getEditingDomain(), (Object)tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)facetReferenceColumn);
            compoundCommand.append(command);
        }
        if (!compoundCommand.isEmpty()) {
            return compoundCommand;
        }
        return null;
    }

    public static CompoundCommand createDropCommand(NatTableWidget natTableWidget, IStructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        CompoundCommand compoundCommand = new CompoundCommand();
        if (feature.isMany()) {
            for (Object object : structuredSelection) {
                Command addCommand = commandFactory.createAddCommand(editingDomain, element, (Object)feature, object);
                compoundCommand.append(addCommand);
            }
        } else if (structuredSelection.toList().size() == 1) {
            Object firstElement = structuredSelection.getFirstElement();
            Command addCommand = commandFactory.createSetCommand(editingDomain, element, (Object)feature, firstElement);
            compoundCommand.append(addCommand);
        }
        return compoundCommand;
    }

    public static Command getShowHideColumnCommand(NatTableWidget natTableWidget, Column column, Boolean newValue, HashMap<EClass, TypeView> typeViewMap) {
        Command cmd = null;
        if (column instanceof FeatureColumn && natTableWidget.getTableInstance() instanceof TableInstance2) {
            FeatureColumn featureColumn = (FeatureColumn)column;
            String customizedFeatureName = "visible";
            CompoundCommand comCommand = new CompoundCommand();
            EditingDomain editingDomain = natTableWidget.getEditingDomain();
            ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(editingDomain);
            EStructuralFeature featureOfTheColumn = featureColumn.getFeature();
            String customViewName = featureOfTheColumn.getName();
            MetamodelView metamodelView = null;
            EObject container = featureOfTheColumn.eContainer().eContainer();
            if (container instanceof EPackage) {
                EList metamodels = new ArrayList();
                metamodels = ((TableInstance2)natTableWidget.getTableInstance()).getLocalCustomizations();
                metamodelView = UicustomUtil.getMetamodelViewByEPackage((List)metamodels, (EPackage)((EPackage)container));
            }
            if (metamodelView != null) {
                EStructuralFeature feature = featureColumn.getFeature();
                EObject featureContainer = feature.eContainer();
                TypeView typeView = UicustomUtil.getTypeViewByQualifiedName((List)metamodelView.getTypes(), (EClass)((EClass)featureContainer));
                AttributeView customView = null;
                StaticFeatureValue featureValue = null;
                CustomViewFeature customViewFeature = null;
                CustomizableFeatures customizableFeature = null;
                if (typeView == null) {
                    typeView = typeViewMap.get(featureContainer);
                }
                if (typeView != null) {
                    if (featureColumn instanceof AttributeColumn || featureColumn instanceof FacetAttributeColumn) {
                        customView = UicustomUtil.getAttributeViewByEStructuralFeature((List)typeView.getAttributes(), (EStructuralFeature)featureColumn.getFeature());
                        if (customView != null && (customViewFeature = UicustomUtil.getCustomViewFeatureByName((List)customView.getCustomizedFeatures(), (String)customizedFeatureName)) != null) {
                            customizableFeature = customViewFeature.getCustomizedFeature();
                        }
                    } else if ((featureColumn instanceof ReferenceColumn || featureColumn instanceof FacetReferenceColumn) && (customView = UicustomUtil.getReferenceViewByEStructuralFeature((List)typeView.getReferences(), (EStructuralFeature)featureColumn.getFeature())) != null && (customViewFeature = UicustomUtil.getCustomViewFeatureByName((List)customView.getCustomizedFeatures(), (String)customizedFeatureName)) != null) {
                        customizableFeature = customViewFeature.getCustomizedFeature();
                    }
                }
                if (typeView == null) {
                    typeView = UicustomPackage.eINSTANCE.getUicustomFactory().createTypeView();
                    typeViewMap.put((EClass)featureContainer, typeView);
                    Command cmd0 = commandFactory.createAddCommand(editingDomain, (Object)metamodelView, (Object)UicustomPackage.eINSTANCE.getMetamodelView_Types(), (Object)typeView);
                    String elementQN = ModelUtils.getMetaclassQualifiedName((EClassifier)((EClass)featureContainer));
                    Command cmd1 = commandFactory.createSetCommand(editingDomain, (Object)typeView, (Object)UicustomPackage.eINSTANCE.getTypeView_MetaclassName(), (Object)elementQN);
                    comCommand.append(cmd0);
                    comCommand.append(cmd1);
                }
                Command subInstanceCommand = commandFactory.createSetCommand(editingDomain, (Object)typeView, (Object)UicustomPackage.eINSTANCE.getTypeView_AppliesToSubInstances(), (Object)new Boolean(true));
                comCommand.append(subInstanceCommand);
                if (customView == null) {
                    Command cmd3;
                    Command cmd2;
                    if (featureColumn instanceof AttributeColumn || featureColumn instanceof FacetAttributeColumn) {
                        customView = UicustomPackage.eINSTANCE.getUicustomFactory().createAttributeView();
                        cmd2 = commandFactory.createAddCommand(editingDomain, (Object)typeView, (Object)UicustomPackage.eINSTANCE.getTypeView_Attributes(), (Object)customView);
                        comCommand.append(cmd2);
                        cmd3 = commandFactory.createSetCommand(editingDomain, (Object)customView, (Object)UicustomPackage.eINSTANCE.getAttributeView_AttributeName(), (Object)customViewName);
                        comCommand.append(cmd3);
                    } else if (featureColumn instanceof ReferenceColumn || featureColumn instanceof FacetReferenceColumn) {
                        customView = UicustomPackage.eINSTANCE.getUicustomFactory().createReferenceView();
                        cmd2 = commandFactory.createAddCommand(editingDomain, (Object)typeView, (Object)UicustomPackage.eINSTANCE.getTypeView_References(), (Object)customView);
                        comCommand.append(cmd2);
                        cmd3 = commandFactory.createSetCommand(editingDomain, (Object)customView, (Object)UicustomPackage.eINSTANCE.getReferenceView_ReferenceName(), (Object)customViewName);
                        comCommand.append(cmd3);
                    }
                }
                if (customViewFeature == null) {
                    customViewFeature = UicustomPackage.eINSTANCE.getUicustomFactory().createCustomViewFeature();
                    Command cmd4 = commandFactory.createAddCommand(editingDomain, (Object)customView, (Object)UicustomPackage.eINSTANCE.getCustomView_CustomizedFeatures(), (Object)customViewFeature);
                    comCommand.append(cmd4);
                }
                if (customizableFeature == null) {
                    customizableFeature = CustomizableFeatures.getByName((String)customizedFeatureName);
                    Command cmd5 = commandFactory.createSetCommand(editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_CustomizedFeature(), (Object)customizableFeature);
                    comCommand.append(cmd5);
                }
                featureValue = UicustomPackage.eINSTANCE.getUicustomFactory().createStaticFeatureValue();
                Command cmd6 = commandFactory.createSetCommand(editingDomain, (Object)featureValue, (Object)UicustomPackage.eINSTANCE.getStaticFeatureValue_Value(), (Object)Boolean.toString(newValue == false));
                comCommand.append(cmd6);
                Command cmd7 = commandFactory.createSetCommand(editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_DefaultValue(), (Object)featureValue);
                comCommand.append(cmd7);
            }
            return comCommand;
        }
        return cmd;
    }

    private TableInstanceCommandFactory() {
    }
}

