/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.emf.facet.infra.browser.custom.ui.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.facet.infra.browser.custom.ui.Messages;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewCustomizationFilePage extends WizardNewFileCreationPage {

	// private Text nameField;

	public NewCustomizationFilePage(final IStructuredSelection selection) {
		super(Messages.NewCustomizationFilePage_browserCustomization, selection);
		setTitle(Messages.NewCustomizationFilePage_browserCustomization);
		setDescription(Messages.NewCustomizationFilePage_createsBrowserCustomization);
		setFileExtension("uiCustom"); //$NON-NLS-1$
	}

	@Override
	protected boolean validatePage() {
		boolean valid = super.validatePage();
		if (valid) {
			IPath containerFullPath = getContainerFullPath();
			if (!ProjectUtils.isInEmfFacetProject(containerFullPath)) {
				setMessage(
						Messages.NewCustomizationFilePage_customizationInNonEmfFacetProject,
						IMessageProvider.WARNING);
			}
		}
		return valid;
	}

	// @Override
	// public void createControl(Composite parent) {
	// super.createControl(parent);
	// Control control = getControl();
	// createNameGroup((Composite) control);
	// }

	// private void createNameGroup(Composite parent) {
	// Composite nameGroup = new Composite(parent, SWT.NONE);
	// nameGroup.setLayout(new GridLayout(2, false));
	// nameGroup.setLayoutData(new GridData(SWT.FILL, SWT.NONE, true, false));
	//
	// Label label = new Label(nameGroup, SWT.NONE);
	// label.setText("Customization Name:");
	//
	// nameField = new Text(nameGroup, SWT.BORDER);
	// nameField.addModifyListener(new ModifyListener() {
	// public void modifyText(ModifyEvent e) {
	// setPageComplete(validatePage());
	// }
	// });
	//
	// nameField.setLayoutData(new GridData(SWT.FILL, SWT.NONE, true, false));
	// }

	// @Override
	// protected boolean validatePage() {
	// boolean valid = super.validatePage();
	//
	// if (valid)
	// return validateName();
	// else
	// return false;
	// }
	//
	// protected boolean validateName() {
	// String name = nameField.getText();
	//
	// if (name.trim().length() == 0) {
	// setErrorMessage("Customization name cannot be empty");
	// return false;
	// } else {
	// setErrorMessage(null);
	// return true;
	// }
	// }
	//
	// public String getCustomizationName() {
	// return nameField.getText();
	// }
}
