/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal.listeners;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.TableInstanceCommandFactory;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryException;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryRuntimeException;
import org.eclipse.emf.facet.widgets.nattable.internal.listeners.TableInstanceListenerUtils;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;

public class RowDeleteTriggerListener
extends TriggerListener {
    protected static final String DEBUG_OPTION = "org.eclipse.emf.facet.widgets.nattable/debug/RowDeleteTriggerListener";
    protected static final boolean DEBUG = Activator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.widgets.nattable/debug/RowDeleteTriggerListener"));
    private TableInstance tableInstance;

    public RowDeleteTriggerListener(TableInstance tableInstance) {
        this.tableInstance = tableInstance;
    }

    protected Command trigger(TransactionalEditingDomain transactionalEditingDomain, Notification notification) {
        if (DEBUG) {
            System.out.println("RowDeleteTriggerListener.trigger(): notification=" + notification);
        }
        CompoundCommand command = null;
        if (DEBUG && notification.getEventType() == 4) {
            System.out.println("RowDeleteTriggerListener.trigger(): set notification.feature=" + notification.getFeature());
            System.out.println("RowDeleteTriggerListener.trigger(): set notification.oldvalue=" + notification.getOldValue());
            System.out.println("RowDeleteTriggerListener.trigger(): set notification.notifier.type=" + notification.getNotifier().getClass().getSimpleName());
        }
        if (notification.getEventType() == 4) {
            List<Row> rowObservingADeletedEObject = TableInstanceListenerUtils.getRowsRepresentingADeletedEObject((List<Row>)this.tableInstance.getRows());
            if (DEBUG) {
                System.out.println("RowDeleteTriggerListener.trigger(): rowObservingADeletedEObject=" + rowObservingADeletedEObject);
            }
            if (!rowObservingADeletedEObject.isEmpty()) {
                command = new CompoundCommand();
                ICommandFactory commadFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor((EditingDomain)transactionalEditingDomain);
                RowDeleteCommand removeRowCommand = new RowDeleteCommand((EditingDomain)transactionalEditingDomain, rowObservingADeletedEObject);
                command.append((Command)removeRowCommand);
                try {
                    CompoundCommand removeColumnCommand = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(this.tableInstance, rowObservingADeletedEObject, commadFactory, (EditingDomain)transactionalEditingDomain);
                    if (removeColumnCommand != null) {
                        command.append((Command)removeColumnCommand);
                    }
                }
                catch (MultiModelQueryException e) {
                    throw new MultiModelQueryRuntimeException(e);
                }
                if (!command.canExecute()) {
                    throw new RuntimeException("Unexpected unexecutable command");
                }
            }
        }
        return command;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowDeleteCommand
    extends DeleteCommand {
        public RowDeleteCommand(EditingDomain domain, Collection<?> collection) {
            super(domain, collection);
        }
    }
}

