/*******************************************************************************
 * Copyright (c) 2011 Mia-Software
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - Bug 355951 - Wizard to create EMF Facet plug-ins
 *******************************************************************************/
package org.eclipse.emf.facet.dev.ui.internal.wizard;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.dev.core.internal.INewPluginCreator;
import org.eclipse.emf.facet.dev.ui.internal.Activator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewEmfFacetPluginWizard extends Wizard implements INewWizard {

	private final NewEmfFacetPluginPage fPage;

	protected NewEmfFacetPluginPage createPage() {
		return new NewEmfFacetPluginPage();
	}

	public NewEmfFacetPluginWizard() {
		this.fPage = createPage();
	}

	public void init(final IWorkbench workbench, final IStructuredSelection selection) {
		// nothing to do
	}

	@Override
	public void addPages() {
		addPage(this.fPage);
	}

	@Override
	public boolean performFinish() {
		this.fPage.save();
		final String id = this.fPage.getId();
		final String name;
		if (!this.fPage.getName().trim().endsWith("(Incubation)")) { //$NON-NLS-1$
			name = this.fPage.getName().trim() + " (Incubation)"; //$NON-NLS-1$
		} else {
			name = this.fPage.getName();
		}
		final String version = this.fPage.getVersion();
		final String provider = this.fPage.getProvider();
		final boolean javaNatureEnabled = this.fPage.getJavaNatureEnabled();

		try {
			getContainer().run(true, false, new IRunnableWithProgress() {
				public void run(final IProgressMonitor monitor) {
					createProject(id, name, version, provider, javaNatureEnabled, monitor);
				}
			});
		} catch (Exception e) {
			Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Error creating new plug-in", e)); //$NON-NLS-1$
		}
		return true;
	}

	@Override
	public boolean performCancel() {
		this.fPage.save();
		return super.performCancel();
	}

	protected void createProject(final String id, final String name, final String version, final String provider, final boolean javaNatureEnabled, final IProgressMonitor monitor) {
		INewPluginCreator.INSTANCE.createProject(id, name, version, provider, javaNatureEnabled, monitor);
	}

}
