/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.custom.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.custom.AttributeView;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.CustomizableFeatures;
import org.eclipse.emf.facet.infra.browser.custom.FeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.FeatureValueCase;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ReferenceView;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.util.OverlayIconInfo;
import org.eclipse.emf.facet.infra.browser.custom.util.OverlayIconPosition;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class UicustomUtil {
    private static final int MAX_COLOR_INTENSITY = 255;
    private static final Pattern RGB_PATTERN = Pattern.compile("\\((\\d+),(\\d+),(\\d+)\\)");
    private static final int RGB_PATTERN_GROUP_RED = 1;
    private static final int RGB_PATTERN_GROUP_GREEN = 2;
    private static final int RGB_PATTERN_GROUP_BLUE = 3;

    private UicustomUtil() {
    }

    public static RGB decodeColor(String strColor) {
        Matcher matcher = RGB_PATTERN.matcher(strColor);
        if (matcher.matches()) {
            try {
                int r = Integer.parseInt(matcher.group(1));
                int g = Integer.parseInt(matcher.group(2));
                int b = Integer.parseInt(matcher.group(3));
                if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255) {
                    return new RGB(r, g, b);
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static OverlayIconInfo decodeOverlayIcon(String encodedOverlayIcon) {
        String[] parts = encodedOverlayIcon.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("overlay icon should be encoded as 'path:position'");
        }
        return new OverlayIconInfo(parts[0], OverlayIconPosition.valueOf(parts[1]));
    }

    public static String encodeOverlayIcon(String path, OverlayIconPosition iconPosition) {
        return String.valueOf(path) + ":" + (Object)((Object)iconPosition);
    }

    public static CustomizableFeatures getCustomizedFeature(FeatureValue featureValue) {
        CustomViewFeature feature = featureValue.getFeature();
        if (feature == null) {
            return featureValue.getCase().getFeature().getCustomizedFeature();
        }
        return feature.getCustomizedFeature();
    }

    public static FeatureValue getFeatureValue(Object element) {
        if (element instanceof CustomViewFeature) {
            CustomViewFeature customViewFeature = (CustomViewFeature)element;
            return customViewFeature.getDefaultValue();
        }
        if (element instanceof FeatureValueCase) {
            FeatureValueCase valueCase = (FeatureValueCase)element;
            return valueCase.getValue();
        }
        return null;
    }

    public static MetamodelView getMetamodelViewByEPackage(List<MetamodelView> metamodels, EPackage ePackage) {
        if (ePackage != null) {
            for (MetamodelView current : metamodels) {
                if (current == null || !current.getMetamodelURI().equals(ePackage.getNsURI())) continue;
                return current;
            }
        }
        return null;
    }

    public static TypeView getTypeViewByQualifiedName(List<TypeView> typeViews, EClass eClass) {
        if (eClass != null) {
            for (TypeView current : typeViews) {
                if (current == null || !current.getMetaclassName().equals(ModelUtils.getMetaclassQualifiedName((EClassifier)eClass))) continue;
                return current;
            }
        }
        return null;
    }

    public static AttributeView getAttributeViewByEStructuralFeature(List<AttributeView> attributeViews, EStructuralFeature feature) {
        if (feature != null) {
            for (AttributeView current : attributeViews) {
                if (current == null || !current.getAttributeName().equals(feature.getName())) continue;
                return current;
            }
        }
        return null;
    }

    public static ReferenceView getReferenceViewByEStructuralFeature(List<ReferenceView> referenceViews, EStructuralFeature feature) {
        if (feature != null) {
            for (ReferenceView current : referenceViews) {
                if (current == null || !current.getReferenceName().equals(feature.getName())) continue;
                return current;
            }
        }
        return null;
    }

    public static CustomViewFeature getCustomViewFeatureByName(List<CustomViewFeature> customViewFeatures, String customizedFeatureName) {
        for (CustomViewFeature current : customViewFeatures) {
            if (current == null || !current.getCustomizedFeature().getName().equals(customizedFeatureName)) continue;
            return current;
        }
        return null;
    }
}

