/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.facet.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.facet.ui.Activator;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

/**
 * @deprecated all the emf.facet.infra.* plug-ins are deprecated. Use the
 *             classes in org.eclipse.emf.facet.efacet.ui instead
 */
@Deprecated
public class LoadFacetsDialog extends CheckedTreeSelectionDialog {
	private static final String LOAD_FACETS_DIALOG = "LoadFacetsDialog"; //$NON-NLS-1$
	private static final String EXPANDED_ELEMENTS = "expandedElements"; //$NON-NLS-1$

	// private Label messageArea;
	// private Composite selectionButtons;

	public LoadFacetsDialog(final Shell parent, final ILabelProvider labelProvider,
			final ITreeContentProvider contentProvider, final Collection<EPackage> ePackages) {
		super(parent, labelProvider, contentProvider);
		// show only Facets corresponding to the current EPackages or
		// referenced EPackages
		final Set<EPackage> allReferencedPackages = new HashSet<EPackage>();

		for (EPackage ePackage : ePackages) {
			allReferencedPackages.add(ePackage);
			final Set<EPackage> referencedPackages = ModelUtils.computeReferencedPackages(ePackage);
			allReferencedPackages.addAll(referencedPackages);
		}

		addFilter(new ViewerFilter() {
			@Override
			public boolean select(final Viewer viewer, final Object parentElement,
					final Object element) {
				if (element instanceof FacetSet) {
					FacetSet facetSet = (FacetSet) element;
					if (facetSet.getExtendedPackage() == null) {
						return true;
					}
					EPackage extendedPackage = facetSet.getExtendedPackage();
					return allReferencedPackages.contains(extendedPackage);
				}
				return true;
			}
		});
	}

	@Override
	public int open() {
		restoreExpandedElements();
		return super.open();
	}

	@Override
	public boolean close() {
		saveExpandedElements();
		return super.close();
	}

	public void saveExpandedElements() {
		try {
			String filename = getSettingsFilename();
			DialogSettings settings = new DialogSettings(LoadFacetsDialog.LOAD_FACETS_DIALOG);

			List<String> expandedFacetSets = new ArrayList<String>();

			Object[] expandedElements = getTreeViewer().getExpandedElements();
			for (Object expandedElement : expandedElements) {
				if (expandedElement instanceof FacetSet) {
					FacetSet facetSet = (FacetSet) expandedElement;
					expandedFacetSets.add(facetSet.getName());
				}
			}
			String[] array = expandedFacetSets.toArray(new String[expandedFacetSets.size()]);
			settings.put(LoadFacetsDialog.EXPANDED_ELEMENTS, array);
			settings.save(filename);
		} catch (Exception e) {
			Logger.logError(e, Activator.getDefault());
		}
	}

	private String getSettingsFilename() {
		IPath stateLocation = Activator.getDefault().getStateLocation();
		String filename = stateLocation.append(LoadFacetsDialog.LOAD_FACETS_DIALOG).toOSString();
		return filename;
	}

	public void restoreExpandedElements() {
		try {
			String filename = getSettingsFilename();
			DialogSettings settings = new DialogSettings(LoadFacetsDialog.LOAD_FACETS_DIALOG);
			if (new File(filename).isFile()) {
				settings.load(filename);
				String[] array = settings.getArray(LoadFacetsDialog.EXPANDED_ELEMENTS);

				final Collection<FacetSet> facetSets = FacetSetCatalog.getSingleton()
						.getAllFacetSets();
				final List<FacetSet> expandedFacetSets = new ArrayList<FacetSet>();
				for (String expandedFacetSetName : array) {
					for (FacetSet facetSet : facetSets) {
						if (facetSet.getName() != null
								&& facetSet.getName().equals(expandedFacetSetName)) {
							expandedFacetSets.add(facetSet);
						}
					}
				}
				setExpandedElements(expandedFacetSets.toArray());
			}
		} catch (Exception e) {
			Logger.logError(e, Activator.getDefault());
		}
	}

	// @Override
	// public void setInput(final Object input) {
	// super.setInput(input);
	// getTreeViewer().setInput(input);
	// if (input != null) {
	//				//this.messageArea.setText(""); //$NON-NLS-1$
	// this.messageArea.setEnabled(true);
	// this.selectionButtons.setEnabled(true);
	// getTreeViewer().getTree().setEnabled(true);
	// }
	// }
	//
	// public void refresh() {
	// getTreeViewer().refresh();
	// }
	//
	// @Override
	// protected Label createMessageArea(final Composite composite) {
	// this.messageArea = super.createMessageArea(composite);
	// return this.messageArea;
	// }
	//
	// @Override
	// protected Composite createSelectionButtons(final Composite composite)
	// {
	// this.selectionButtons = super.createSelectionButtons(composite);
	// return this.selectionButtons;
	// }
}