/**
 * Copyright (c) 2011 Mia-Software.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 	Nicolas Guyomar (Mia-Software) - Bug 349556 - EMF Facet Java Query wizard
 */
package org.eclipse.emf.facet.query.java.ui.internal.wizard.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.Query;
import org.eclipse.emf.facet.efacet.ui.internal.composites.BrowseComposite;
import org.eclipse.emf.facet.efacet.ui.internal.exported.wizard.IQueryCreationPagePart;
import org.eclipse.emf.facet.query.java.javaquery.JavaQuery;
import org.eclipse.emf.facet.query.java.javaquery.JavaqueryFactory;
import org.eclipse.emf.facet.query.java.ui.internal.Activator;
import org.eclipse.emf.facet.query.java.ui.internal.Messages;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.SelectOrCreateJavaClassWizard;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.IJavaElementSearchConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JavaQueryWizardPagePart implements IQueryCreationPagePart {

	private static final String I_JAVA_QUERY = "IJavaQuery"; //$NON-NLS-1$

	private FacetSet facetSet;
	private String queryName;
	private String implementationClassName;
	private int lowerBound;
	private int upperBound;
	private boolean canBeCached;
	private boolean hasSideEffect;
	private EClassifier queryType;
	private EClass scope;
	private boolean fOrdered = false;
	private boolean fUnique = false;

	private SelectOrCreateJavaClassWizard wizardClassCreationWizard;

	private String errorMessage;

	private List<ModifyListener> listeners = new ArrayList<ModifyListener>();

	public JavaQueryWizardPagePart() {
	}

	public Query performFinish() {

		if (this.wizardClassCreationWizard != null) {
			this.wizardClassCreationWizard.setUpperBound(this.upperBound);
			this.wizardClassCreationWizard.setEType(this.queryType);
			this.wizardClassCreationWizard.setScope(this.scope);
			this.wizardClassCreationWizard.createJavaClass();
		}

		JavaQuery query = JavaqueryFactory.eINSTANCE.createJavaQuery();
		query.setName(this.queryName);
		query.setImplementationClassName(this.implementationClassName);
		query.setLowerBound(this.lowerBound);
		query.setUpperBound(this.upperBound);
		query.setCanBeCached(this.canBeCached);
		query.setHasSideEffect(this.hasSideEffect);
		query.setEType(this.queryType);
		query.setScope(this.scope);
		query.setUnique(this.fUnique);
		query.setOrdered(this.fOrdered);

		return query;
	}

	public void completeComposite(final Composite parent) {

		// Scope selection section
		Label javaClassLabel = new Label(parent, SWT.NONE);
		javaClassLabel.setText(Messages.JavaQueryWizardPage_Java_Class_Name);

		final BrowseComposite browseCompositeForJavaClass = new BrowseComposite(parent, SWT.BORDER) {

			@Override
			protected void handleBrowse() {
				if (handleCreateQueryClass()) {
					updateTextFieldContent(getImplementationClassName());
					notifyCompositeListeners(parent);
				}
			}
		};
		if (this.implementationClassName != null) {
			browseCompositeForJavaClass.updateTextFieldContent(this.implementationClassName);
		}

		// Scope selection section
		Label dummyLabel2 = new Label(parent, SWT.NONE);
		dummyLabel2.setText(new String());
	}

	protected boolean handleCreateQueryClass() {
		try {
			this.wizardClassCreationWizard = new SelectOrCreateJavaClassWizard(this.facetSet, this.queryName, false);
			this.wizardClassCreationWizard.setEType(this.queryType);
			if (this.wizardClassCreationWizard.open() != Window.CANCEL) {
				if (this.wizardClassCreationWizard.isSelectExistingJavaClass()) {
					return handleSelectImplClass();
				}
				updateImplClassName(this.wizardClassCreationWizard.getImplementationClassName());
				this.errorMessage = null;
				return true;
			}
			this.wizardClassCreationWizard = null;

		} catch (Exception e) {
			Logger.logError(e, Activator.getDefault());
			return false;
		}
		return false;
	}

	protected boolean handleSelectImplClass() {
		Shell shell = Display.getCurrent().getActiveShell();
		try {
			SelectionDialog dialog = JavaUI.createTypeDialog(shell, new ProgressMonitorDialog(shell), SearchEngine.createWorkspaceScope(),
					IJavaElementSearchConstants.CONSIDER_CLASSES, false);
			dialog.open();
			if (dialog.getReturnCode() != Window.CANCEL) {
				Object test = dialog.getResult()[0];
				if (test instanceof IType) {
					IType sourceType = (IType) test;
					String[] superInterfaceName = sourceType.getSuperInterfaceNames();
					List<String> list = Arrays.asList(superInterfaceName);
					for (String interfaceName : list) {
						if (interfaceName.startsWith(JavaQueryWizardPagePart.I_JAVA_QUERY)) {
							updateImplClassName(sourceType.getFullyQualifiedName());
							this.wizardClassCreationWizard = null;
							return true;
						}
					}
					updateImplClassName(""); //$NON-NLS-1$
					return false;
				}
			}
		} catch (JavaModelException e) {
			Logger.logError(e, Activator.getDefault());
		}
		return false;
	}

	public boolean isCompositeComplete() {
		if (this.implementationClassName == null || this.implementationClassName.length() == 0) {
			this.errorMessage = Messages.JavaQueryWizardPage_Please_select_create_IJavaQuery_Class;
			return false;
		}
		this.errorMessage = null;
		return true;
	}

	public String getErrorMessage() {
		return this.errorMessage;
	}

	private void updateImplClassName(final String fullyQualifiedName) {
		this.implementationClassName = fullyQualifiedName;
	}

	public void setUpperBound(final int upperBound) {
		this.upperBound = upperBound;
	}

	public void setLowerBound(final int lowerBound) {
		this.lowerBound = lowerBound;
	}

	public void setQueryType(final EClassifier queryType) {
		this.queryType = queryType;
	}

	public void setCanBeCached(final boolean canBeCached) {
		this.canBeCached = canBeCached;
	}

	public void setHasSideEffect(final boolean hasSideEffect) {
		this.hasSideEffect = hasSideEffect;
	}

	public void setFacetSet(final FacetSet facetSet) {
		this.facetSet = facetSet;
	}

	public void setQueryName(final String queryName) {
		this.queryName = queryName;
	}

	protected String getImplementationClassName() {
		return this.implementationClassName;
	}

	public void addModifyListener(final ModifyListener listener) {
		this.listeners.add(listener);
	}

	public void removeModifyListener(final ModifyListener listener) {
		this.listeners.remove(listener);
	}

	public void notifyCompositeListeners(final Composite modifiedComposite) {
		for (ModifyListener listener : this.listeners) {
			Event e = new Event();
			e.widget = modifiedComposite;
			listener.modifyText(new ModifyEvent(e));
		}
	}

	public void setQueryScope(final EClass type) {
		this.scope = type;
	}

	public void setOrdered(final boolean fOrdered2) {
		this.fOrdered = fOrdered2;
	}

	public void setUnique(final boolean fUnique2) {
		this.fUnique = fUnique2;
	}
}
