/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 *   Nicolas Guyomar (Mia-Software) - Bug 340941 - Need new row and column types in the table
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Factory
 * @model kind="package"
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public interface Tableinstance2Package extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "tableinstance2";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/EMF_Facet/Table/0.1.0/tableinstance2";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "tableinstance2";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	Tableinstance2Package eINSTANCE = org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.TableInstance2Impl <em>Table Instance2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.TableInstance2Impl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getTableInstance2()
	 * @generated
	 */
	int TABLE_INSTANCE2 = 0;

	/**
	 * The feature id for the '<em><b>Table Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__TABLE_CONFIGURATION = TableinstancePackage.TABLE_INSTANCE__TABLE_CONFIGURATION;

	/**
	 * The feature id for the '<em><b>Customizations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__CUSTOMIZATIONS = TableinstancePackage.TABLE_INSTANCE__CUSTOMIZATIONS;

	/**
	 * The feature id for the '<em><b>Facets</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__FACETS = TableinstancePackage.TABLE_INSTANCE__FACETS;

	/**
	 * The feature id for the '<em><b>Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__CONTEXT = TableinstancePackage.TABLE_INSTANCE__CONTEXT;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__PARAMETER = TableinstancePackage.TABLE_INSTANCE__PARAMETER;

	/**
	 * The feature id for the '<em><b>Hide Empty Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__HIDE_EMPTY_COLUMNS = TableinstancePackage.TABLE_INSTANCE__HIDE_EMPTY_COLUMNS;

	/**
	 * The feature id for the '<em><b>Only Show Common Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__ONLY_SHOW_COMMON_COLUMNS = TableinstancePackage.TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__DESCRIPTION = TableinstancePackage.TABLE_INSTANCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__COLUMNS = TableinstancePackage.TABLE_INSTANCE__COLUMNS;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__ROWS = TableinstancePackage.TABLE_INSTANCE__ROWS;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__ELEMENTS = TableinstancePackage.TABLE_INSTANCE__ELEMENTS;

	/**
	 * The feature id for the '<em><b>Local Customization</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__LOCAL_CUSTOMIZATION = TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION;

	/**
	 * The feature id for the '<em><b>Local Customizations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS = TableinstancePackage.TABLE_INSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Facets2</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2__FACETS2 = TableinstancePackage.TABLE_INSTANCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Table Instance2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE2_FEATURE_COUNT = TableinstancePackage.TABLE_INSTANCE_FEATURE_COUNT + 2;


	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryRowImpl <em>Query Row</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryRowImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getQueryRow()
	 * @generated
	 */
	int QUERY_ROW = 1;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_ROW__ELEMENT = TableinstancePackage.ROW__ELEMENT;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_ROW__HEIGHT = TableinstancePackage.ROW__HEIGHT;

	/**
	 * The feature id for the '<em><b>Query Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_ROW__QUERY_RESULT = TableinstancePackage.ROW_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Query Row</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_ROW_FEATURE_COUNT = TableinstancePackage.ROW_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.PrimitiveTypeQueryRowImpl <em>Primitive Type Query Row</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.PrimitiveTypeQueryRowImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getPrimitiveTypeQueryRow()
	 * @generated
	 */
	int PRIMITIVE_TYPE_QUERY_ROW = 2;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_QUERY_ROW__ELEMENT = QUERY_ROW__ELEMENT;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_QUERY_ROW__HEIGHT = QUERY_ROW__HEIGHT;

	/**
	 * The feature id for the '<em><b>Query Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_QUERY_ROW__QUERY_RESULT = QUERY_ROW__QUERY_RESULT;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_QUERY_ROW__VALUE = QUERY_ROW_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Primitive Type Query Row</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_QUERY_ROW_FEATURE_COUNT = QUERY_ROW_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.EObjectQueryRowImpl <em>EObject Query Row</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.EObjectQueryRowImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getEObjectQueryRow()
	 * @generated
	 */
	int EOBJECT_QUERY_ROW = 3;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_QUERY_ROW__ELEMENT = QUERY_ROW__ELEMENT;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_QUERY_ROW__HEIGHT = QUERY_ROW__HEIGHT;

	/**
	 * The feature id for the '<em><b>Query Result</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_QUERY_ROW__QUERY_RESULT = QUERY_ROW__QUERY_RESULT;

	/**
	 * The number of structural features of the '<em>EObject Query Row</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_QUERY_ROW_FEATURE_COUNT = QUERY_ROW_FEATURE_COUNT + 0;


	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.ValueColumnImpl <em>Value Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.ValueColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getValueColumn()
	 * @generated
	 */
	int VALUE_COLUMN = 4;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_COLUMN__IS_HIDDEN = TableinstancePackage.COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_COLUMN__WIDTH = TableinstancePackage.COLUMN__WIDTH;

	/**
	 * The number of structural features of the '<em>Value Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_COLUMN_FEATURE_COUNT = TableinstancePackage.COLUMN_FEATURE_COUNT + 0;


	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryTableInstance2Impl <em>Query Table Instance2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryTableInstance2Impl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getQueryTableInstance2()
	 * @generated
	 */
	int QUERY_TABLE_INSTANCE2 = 5;

	/**
	 * The feature id for the '<em><b>Table Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__TABLE_CONFIGURATION = TableinstancePackage.QUERY_TABLE_INSTANCE__TABLE_CONFIGURATION;

	/**
	 * The feature id for the '<em><b>Customizations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__CUSTOMIZATIONS = TableinstancePackage.QUERY_TABLE_INSTANCE__CUSTOMIZATIONS;

	/**
	 * The feature id for the '<em><b>Facets</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__FACETS = TableinstancePackage.QUERY_TABLE_INSTANCE__FACETS;

	/**
	 * The feature id for the '<em><b>Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__CONTEXT = TableinstancePackage.QUERY_TABLE_INSTANCE__CONTEXT;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__PARAMETER = TableinstancePackage.QUERY_TABLE_INSTANCE__PARAMETER;

	/**
	 * The feature id for the '<em><b>Hide Empty Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__HIDE_EMPTY_COLUMNS = TableinstancePackage.QUERY_TABLE_INSTANCE__HIDE_EMPTY_COLUMNS;

	/**
	 * The feature id for the '<em><b>Only Show Common Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__ONLY_SHOW_COMMON_COLUMNS = TableinstancePackage.QUERY_TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__DESCRIPTION = TableinstancePackage.QUERY_TABLE_INSTANCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__COLUMNS = TableinstancePackage.QUERY_TABLE_INSTANCE__COLUMNS;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__ROWS = TableinstancePackage.QUERY_TABLE_INSTANCE__ROWS;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__ELEMENTS = TableinstancePackage.QUERY_TABLE_INSTANCE__ELEMENTS;

	/**
	 * The feature id for the '<em><b>Local Customization</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATION = TableinstancePackage.QUERY_TABLE_INSTANCE__LOCAL_CUSTOMIZATION;

	/**
	 * The feature id for the '<em><b>Query Results</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__QUERY_RESULTS = TableinstancePackage.QUERY_TABLE_INSTANCE__QUERY_RESULTS;

	/**
	 * The feature id for the '<em><b>Local Customizations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS = TableinstancePackage.QUERY_TABLE_INSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Facets2</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__FACETS2 = TableinstancePackage.QUERY_TABLE_INSTANCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Query Results2</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2__QUERY_RESULTS2 = TableinstancePackage.QUERY_TABLE_INSTANCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Query Table Instance2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE2_FEATURE_COUNT = TableinstancePackage.QUERY_TABLE_INSTANCE_FEATURE_COUNT + 3;


	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2 <em>Table Instance2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Table Instance2</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2
	 * @generated
	 */
	EClass getTableInstance2();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2#getLocalCustomizations <em>Local Customizations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Local Customizations</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2#getLocalCustomizations()
	 * @see #getTableInstance2()
	 * @generated
	 */
	EReference getTableInstance2_LocalCustomizations();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2#getFacets2 <em>Facets2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Facets2</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2#getFacets2()
	 * @see #getTableInstance2()
	 * @generated
	 */
	EReference getTableInstance2_Facets2();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow <em>Query Row</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Row</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow
	 * @generated
	 */
	EClass getQueryRow();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow#getQueryResult <em>Query Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Query Result</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow#getQueryResult()
	 * @see #getQueryRow()
	 * @generated
	 */
	EReference getQueryRow_QueryResult();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow <em>Primitive Type Query Row</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Primitive Type Query Row</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow
	 * @generated
	 */
	EClass getPrimitiveTypeQueryRow();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow#getValue()
	 * @see #getPrimitiveTypeQueryRow()
	 * @generated
	 */
	EAttribute getPrimitiveTypeQueryRow_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow <em>EObject Query Row</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EObject Query Row</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow
	 * @generated
	 */
	EClass getEObjectQueryRow();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn <em>Value Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn
	 * @generated
	 */
	EClass getValueColumn();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2 <em>Query Table Instance2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Table Instance2</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2
	 * @generated
	 */
	EClass getQueryTableInstance2();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2#getQueryResults2 <em>Query Results2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Query Results2</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2#getQueryResults2()
	 * @see #getQueryTableInstance2()
	 * @generated
	 */
	EReference getQueryTableInstance2_QueryResults2();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	Tableinstance2Factory getTableinstance2Factory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Deprecated
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.TableInstance2Impl <em>Table Instance2</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.TableInstance2Impl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getTableInstance2()
		 * @generated
		 */
		EClass TABLE_INSTANCE2 = eINSTANCE.getTableInstance2();

		/**
		 * The meta object literal for the '<em><b>Local Customizations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS = eINSTANCE.getTableInstance2_LocalCustomizations();

		/**
		 * The meta object literal for the '<em><b>Facets2</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE2__FACETS2 = eINSTANCE.getTableInstance2_Facets2();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryRowImpl <em>Query Row</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryRowImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getQueryRow()
		 * @generated
		 */
		EClass QUERY_ROW = eINSTANCE.getQueryRow();

		/**
		 * The meta object literal for the '<em><b>Query Result</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_ROW__QUERY_RESULT = eINSTANCE.getQueryRow_QueryResult();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.PrimitiveTypeQueryRowImpl <em>Primitive Type Query Row</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.PrimitiveTypeQueryRowImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getPrimitiveTypeQueryRow()
		 * @generated
		 */
		EClass PRIMITIVE_TYPE_QUERY_ROW = eINSTANCE.getPrimitiveTypeQueryRow();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRIMITIVE_TYPE_QUERY_ROW__VALUE = eINSTANCE.getPrimitiveTypeQueryRow_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.EObjectQueryRowImpl <em>EObject Query Row</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.EObjectQueryRowImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getEObjectQueryRow()
		 * @generated
		 */
		EClass EOBJECT_QUERY_ROW = eINSTANCE.getEObjectQueryRow();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.ValueColumnImpl <em>Value Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.ValueColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getValueColumn()
		 * @generated
		 */
		EClass VALUE_COLUMN = eINSTANCE.getValueColumn();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryTableInstance2Impl <em>Query Table Instance2</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryTableInstance2Impl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.Tableinstance2PackageImpl#getQueryTableInstance2()
		 * @generated
		 */
		EClass QUERY_TABLE_INSTANCE2 = eINSTANCE.getQueryTableInstance2();

		/**
		 * The meta object literal for the '<em><b>Query Results2</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_TABLE_INSTANCE2__QUERY_RESULTS2 = eINSTANCE.getQueryTableInstance2_QueryResults2();

	}

} //Tableinstance2Package
