/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire Dupe (Mia-Software) - Bug 366367 - To be able to change the "CanBePresentedInTheTable" query
 *    Nicolas Bros (Mia-Software) - Bug 366367 - To be able to change the "CanBePresentedInTheTable" query
 *****************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.exported;

import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;

/**
 * Internal interface for a dialog that allows the user to select a
 * presentability query. This dialog opens a second dialog to ask the user
 * whether to remove non-conforming elements.
 * 
 * @since 0.2
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public interface ICanBePresentedQueryDialog {

	/** Programmatically emulate a press on the OK button */
	IMustRemoveNonConformingElementsDialog pressOk();

	/** Programmatically emulate a press on the cancel button */
	void pressCancel();

	/**
	 * @return the selected query or <code>null</code> if no query has been
	 *         selected.
	 */
	ModelQuery getSelectedQuery();
	
	/**
	 * @return {@link Window#OK} if the user clicked OK, or {@link Window#CANCEL}
	 *         if the user cancelled the dialog
	 */
	int getReturnCode();

	/** @return whether the user chose to remove the non-conforming elements */
	boolean getMustRemoveNonConformingElements();

	/** Programmatically select the given query in the dialog */
	void select(ModelQuery query);

	/** Add a listener that will be notified when the dialog is closed */
	void addListener(Runnable runnable);

	/** Open the dialog */
	void open();

	/** @return a shell to which the dialog is linked */
	Shell getShell();
}
