/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.core.internal.exported.StringUtils;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.CustomizableLabelProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElementWithContext;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class TableLabelProvider {
    private static final int MAX_DISPLAYED_ELEMENTS = 5;
    private final List<Column> columns;
    private final CustomizableLabelProvider labelProvider;
    private FacetContext facetContext;

    public TableLabelProvider(List<Column> columns, CustomizationEngine customizationEngine, FacetContext facetContext) {
        this.columns = columns;
        this.labelProvider = new CustomizableLabelProvider(customizationEngine);
        this.facetContext = facetContext;
    }

    public String getTextFor(Object element) {
        if (element == null) {
            return "null";
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return this.labelProvider.getText(eObject);
        }
        return element.toString();
    }

    public Image getImageFor(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return this.labelProvider.getImage(eObject);
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex < this.columns.size()) {
            Column columnDescription = this.columns.get(columnIndex);
            GridElement gridElement = (GridElement)element;
            Object gridElementElement = gridElement.getElement();
            if (gridElementElement == null) {
                return null;
            }
            if (columnDescription instanceof DefaultLabelColumn) {
                return this.getImageFor(gridElement.getElement());
            }
            if (columnDescription instanceof ReferenceColumn) {
                EReference reference = ((ReferenceColumn)columnDescription).getReference();
                EObject eObject = (EObject)gridElement.getElement();
                if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                    return null;
                }
                Object refValue = eObject.eGet((EStructuralFeature)reference);
                if (reference.isMany()) {
                    EList list = (EList)refValue;
                    if (list.size() == 1) {
                        return this.getImageFor(list.get(0));
                    }
                    return null;
                }
                if (refValue != null) {
                    return this.getImageFor(refValue);
                }
            } else {
                if (columnDescription instanceof EContainerColumn) {
                    return this.getImageFor(((EObject)gridElement.getElement()).eContainer());
                }
                if (columnDescription instanceof ContextColumn) {
                    return this.getContextColumnImage(gridElement);
                }
                return null;
            }
        }
        return null;
    }

    public String getColumnText(GridElement gridElement, int columnIndex) {
        if (columnIndex >= this.columns.size()) {
            throw new IndexOutOfBoundsException();
        }
        Column column = this.columns.get(columnIndex);
        Object element = gridElement.getElement();
        if (element == null) {
            return "null";
        }
        if (column instanceof DefaultLabelColumn) {
            return this.getTextFor(gridElement.getElement());
        }
        if (column instanceof ReferenceColumn) {
            return this.getReferenceColumnText(gridElement.getElement(), column);
        }
        if (column instanceof EContainerColumn) {
            return this.getTextFor(((EObject)gridElement.getElement()).eContainer());
        }
        if (column instanceof ContextColumn) {
            return this.getContextColumnText(gridElement);
        }
        if (column instanceof AttributeColumn) {
            return this.getAttributeColumnText(gridElement.getElement(), column);
        }
        if (column instanceof MetaClassColumn) {
            return TableLabelProvider.getMetaclassColumnText(gridElement.getElement());
        }
        if (column instanceof QueryColumn) {
            if (gridElement.getElement() instanceof EObject) {
                EObject eObject = (EObject)gridElement.getElement();
                QueryColumn queryColumn = (QueryColumn)column;
                ModelQueryResult queryResult = null;
                try {
                    AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(queryColumn.getQuery());
                    queryResult = abstractModelQuery.evaluate(eObject);
                }
                catch (ModelQueryException e) {
                    Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
                    return "N/A";
                }
                if (queryResult.getException() != null) {
                    return "N/A";
                }
                if (queryResult.getValue() == null) {
                    return "null";
                }
                return this.queryResultToString(queryResult.getValue());
            }
            return "N/A";
        }
        if (column instanceof FacetAttributeColumn) {
            FacetAttributeColumn facetAttributeColumn = (FacetAttributeColumn)column;
            try {
                Facet facet;
                EObject eObject = (EObject)gridElement.getElement();
                FacetAttribute facetAttribute = facetAttributeColumn.getAttribute();
                if (this.facetContext.getAppliedFeatures().contains(facetAttribute) && this.facetContext.isInstance(eObject, facet = (Facet)facetAttribute.eContainer())) {
                    return this.queryResultToString(this.facetContext.get(eObject, (EStructuralFeature)facetAttribute));
                }
                return Messages.TableLabelProvider_NA;
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                return String.valueOf('!') + e.getClass().getName() + "(cf. log)";
            }
        }
        if (column instanceof FacetReferenceColumn) {
            FacetReferenceColumn facetReferenceColumn = (FacetReferenceColumn)column;
            try {
                Facet facet;
                EObject eObject = (EObject)gridElement.getElement();
                FacetReference facetReference = facetReferenceColumn.getReference();
                if (this.facetContext.getAppliedFeatures().contains(facetReference) && this.facetContext.isInstance(eObject, facet = (Facet)facetReference.eContainer())) {
                    return this.queryResultToString(this.facetContext.get(eObject, (EStructuralFeature)facetReference));
                }
                return Messages.TableLabelProvider_NA;
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                return String.valueOf('!') + e.getClass().getName() + "(cf. log)";
            }
        }
        if (column instanceof ValueColumn) {
            return this.queryResultToString(gridElement.getElement());
        }
        throw new IllegalArgumentException();
    }

    private String queryResultToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Collection) {
            StringBuilder stb = new StringBuilder();
            Collection collection = (Collection)object;
            for (Object o : collection) {
                if (stb.length() > 0) {
                    stb.append(", ");
                }
                if (o instanceof EObject) {
                    stb.append(this.getTextFor(o));
                    continue;
                }
                stb.append(o.toString());
            }
            return stb.toString();
        }
        if (object instanceof ModelQueryResult) {
            return this.getTextFor(((ModelQueryResult)object).getValue());
        }
        return this.getTextFor(object);
    }

    private static String getMetaclassColumnText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            EClass eClass = eObject.eClass();
            if (eClass == null) {
                return Messages.TableLabelProvider_none;
            }
            return eClass.getName();
        }
        return element.getClass().getSimpleName();
    }

    private String getContextColumnText(GridElement gridElement) {
        if (gridElement instanceof GridElementWithContext) {
            GridElementWithContext gridElementWithContext = (GridElementWithContext)gridElement;
            EObject context = gridElementWithContext.getContext();
            return this.getTextFor(context);
        }
        return Messages.TableLabelProvider_null;
    }

    private Image getContextColumnImage(GridElement gridElement) {
        if (gridElement instanceof GridElementWithContext) {
            GridElementWithContext gridElementWithContext = (GridElementWithContext)gridElement;
            EObject context = gridElementWithContext.getContext();
            return this.getImageFor(context);
        }
        return null;
    }

    private String getAttributeColumnText(Object element, Column column) {
        EObject eObject = (EObject)element;
        EAttribute attribute = null;
        if (column instanceof AttributeColumn) {
            AttributeColumn attributeColumn = (AttributeColumn)column;
            attribute = attributeColumn.getAttribute();
        }
        if (!eObject.eClass().getEAllAttributes().contains(attribute)) {
            return Messages.TableLabelProvider_NA;
        }
        Object attrValue = eObject.eGet((EStructuralFeature)attribute);
        if (attrValue == null) {
            return "null";
        }
        return StringUtils.truncateBeforeNewline((String)this.getTextFor(attrValue));
    }

    private String getReferenceColumnText(Object element, Column column) {
        EObject eObject = (EObject)element;
        EReference reference = null;
        if (column instanceof ReferenceColumn) {
            ReferenceColumn referenceColumn = (ReferenceColumn)column;
            reference = referenceColumn.getReference();
        }
        if (reference != null) {
            if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                return Messages.TableLabelProvider_NA;
            }
            Object refValue = eObject.eGet((EStructuralFeature)reference);
            if (refValue == null) {
                return "null";
            }
            if (reference.isMany()) {
                EList list = (EList)refValue;
                if (list.size() == 0) {
                    return "";
                }
                if (list.size() == 1) {
                    return this.getTextFor(list.get(0));
                }
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < list.size() && i < 5) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(this.getTextFor(list.get(i)));
                    ++i;
                }
                if (list.size() > 5) {
                    builder.append(", ...");
                }
                return builder.toString();
            }
            return this.getTextFor(refValue);
        }
        return "null";
    }
}

