/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	  Gregoire Dupe (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Grgoire Dup (Mia-Software) - Bug 365808 - [Unit Test Failure][0.2/4.2][0.2/3.8] org.eclipse.emf.facet.widgets.nattable.tests.NatTableAPITests
 *    Gregoire Dupe (Mia-Software) - Bug 366804 - [Restructuring] Table widget upgrade
 *    Gregoire Dupe (Mia-Software) - Bug 367613 - Table widget refactoring
 *    Gregoire Dupe (Mia-Software) - Bug 369987 - [Restructuring][Table] Switch to the new customization and facet framework
 *    Gregoire Dupe (Mia-Software) - Bug 373078 - API Cleaning
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetViewFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;

public class TableWidgetFactory implements ITableWidgetFactory {

	private static final String CLASS = "class"; //$NON-NLS-1$
	private static final String VIEW_IMPL = "org.eclipse.emf.facet.widgets.table.ui.internal.viewimpl"; //$NON-NLS-1$
	private List<ITableWidgetViewFactory> factories = new ArrayList<ITableWidgetViewFactory>();

	public TableWidgetFactory() {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = registry
				.getExtensionPoint(TableWidgetFactory.VIEW_IMPL);
		for (IExtension ext : extensionPoint.getExtensions()) {
			for (IConfigurationElement configElt : ext
					.getConfigurationElements()) {
				try {
					ITableWidgetViewFactory factory = (ITableWidgetViewFactory) configElt
							.createExecutableExtension(TableWidgetFactory.CLASS);
					this.factories.add(factory);
				} catch (CoreException e) {
					Logger.logError(e, Activator.getDefault());
				}
			}
		}
		if (this.factories.size() == 0) {
			Logger.logError(
					"No table view factory registered.", Activator.getDefault()); //$NON-NLS-1$
		} else if (this.factories.size() > 1) {
			Logger.logError(
					"More than one table view factory has been registered, " + this.factories.get(0).getClass().getName() + " will be used.", Activator.getDefault()); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	public ITableWidget createTableWidget(final Composite parent,
			final IEditingDomainProvider edProvider,
			final Table tableInstance, final MenuManager menuMgr) {
		ITableWidgetInternal tableWidget;
		try {
			tableWidget = new TableWidgetController(parent,
					edProvider, tableInstance, menuMgr, this.factories.get(0));
		} catch (CustomizationException e) {
			throw new TableWidgetRuntimeException(e);
		}
		return new SynchronizedTableWidgetController(tableWidget);
	}

}
