/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.actions;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.Messages;
import org.eclipse.emf.facet.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.emf.facet.infra.browser.editors.BrowserConfiguration;
import org.eclipse.emf.facet.infra.browser.editors.EcoreBrowser;
import org.eclipse.emf.facet.infra.browser.editors.table.TableEditorFactory;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;

public class OpenTableEditorAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public OpenTableEditorAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.openTableEditorOnSelection);
        this.browserActionBarContributor = browserActionBarContributor;
    }

    public void run() {
        ISelection selection;
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null && (selection = this.browserActionBarContributor.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof LinkItem) {
                MessageDialog.openError(null, (String)"", (String)"not implemented");
            } else {
                this.openOn(browser.getBrowserConfiguration(), structuredSelection);
            }
        }
    }

    private void openOn(BrowserConfiguration browserConfiguration, IStructuredSelection structuredSelection) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (Object selectedElement : structuredSelection) {
            if (selectedElement instanceof ModelElementItem) {
                ModelElementItem modelElementItem = (ModelElementItem)selectedElement;
                elements.add(modelElementItem.getEObject());
                continue;
            }
            BrowserPlugin.logWarning(Messages.EcoreActionBarContributor_cannotOpenTableEditorNotModelElements);
            return;
        }
        String metamodelName = browserConfiguration.getMetamodelName();
        String description = metamodelName != null ? NLS.bind((String)Messages.EcoreActionBarContributor_elementsSelection, (Object)metamodelName) : Messages.EcoreActionBarContributor_elementsSelectionUnknowMetamodel;
        TableEditorFactory.getInstance().openOn(browserConfiguration, elements, description);
    }
}

