/**
 *  Copyright (c) 2011 Mia-Software.
 *  
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *  Contributors:
 *  	Gregoire Dupe (Mia-Software) - Bug 361794 - [Restructuring] EMF Facet customization meta-model
 *      Gregoire Dupe (Mia-Software) - Bug 369987 - [Restructuring][Table] Switch to the new customization and facet framework
 *      Gregoire Dupe (Mia-Software) - Bug 373078 - API Cleaning
 */
package org.eclipse.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.custom.core.internal.exception.CustomizationCatalogRuntimeException;
import org.eclipse.emf.facet.custom.core.internal.exported.ICustomizationPropertiesCatalogManager;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationPropertiesCatalog;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationcatalogFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.emf.catalog.CatalogSet;
import org.eclipse.emf.facet.util.emf.core.ICatalogManager;

/**
 * Customization catalog implementation using the catalog manager features
 * provided by the plug-in org.eclipse.emf.facet.util.emf.core
 * 
 * @author Gregoire Dupe
 * 
 */
public class CustomizationPropertiesCatalogManager implements ICatalogManager,
		ICustomizationPropertiesCatalogManager {

	private CustomizationPropertiesCatalog catalog = CustomizationcatalogFactory.eINSTANCE
			.createCustomizationPropertiesCatalog();

	public boolean canBeManaged(final EObject root) {
		return root instanceof FacetSet;
	}

	public void manage(final EObject root) {
		if (root instanceof FacetSet) {
			FacetSet customizationProperties = (FacetSet) root;
			this.catalog.getInstalledEntries().add(customizationProperties);
		} else {
			throw new CustomizationCatalogRuntimeException(
					"Only facetSets must be stored in the customization properties catalog"); //$NON-NLS-1$
		}
	}

	public void setCatalogSet(final CatalogSet catalogSet) {
		catalogSet.getCatalogs().add(this.catalog);
	}

	public List<FacetSet> getAllRegisteredCustomizationProperties() {
		List<FacetSet> result = new ArrayList<FacetSet>();
		for (EObject eObject : this.catalog.getInstalledEntries()) {
			if (eObject instanceof FacetSet) {
				FacetSet facetSet = (FacetSet) eObject;
				result.add(facetSet);
			} else {
				throw new RuntimeException(
						"Only facetSets must be stored in the customization properties catalog"); //$NON-NLS-1$
			}
		}
		return result;
	}

	public List<FacetOperation> getCustomizationPropertiesByName(
			final String customPropertyName) {
		List<FacetOperation> result = new ArrayList<FacetOperation>();
		for (EObject facetSet : this.catalog.getInstalledEntries()) {
			Iterator<EObject> iterator = facetSet.eAllContents();
			while (iterator.hasNext()) {
				EObject eObject = iterator.next();
				if (eObject instanceof FacetOperation) {
					final FacetOperation customizationProperty = (FacetOperation) eObject;
					if (customPropertyName.equals(customizationProperty.getName())) {
						result.add(customizationProperty);	
					}
				}
			}
		}
		return result;
	}

}
