/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.nattable.group.IColumnGroupModelListener;
import net.sourceforge.nattable.persistence.IPersistable;
import net.sourceforge.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroupModel
implements IPersistable {
    private static final String PERSISTENCE_KEY_COLUMN_GROUPS = ".columnGroups";
    private final LinkedHashMap<String, ColumnGroup> nameToColumnGroup = new LinkedHashMap();
    private final LinkedHashMap<Integer, String> indexToColumnGroupName = new LinkedHashMap();
    private final Collection<IColumnGroupModelListener> listeners = new HashSet<IColumnGroupModelListener>();

    public void registerColumnGroupModelListner(IColumnGroupModelListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (IColumnGroupModelListener listener : this.listeners) {
            listener.columnGroupModelChanged();
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder strBuilder = new StringBuilder();
        for (String columnGroupName : this.nameToColumnGroup.keySet()) {
            strBuilder.append(columnGroupName);
            strBuilder.append('=');
            ColumnGroup columnGroup = this.nameToColumnGroup.get(columnGroupName);
            strBuilder.append(columnGroup.collapsed ? "collapsed" : "expanded");
            strBuilder.append(':');
            strBuilder.append(columnGroup.unbreakable ? "unbreakable" : "breakable");
            strBuilder.append(':');
            for (Integer member : columnGroup.members) {
                strBuilder.append(member);
                strBuilder.append(',');
            }
            strBuilder.append('|');
        }
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_GROUPS, strBuilder.toString());
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_GROUPS);
        if (property != null) {
            this.clear();
            StringTokenizer columnGroupTokenizer = new StringTokenizer(property, "|");
            while (columnGroupTokenizer.hasMoreTokens()) {
                String columnGroupToken = columnGroupTokenizer.nextToken();
                int separatorIndex = columnGroupToken.indexOf(61);
                String columnGroupName = columnGroupToken.substring(0, separatorIndex);
                ColumnGroup columnGroup = new ColumnGroup(columnGroupName);
                this.nameToColumnGroup.put(columnGroupName, columnGroup);
                String[] columnGroupProperties = columnGroupToken.substring(separatorIndex + 1).split(":");
                String state = columnGroupProperties[0];
                if ("collapsed".equals(state)) {
                    columnGroup.collapsed = true;
                } else if ("expanded".equals(state)) {
                    columnGroup.collapsed = false;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'expanded' or 'collapsed'");
                }
                state = columnGroupProperties[1];
                if ("breakable".equals(state)) {
                    columnGroup.unbreakable = false;
                } else if ("unbreakable".equals(state)) {
                    columnGroup.unbreakable = true;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'breakable' or 'unbreakable'");
                }
                String indexes = columnGroupProperties[2];
                StringTokenizer indexTokenizer = new StringTokenizer(indexes, ",");
                while (indexTokenizer.hasMoreTokens()) {
                    Integer index = Integer.valueOf(indexTokenizer.nextToken());
                    columnGroup.members.add(index);
                    this.indexToColumnGroupName.put(index, columnGroupName);
                }
            }
        }
    }

    public void addColumnsIndexesToGroup(String colGroupName, int ... bodyColumnIndexs) {
        if (this.nameToColumnGroup.get(colGroupName) == null) {
            ColumnGroup group = new ColumnGroup(colGroupName);
            this.nameToColumnGroup.put(colGroupName, group);
        }
        this.insertColumnIndexes(colGroupName, bodyColumnIndexs);
        this.notifyListeners();
    }

    public boolean insertColumnIndexes(String colGroupName, int ... columnIndexesToInsert) {
        LinkedList<Integer> members = new LinkedList<Integer>();
        LinkedHashMap<Integer, String> indexToColumnGroupName = new LinkedHashMap<Integer, String>();
        ColumnGroup columnGroup = this.nameToColumnGroup.get(colGroupName);
        if (columnGroup.unbreakable) {
            return false;
        }
        int[] nArray = columnIndexesToInsert;
        int n = columnIndexesToInsert.length;
        int n2 = 0;
        while (n2 < n) {
            int columnIndexToInsert = nArray[n2];
            Integer index = columnIndexToInsert;
            if (this.isPartOfAGroup(columnIndexToInsert)) {
                return false;
            }
            members.add(index);
            indexToColumnGroupName.put(index, colGroupName);
            ++n2;
        }
        this.indexToColumnGroupName.putAll(indexToColumnGroupName);
        columnGroup.members.addAll(members);
        this.notifyListeners();
        return true;
    }

    private ColumnGroup getColumnGroupForIndex(int bodyColumnIndex) {
        Integer key = bodyColumnIndex;
        if (this.indexToColumnGroupName.containsKey(key)) {
            return this.nameToColumnGroup.get(this.indexToColumnGroupName.get(key));
        }
        return null;
    }

    public String getColumnGroupNameForIndex(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            return this.getColumnGroupForIndex((int)bodyColumnIndex).name;
        }
        return null;
    }

    public List<Integer> getColumnIndexesInGroup(int bodyColumnIndex) {
        ColumnGroup group = this.getColumnGroupForIndex(bodyColumnIndex);
        if (group == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(group.members);
    }

    public List<Integer> getAllIndexesInGroups() {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        for (ColumnGroup columnGroup : this.nameToColumnGroup.values()) {
            indexes.addAll(columnGroup.members);
        }
        return indexes;
    }

    public boolean isPartOfAGroup(int bodyColumnIndex) {
        return this.indexToColumnGroupName.containsKey(bodyColumnIndex);
    }

    public void clear() {
        this.nameToColumnGroup.clear();
        this.indexToColumnGroupName.clear();
    }

    public int size() {
        return this.nameToColumnGroup.size();
    }

    public int sizeOfGroup(int bodyColumnIndex) {
        return this.getColumnIndexesInGroup(bodyColumnIndex).size();
    }

    public boolean isEmpty() {
        return this.nameToColumnGroup.size() == 0;
    }

    public boolean isCollapsed(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            return this.getColumnGroupForIndex((int)bodyColumnIndex).collapsed;
        }
        return false;
    }

    public boolean isCollapsed(String columnGroupName) {
        boolean collpased = false;
        if (this.nameToColumnGroup.containsKey(columnGroupName)) {
            collpased = this.nameToColumnGroup.get((Object)columnGroupName).collapsed;
        }
        return collpased;
    }

    public boolean isAGroup(String cellValue) {
        return this.nameToColumnGroup.containsKey(cellValue);
    }

    public int getCollapsedColumnCount() {
        int count = 0;
        for (String groupName : this.nameToColumnGroup.keySet()) {
            ColumnGroup columnGroup = this.nameToColumnGroup.get(groupName);
            if (!columnGroup.collapsed) continue;
            count = count + columnGroup.getMemberCount() - 1;
        }
        return count;
    }

    protected void collapse(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            this.getColumnGroupForIndex((int)bodyColumnIndex).collapsed = true;
        }
        this.notifyListeners();
    }

    protected void expand(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            this.getColumnGroupForIndex((int)bodyColumnIndex).collapsed = false;
        }
        this.notifyListeners();
    }

    public boolean removeColumnFromGroup(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex) && !this.isPartOfAnUnbreakableGroup(bodyColumnIndex)) {
            ColumnGroup group = this.getColumnGroupForIndex(bodyColumnIndex);
            this.removeColumn(bodyColumnIndex, group);
            this.notifyListeners();
            return true;
        }
        return false;
    }

    private void removeColumn(int bodyColumnIndex, ColumnGroup group) {
        LinkedList members = group.members;
        members.remove((Object)bodyColumnIndex);
        this.indexToColumnGroupName.remove(bodyColumnIndex);
        if (members.size() == 0) {
            this.nameToColumnGroup.remove(group.name);
        }
        this.notifyListeners();
    }

    public int getColumnGroupPositionFromIndex(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            ColumnGroup columnGroup = this.getColumnGroupForIndex(bodyColumnIndex);
            return columnGroup.members.indexOf(bodyColumnIndex);
        }
        return -1;
    }

    public ColumnGroup toggleColumnGroupExpandCollapse(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            ColumnGroup columnGroup = this.getColumnGroupForIndex(bodyColumnIndex);
            columnGroup.collapsed = !columnGroup.collapsed;
            this.notifyListeners();
            return columnGroup;
        }
        return null;
    }

    public boolean setGroupUnBreakable(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            this.getColumnGroupForIndex((int)bodyColumnIndex).unbreakable = true;
            return true;
        }
        return false;
    }

    public boolean isPartOfAnUnbreakableGroup(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            return this.getColumnGroupForIndex((int)bodyColumnIndex).unbreakable;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Column Group Model:\n");
        for (String groupName : this.nameToColumnGroup.keySet()) {
            buffer.append(this.nameToColumnGroup.get(groupName));
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnGroup {
        private final LinkedList<Integer> members = new LinkedList();
        final String name;
        boolean collapsed = false;
        public boolean unbreakable = false;

        ColumnGroup(String groupName) {
            this.name = groupName;
        }

        int getMemberCount() {
            return this.members.size();
        }

        public List<Integer> getMembers() {
            return this.members;
        }

        public String toString() {
            return "Column Group:\n\t name: " + this.name + "\n\t collapsed: " + this.collapsed + "\n\t unbreakable: " + this.unbreakable + "\n\t members: " + ObjectUtils.toString(this.members) + "\n";
        }
    }
}

