/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.java.ui.internal.wizard.page;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.query.java.core.IJavaQuery;
import org.eclipse.emf.facet.query.java.ui.internal.Activator;
import org.eclipse.emf.facet.query.java.ui.internal.Messages;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.page.IQueryAttributesWizardPage;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.page.NewClassWizardPage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.core.internal.JavaUtils;
import org.eclipse.emf.facet.util.core.internal.PluginUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.swt.widgets.Shell;

public class NewQueryClassWizardPage
extends NewClassWizardPage
implements IQueryAttributesWizardPage {
    public void init(FacetSet modelQuerySet, String facetName, EClassifier eType) {
        IJavaProject javaProject = NewQueryClassWizardPage.findJavaProject(modelQuerySet);
        ArrayList<String> interfaceList = new ArrayList<String>();
        interfaceList.add(IJavaQuery.class.getName());
        this.setSuperInterfaces(interfaceList, false);
        String packageName = String.valueOf(javaProject.getProject().getName()) + ".queries." + eType.getName().toLowerCase();
        this.setTypeName(facetName, true);
        this.selectPackage(javaProject, packageName);
        this.setModifiers(this.F_PUBLIC, false);
        this.setSuperClass("", false);
        this.setEnclosingTypeSelection(false, false);
        this.setAddComments(false, false);
    }

    private void selectPackage(IJavaProject javaProject, String packageName) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRootToTest = iPackageFragmentRootArray[n2];
                if (packageFragmentRootToTest.getKind() == 1) {
                    IPackageFragmentRoot packageFragmentRoot = packageFragmentRootToTest;
                    this.setPackageFragmentRoot(packageFragmentRoot, false);
                    IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
                    this.setPackageFragment(packageFragment, true);
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e1) {
            Logger.logError((Throwable)e1, (Plugin)Activator.getDefault());
        }
    }

    private static IJavaProject findJavaProject(FacetSet modelQuerySet) {
        Resource resource = modelQuerySet.eResource();
        URI uri = resource.getURI();
        if (uri.isPlatformResource()) {
            String projectName = uri.segment(1);
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject project = ws.getRoot().getProject(projectName);
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public void apply(EClassifier returnType, int upperBound, EClassifier scope) {
        try {
            ICompilationUnit javaClass = this.createJavaClass(returnType, upperBound, scope);
            IProject project = javaClass.getCorrespondingResource().getProject();
            NewQueryClassWizardPage.setupProject(project, returnType, scope);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewQueryClassWizardPage_Failed_to_create_java_class, (String)Messages.NewQueryClassWizardPage_Failed_to_create_query_implementation);
        }
    }

    private static void setupProject(IProject project, EClassifier returnType, EClassifier scope) {
        try {
            String[] requiredBundles = NewQueryClassWizardPage.findRequiredBundles(returnType, scope);
            ArrayList<String> missingRequiredBundles = new ArrayList<String>();
            String[] stringArray = requiredBundles;
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredBundle = stringArray[n2];
                missingRequiredBundles.add(requiredBundle);
                ++n2;
            }
            missingRequiredBundles.add("org.eclipse.emf.facet.efacet.core");
            missingRequiredBundles.add("org.eclipse.emf.facet.query.java.core");
            PluginUtils.configureAsPluginProject((IProject)project);
            IFile manifestResource = (IFile)project.findMember((IPath)new Path("/META-INF/MANIFEST.MF"));
            manifestResource.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            InputStream contents = manifestResource.getContents();
            Manifest manifest = new Manifest(contents);
            String requires = manifest.getMainAttributes().getValue("Require-Bundle");
            if (requires != null) {
                ManifestElement[] manifestElements;
                ManifestElement[] manifestElementArray = manifestElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
                int n3 = manifestElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    ManifestElement manifestElement = manifestElementArray[n4];
                    missingRequiredBundles.remove(manifestElement.getValue());
                    ++n4;
                }
            }
            StringBuilder newRequires = new StringBuilder();
            if (requires != null) {
                newRequires.append(requires);
            }
            int i = 0;
            while (i < missingRequiredBundles.size()) {
                String missingRequiredBundle = (String)missingRequiredBundles.get(i);
                if (i != 0 || requires != null) {
                    newRequires.append(",");
                }
                newRequires.append(missingRequiredBundle);
                ++i;
            }
            manifest.getMainAttributes().putValue("Require-Bundle", newRequires.toString());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            manifest.write(outputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            manifestResource.setContents((InputStream)byteArrayInputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private static String[] findRequiredBundles(EClassifier returnType, EClassifier scope) {
        HashSet<String> requiredBundles = new HashSet<String>();
        HashSet<EPackage> requiredEPackages = new HashSet<EPackage>();
        if (returnType != null) {
            requiredEPackages.add(returnType.getEPackage());
        }
        if (scope != null) {
            requiredEPackages.add(scope.getEPackage());
        }
        Map genModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        for (EPackage ePackage : requiredEPackages) {
            try {
                URI genModelURI = (URI)genModelLocationMap.get(ePackage.getNsURI());
                if (genModelURI != null) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = resourceSet.createResource(genModelURI);
                    resource.load(Collections.emptyMap());
                    GenModel genModel = (GenModel)resource.getContents().get(0);
                    String modelPluginID = genModel.getModelPluginID();
                    if (modelPluginID == null) continue;
                    requiredBundles.add(modelPluginID);
                    continue;
                }
                Logger.logWarning((String)("Couldn't add the metamodel implementation plug-in to the dependencies automatically because the corresponding genmodel couldn't be found: " + ePackage.getNsURI()), (Plugin)Activator.getDefault());
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return requiredBundles.toArray(new String[requiredBundles.size()]);
    }

    private ICompilationUnit createJavaClass(EClassifier returnTypeClass, int upperBound, EClassifier scope) throws JavaModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPackageFragment packageFragment = this.getPackageFragment();
        if (packageFragment == null) {
            packageFragment = root.getPackageFragment("");
        }
        String packageName = packageFragment.getElementName();
        if (!packageFragment.exists()) {
            packageFragment = root.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
        }
        String typeName = this.getTypeName();
        StringBuilder contents = new StringBuilder();
        NewQueryClassWizardPage.createJavaClassContents(contents, typeName, packageName, returnTypeClass, upperBound, scope);
        String cuName = this.getCompilationUnitName(typeName);
        ICompilationUnit compilationUnit = packageFragment.createCompilationUnit(cuName, contents.toString(), false, (IProgressMonitor)new NullProgressMonitor());
        return compilationUnit;
    }

    private static void createJavaClassContents(StringBuilder contents, String name, String packageName, EClassifier returnTypeClass, int upperBound, EClassifier scope) {
        String shortScopeType;
        String scopeType;
        String shortReturnType;
        String returnType;
        if (packageName.length() > 0) {
            contents.append("package ");
            contents.append(packageName);
            contents.append(";\n\n");
        }
        boolean importCollection = false;
        if (returnTypeClass != null) {
            returnType = returnTypeClass.getInstanceClassName();
            returnType = JavaUtils.objectType((String)returnType);
            int lastDotPos = returnType.lastIndexOf(46);
            if (upperBound != 1) {
                importCollection = true;
                shortReturnType = "Collection<" + returnType.substring(lastDotPos + 1) + ">";
            } else {
                shortReturnType = returnType.substring(lastDotPos + 1);
            }
        } else {
            returnType = "java.lang.Object";
            shortReturnType = "Object";
        }
        if (scope != null) {
            scopeType = scope.getInstanceClassName();
            scopeType = JavaUtils.objectType((String)scopeType);
            shortScopeType = scopeType.substring(scopeType.lastIndexOf(46) + 1);
        } else {
            scopeType = "org.eclipse.emf.ecore.EObject";
            shortScopeType = "EObject";
        }
        if (importCollection) {
            contents.append("import java.util.Collection;\n");
        }
        if (NewQueryClassWizardPage.mustImport(returnType)) {
            contents.append("import " + returnType + ";\n");
        }
        if (!returnType.equals(scopeType) && NewQueryClassWizardPage.mustImport(scopeType)) {
            contents.append("import " + scopeType + ";\n");
        }
        contents.append("import org.eclipse.emf.facet.efacet.core.exception.QueryExecutionException;\n");
        contents.append("import org.eclipse.emf.facet.query.java.core.IJavaQuery;\n");
        contents.append("import org.eclipse.emf.facet.query.java.core.IParameterValueList;\n");
        contents.append("\n");
        contents.append("public class " + name + " implements IJavaQuery<" + shortScopeType + ", " + shortReturnType + "> {\n");
        contents.append("\tpublic " + shortReturnType + " evaluate(final " + shortScopeType + " context, final IParameterValueList parameterValues)\n");
        contents.append("\t\t\tthrows QueryExecutionException {\n");
        contents.append("\t\t// TODO Auto-generated method stub\n");
        contents.append("\t\treturn null;\n");
        contents.append("\t}\n");
        contents.append("}\n");
    }

    private static boolean mustImport(String type) {
        return type.contains(".") && !type.startsWith("java.lang.");
    }
}

