/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.tests;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleTest {
    private static final String BUNDLE_ID_REGEX = "org\\.eclipse\\.emf\\.facet.*";
    private final Bundle testBundle = Platform.getBundle((String)"org.eclipse.emf.facet.tests");

    @Test
    public void name() {
        this.testManifestProperty("Bundle-Name", ".*\\(Incubation\\)");
    }

    @Test
    public void provider() {
        this.testManifestProperty("Bundle-Vendor", "Eclipse Modeling Project");
    }

    @Test
    public void version() {
        this.testManifestProperty("Bundle-Version", "0\\.3\\.0\\..*");
    }

    @Test
    public void about() {
        List<Bundle> wrongBundles = this.test(new RunnableTest(){

            public void run(Bundle bundle) {
                URL url = bundle.getResource("/about.html");
                Assert.assertNotNull((Object)url);
            }
        });
        if (wrongBundles.size() > 0) {
            StringBuffer sb = new StringBuffer("About files are missing in:");
            for (Bundle bundle : wrongBundles) {
                sb.append(String.valueOf('\n') + bundle.getSymbolicName());
            }
            Assert.fail((String)sb.toString());
        }
    }

    private void testManifestProperty(final String property, final String regex) {
        List<Bundle> wrongBundles = this.test(new RunnableTest(){

            public void run(Bundle bundle) {
                Assert.assertTrue((boolean)((String)bundle.getHeaders().get(property)).matches(regex));
            }
        });
        if (wrongBundles.size() > 0) {
            StringBuffer sb = new StringBuffer("Wrong " + property + " in:");
            for (Bundle bundle : wrongBundles) {
                sb.append(String.valueOf('\n') + bundle.getSymbolicName() + " -> " + (String)bundle.getHeaders().get(property));
            }
            Assert.fail((String)sb.toString());
        }
    }

    private List<Bundle> test(RunnableTest runable) {
        Bundle[] bundles;
        ArrayList<Bundle> wrongBundles = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles = this.testBundle.getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName.matches(BUNDLE_ID_REGEX)) {
                try {
                    runable.run(bundle);
                }
                catch (AssertionError assertionError) {
                    wrongBundles.add(bundle);
                }
            }
            ++n2;
        }
        return wrongBundles;
    }

    private static interface RunnableTest {
        public void run(Bundle var1);
    }
}

