/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.TableTestUtils;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditorFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug346465Test {
    private static final int TIMEOUT = 30000;
    private static final String PROJECT_NAME = "projectBug346465";
    private static final String ECORE_FILE_NAME = "_Bug346465_Ecore.ecore";
    private static final String TABLE_CONFIGURATION_FILE_PATH = "resources/Bug346465/_Bug346465_EcoreTableConfiguration.tableconfiguration";
    private Resource ecoreModel;
    private INatTableWidget2 iNatTableWidget2;
    private TableInstance tableInstance;
    private final int rowsSizeThree = 3;
    private final int rowsSizeFour = 4;
    private final int allColumnsSize = 37;
    private final int columnsSizeWithoutEENum = 35;
    private final int columnsSizeWithoutEClasses = 21;
    private final int columnsSizeWithoutEClassesAndEENum = 10;
    private EditingDomain editingDomain;
    private Column facetAttributeColumn;

    @Before
    public void beforeTests() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IProject testProject = workspace.getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/Bug346465/_Bug346465_Ecore.ecore", (IProject)testProject, (String)"/_Bug346465_Ecore.ecore", (Bundle)bundle);
        ResourceSetImpl rSet = new ResourceSetImpl();
        this.ecoreModel = rSet.getResource(URI.createPlatformResourceURI((String)"projectBug346465/_Bug346465_Ecore.ecore", (boolean)false), true);
        Assert.assertNotNull((Object)this.ecoreModel);
        Assert.assertTrue((boolean)(this.ecoreModel.getContents().get(0) instanceof EPackage));
        EPackage ePackage = (EPackage)this.ecoreModel.getContents().get(0);
        try {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            BasicCommandStack commandStack = new BasicCommandStack();
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
            ResourceSet resourceSet = ePackage.eResource().getResourceSet();
            URI uri = URI.createPlatformPluginURI((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + '/' + TABLE_CONFIGURATION_FILE_PATH), (boolean)false);
            Resource resource = resourceSet.getResource(uri, true);
            ArrayList list = new ArrayList();
            list.addAll(ePackage.getEClassifiers());
            list.addAll(ePackage.getEAnnotations());
            TableConfiguration tableConfiguration = (TableConfiguration)resource.getContents().get(0);
            NatTableEditorFactory.getInstance().openOn(list, this.editingDomain, "", tableConfiguration, null, null);
        }
        catch (UnsatisfiedConfigurationConstraint e) {
            throw new RuntimeException(e);
        }
        this.iNatTableWidget2 = TableTestUtils.getNatTableWidgetOfActivePart();
        this.tableInstance = this.iNatTableWidget2.getTableInstance();
        this.facetAttributeColumn = (Column)this.iNatTableWidget2.getTableInstance().getColumns().get(34);
        Assert.assertTrue((boolean)(this.facetAttributeColumn instanceof FacetAttributeColumn));
    }

    @Test(timeout=30000L)
    public void testBug346465DeleteSelection() {
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.deleteSelection();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.iNatTableWidget2.getTableInstance().getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)3L, (long)this.tableInstance.getRows().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(1)).getElement());
        this.iNatTableWidget2.deleteSelection();
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)35L, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)2L, (long)this.tableInstance.getRows().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)3L, (long)this.tableInstance.getRows().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)4L, (long)this.tableInstance.getRows().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.deleteSelection();
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.deleteSelection();
        Assert.assertEquals((long)21L, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.deleteSelection();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.deleteSelection();
        Assert.assertTrue((boolean)this.tableInstance.getColumns().isEmpty());
        Assert.assertTrue((boolean)this.tableInstance.getRows().isEmpty());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)21L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().redo();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().redo();
        Assert.assertEquals((long)0L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)21L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)4L, (long)this.tableInstance.getRows().size());
    }

    @Test(timeout=30000L)
    public void testBug346465RemoveLine() {
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.removeLine();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.iNatTableWidget2.getTableInstance().getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)3L, (long)this.tableInstance.getRows().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(1)).getElement());
        this.iNatTableWidget2.removeLine();
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)35L, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)2L, (long)this.tableInstance.getRows().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)3L, (long)this.tableInstance.getRows().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)4L, (long)this.tableInstance.getRows().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.removeLine();
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.removeLine();
        Assert.assertEquals((long)21L, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.removeLine();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.iNatTableWidget2.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.iNatTableWidget2.removeLine();
        Assert.assertTrue((boolean)this.tableInstance.getColumns().isEmpty());
        Assert.assertTrue((boolean)this.tableInstance.getRows().isEmpty());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)21L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().redo();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().redo();
        Assert.assertEquals((long)0L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)10L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)21L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)37L, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)4L, (long)this.tableInstance.getRows().size());
    }

    @After
    public void closeAllEditors() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
    }
}

