/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.internal.incubatingapi.IFacetActions2;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.RuntimeFactory;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.FacetTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FacetCoreTests {
    @Before
    public void init() throws Exception {
        IProject[] projects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.close((IProgressMonitor)new NullProgressMonitor());
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
    }

    @Test
    public void testCreateEmptyFacetSet() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("TestCreateEmptyFacetSet");
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        IFile facetSetFile = project.getFile("TestCreateEmptyFacetSet.facetSet");
        FacetSet facetSet = EFacetFactory.eINSTANCE.createFacetSet();
        facetSet.setName("TestCreateEmptyFacetSet");
        facetSet.setNsURI("http://test/TestCreateEmptyFacetSet");
        facetSet.setNsPrefix("nsPrefixTestCreateEmptyFacetSet");
        IFacetActions2.INSTANCE.saveFacetSet(facetSet, facetSetFile);
        Assert.assertTrue((String)"FacetSet file must exist after being saved", (boolean)facetSetFile.exists());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)facetSetFile.getFullPath().toString(), (boolean)true), true);
        FacetSet reloadedFacetSet = (FacetSet)resource.getContents().get(0);
        Assert.assertTrue((boolean)"TestCreateEmptyFacetSet".equals(reloadedFacetSet.getName()));
        Assert.assertTrue((boolean)"nsPrefixTestCreateEmptyFacetSet".equals(reloadedFacetSet.getNsPrefix()));
        Assert.assertTrue((boolean)"http://test/TestCreateEmptyFacetSet".equals(reloadedFacetSet.getNsURI()));
    }

    @Test
    public void testCreateFacet() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("TestCreateFacet");
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, facetSet.eResource().getResourceSet());
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setName("TestFacetCreation");
        IFacetActions2.INSTANCE.createFacetInFacetSet(facetSet, facet, (EditingDomain)editingDomain);
        Assert.assertTrue((boolean)FacetUtils.getFacets((FacetSet)facetSet).contains(facet));
        commandStack.undo();
        Assert.assertFalse((boolean)FacetUtils.getFacets((FacetSet)facetSet).contains(facet));
        commandStack.redo();
        Assert.assertTrue((boolean)FacetUtils.getFacets((FacetSet)facetSet).contains(facet));
    }

    @Test
    public void testAddAttribute() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("TestCreateAttribute");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setName("TestAttributeCreation");
        facetSet.getEClassifiers().add((Object)facet);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, facetSet.eResource().getResourceSet());
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        IFacetActions2.INSTANCE.addAttributeInFacet(facet, facetAttribute, (EditingDomain)editingDomain);
        Assert.assertTrue((boolean)facet.getFacetElements().contains((Object)facetAttribute));
        commandStack.undo();
        Assert.assertFalse((boolean)facet.getFacetElements().contains((Object)facetAttribute));
        commandStack.redo();
        Assert.assertTrue((boolean)facet.getFacetElements().contains((Object)facetAttribute));
    }

    @Test
    public void testAddReference() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("TestCreateReference");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setName("TestReferenceCreation");
        facetSet.getEClassifiers().add((Object)facet);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, facetSet.eResource().getResourceSet());
        FacetReference facetReference = EFacetFactory.eINSTANCE.createFacetReference();
        IFacetActions2.INSTANCE.addReferenceInFacet(facet, facetReference, (EditingDomain)editingDomain);
        Assert.assertTrue((boolean)facet.getFacetElements().contains((Object)facetReference));
        commandStack.undo();
        Assert.assertFalse((boolean)facet.getFacetElements().contains((Object)facetReference));
        commandStack.redo();
        Assert.assertTrue((boolean)facet.getFacetElements().contains((Object)facetReference));
    }

    @Test
    public void testAddOperation() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("TestCreateOperation");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setName("TestOperationCreation");
        facetSet.getEClassifiers().add((Object)facet);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, facetSet.eResource().getResourceSet());
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        IFacetActions2.INSTANCE.addOperationInFacet(facet, facetOperation, (EditingDomain)editingDomain);
        Assert.assertTrue((boolean)facet.getFacetOperations().contains((Object)facetOperation));
        commandStack.undo();
        Assert.assertFalse((boolean)facet.getFacetOperations().contains((Object)facetOperation));
        commandStack.redo();
        Assert.assertTrue((boolean)facet.getFacetOperations().contains((Object)facetOperation));
    }

    @Test
    public void testAddParameter() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("TestCreateParameter");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setName("TestParameterCreation");
        facetSet.getEClassifiers().add((Object)facet);
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        facet.getFacetOperations().add((Object)operation);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, facetSet.eResource().getResourceSet());
        EParameter parameter = EcoreFactory.eINSTANCE.createEParameter();
        parameter.setName("param1");
        parameter.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        IFacetActions2.INSTANCE.addParameterInOperation(operation, parameter, (EditingDomain)editingDomain);
        Assert.assertTrue((boolean)operation.getEParameters().contains((Object)parameter));
        commandStack.undo();
        Assert.assertFalse((boolean)operation.getEParameters().contains((Object)parameter));
        commandStack.redo();
        Assert.assertTrue((boolean)operation.getEParameters().contains((Object)parameter));
    }

    @Test
    public void testFacetConformance() {
    }

    @Test
    public void testGetExtendedEPackage() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("TestGetExtendedEPackage");
        EClass[] classes = new EClass[]{EcorePackage.eINSTANCE.getEReference(), EcorePackage.eINSTANCE.getEAnnotation(), EcorePackage.eINSTANCE.getEAttribute(), EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEPackage()};
        int nFacets = classes.length;
        int i = 0;
        while (i < nFacets) {
            Facet facet = EFacetFactory.eINSTANCE.createFacet();
            facet.setName("TestGetExtendedEPackage");
            facetSet.getEClassifiers().add((Object)facet);
            facet.setExtendedMetaclass(classes[i]);
            ++i;
        }
        EPackage extendedEPackage = FacetUtils.getExtendedEPackage((FacetSet)facetSet);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, (Object)extendedEPackage);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetExtendedEPackageError() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("TestGetExtendedEPackageError");
        EClass[] classes = new EClass[]{EcorePackage.eINSTANCE.getEReference(), EFacetPackage.eINSTANCE.getFacet(), EcorePackage.eINSTANCE.getEAttribute(), EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEPackage()};
        int nFacets = classes.length;
        int i = 0;
        while (i < nFacets) {
            Facet facet = EFacetFactory.eINSTANCE.createFacet();
            facet.setName("TestGetExtendedEPackageError");
            facetSet.getEClassifiers().add((Object)facet);
            facet.setExtendedMetaclass(classes[i]);
            ++i;
        }
        FacetUtils.getExtendedEPackage((FacetSet)facetSet);
    }

    @Test
    public void testCreateResult() throws Exception {
        ETypedElementPrimitiveTypeResult derivedTypedElementResult = RuntimeFactory.eINSTANCE.createETypedElementPrimitiveTypeResult();
        String value = "Test";
        derivedTypedElementResult.setResult((Object)value);
        String result = (String)derivedTypedElementResult.getResult();
        Assert.assertEquals((Object)value, (Object)result);
        ETypedElementPrimitiveTypeListResult derivedTypedElementListResult = RuntimeFactory.eINSTANCE.createETypedElementPrimitiveTypeListResult();
        EList resultList = derivedTypedElementListResult.getResultList();
        resultList.add((Object)5);
        resultList.add((Object)12);
        resultList.add((Object)9);
        Assert.assertEquals((long)3L, (long)derivedTypedElementListResult.getResultList().size());
    }
}

