/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.FacetTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FacetManagerTests {
    private IFacetManager facetManager;

    @Before
    public void init() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource serializationResource = resourceSet.createResource(URI.createURI((String)"dummy://testGetFacetOperationValue"));
        this.facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(serializationResource);
    }

    @Test
    public void testGetFacetOperationValueOldAPI() throws Exception {
        this.testGetFacetOperationValue(true);
    }

    @Test
    public void testGetFacetOperationValueNewAPI() throws Exception {
        this.testGetFacetOperationValue(false);
    }

    private void testGetFacetOperationValue(boolean testOldAPI) throws Exception {
        FacetOperation operation = FacetTestUtils.createSingleValuedFacetOperation("testGetFacetAttributeValue", (EClassifier)EcorePackage.eINSTANCE.getEString(), "test value for testGetFacetOperationValue", testOldAPI);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        String result = (String)this.facetManager.invoke(eObject, (EOperation)operation, String.class, null, new Object[0]);
        Assert.assertEquals((Object)"test value for testGetFacetOperationValue", (Object)result);
    }

    @Test
    public void test001IsConformingTrueFacetAttributeOldAPI() throws Exception {
        this.test001IsConformingTrueFacetAttribute(true);
    }

    @Test
    public void test001IsConformingTrueFacetAttributeNewAPI() throws Exception {
        this.test001IsConformingTrueFacetAttribute(false);
    }

    private void test001IsConformingTrueFacetAttribute(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet", EcorePackage.eINSTANCE.getEObject());
        FacetAttribute facetAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), Boolean.TRUE, testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)facetAttribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Assert.assertTrue((boolean)this.facetManager.isConforming(eObject, facet));
    }

    @Test
    public void test002IsConformingFalseFacetAttributeOldAPI() throws Exception {
        this.test002IsConformingFalseFacetAttribute(true);
    }

    @Test
    public void test002IsConformingFalseFacetAttributeNewAPI() throws Exception {
        this.test002IsConformingFalseFacetAttribute(false);
    }

    private void test002IsConformingFalseFacetAttribute(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet", EcorePackage.eINSTANCE.getEObject());
        FacetAttribute facetAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), Boolean.FALSE, testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)facetAttribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Assert.assertFalse((boolean)this.facetManager.isConforming(eObject, facet));
    }

    @Test
    public void test003IsConformingNoConformanceDerivedTypedElement() throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet", EcorePackage.eINSTANCE.getEClass());
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        Assert.assertTrue((boolean)this.facetManager.isConforming((EObject)eClass, facet));
    }

    @Test
    public void test008IsConformingNoConformanceDerivedTypedElementWrongType() throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet", EcorePackage.eINSTANCE.getEClass());
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        Assert.assertFalse((boolean)this.facetManager.isConforming((EObject)ePackage, facet));
    }

    @Test(expected=FacetManagerException.class)
    public void test004IsConformingFacetAttributeWrongTypeOldAPI() throws Exception {
        this.test004IsConformingFacetAttributeWrongType(true);
    }

    @Test(expected=FacetManagerException.class)
    public void test004IsConformingFacetAttributeWrongTypeNewAPI() throws Exception {
        this.test004IsConformingFacetAttributeWrongType(false);
    }

    private void test004IsConformingFacetAttributeWrongType(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet", EcorePackage.eINSTANCE.getEObject());
        FacetAttribute conformanceAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEString(), "false", testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)conformanceAttribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.isConforming(eObject, facet);
    }

    @Test(expected=FacetManagerException.class)
    public void test009IsConformingFacetAttributeWrongMultiplicityOldAPI() throws Exception {
        this.test009IsConformingFacetAttributeWrongMultiplicity(true);
    }

    @Test(expected=FacetManagerException.class)
    public void test009IsConformingFacetAttributeWrongMultiplicityNewAPI() throws Exception {
        this.test009IsConformingFacetAttributeWrongMultiplicity(false);
    }

    private void test009IsConformingFacetAttributeWrongMultiplicity(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet", EcorePackage.eINSTANCE.getEObject());
        FacetAttribute facetAttribute = FacetTestUtils.createMultiValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), Collections.singletonList(Boolean.TRUE), testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)facetAttribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.isConforming(eObject, facet);
    }

    @Test
    public void test005IsConformingTrueEAttribute() throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("conformanceAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        facet.getFacetElements().add((Object)attribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)attribute, (Object)Boolean.TRUE, null);
        facet.setConformanceTypedElement((ETypedElement)attribute);
        Assert.assertTrue((boolean)this.facetManager.isConforming(eObject, facet));
    }

    @Test
    public void test006IsConformingFalseEAttribute() throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("conformanceAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        facet.getFacetElements().add((Object)attribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)attribute, (Object)Boolean.FALSE, null);
        facet.setConformanceTypedElement((ETypedElement)attribute);
        Assert.assertFalse((boolean)this.facetManager.isConforming(eObject, facet));
    }

    @Test(expected=FacetManagerException.class)
    public void test007IsConformingEAttributeError() throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("conformanceAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetElements().add((Object)attribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)attribute, (Object)"true", null);
        facet.setConformanceTypedElement((ETypedElement)attribute);
        this.facetManager.isConforming(eObject, facet);
    }

    @Ignore
    @Test
    public void test010SetAttributeFacetAttributeInFacet() throws Exception {
    }

    @Test
    public void test011SetAttributeEAttributeInFacet() throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("testAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetElements().add((Object)attribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)attribute, (Object)"aTestValue", null);
        String attributeValue = (String)this.facetManager.getOrInvoke(eObject, (ETypedElement)attribute, String.class);
        Assert.assertEquals((Object)"aTestValue", (Object)attributeValue);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test012SetAttributeFacetAttributeNotInFacet() throws Exception {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        facetAttribute.setName("testAttribute");
        facetAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facetAttribute.setDerived(true);
        eClass.getEStructuralFeatures().add((Object)facetAttribute);
        this.facetManager.set((EObject)eClass, (EStructuralFeature)facetAttribute, (Object)"someValue", null);
    }

    @Test
    public void test013SetAttributeEAttributeNotInFacet() throws Exception {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        EAttribute attribute = EcorePackage.eINSTANCE.getENamedElement_Name();
        this.facetManager.set((EObject)eClass, (EStructuralFeature)attribute, (Object)"aTestValue", null);
        String attributeValue = (String)this.facetManager.getOrInvoke((EObject)eClass, (ETypedElement)attribute, String.class);
        Assert.assertEquals((Object)"aTestValue", (Object)attributeValue);
    }

    @Test
    public void test014SetAttributeEAttributeConformingEObjectOldAPI() throws Exception {
        this.test014SetAttributeEAttributeConformingEObject(true);
    }

    @Test
    public void test014SetAttributeEAttributeConformingEObjectNewAPI() throws Exception {
        this.test014SetAttributeEAttributeConformingEObject(false);
    }

    private void test014SetAttributeEAttributeConformingEObject(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        FacetAttribute conformanceAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), Boolean.TRUE, testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)conformanceAttribute);
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("testAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetElements().add((Object)attribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)attribute, (Object)"aTestValue", null);
        String attributeValue = (String)this.facetManager.getOrInvoke(eObject, (ETypedElement)attribute, String.class);
        Assert.assertEquals((Object)"aTestValue", (Object)attributeValue);
    }

    @Test(expected=FacetManagerException.class)
    public void test015SetAttributeEAttributeNonConformingEObjectOldAPI() throws Exception {
        this.test015SetAttributeEAttributeNonConformingEObject(true);
    }

    @Test(expected=FacetManagerException.class)
    public void test015SetAttributeEAttributeNonConformingEObjectNewAPI() throws Exception {
        this.test015SetAttributeEAttributeNonConformingEObject(false);
    }

    private void test015SetAttributeEAttributeNonConformingEObject(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        FacetAttribute conformanceAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), Boolean.FALSE, testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)conformanceAttribute);
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("testAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetElements().add((Object)attribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)attribute, (Object)"aTestValue", null);
    }

    @Test(expected=FacetManagerException.class)
    public void test016SetAttributeEAttributeNonConformingEObjectOldAPI() throws Exception {
        this.test016SetAttributeEAttributeNonConformingEObject(true);
    }

    @Test(expected=FacetManagerException.class)
    public void test016SetAttributeEAttributeNonConformingEObjectNewAPI() throws Exception {
        this.test016SetAttributeEAttributeNonConformingEObject(false);
    }

    private void test016SetAttributeEAttributeNonConformingEObject(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        FacetAttribute conformanceAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), Boolean.FALSE, testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)conformanceAttribute);
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("testAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetElements().add((Object)attribute);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)attribute, (Object)"aTestValue", null);
    }

    @Ignore
    @Test
    public void test017SetAttributeFacetAttributeConformingEObjectOldAPI() throws Exception {
        this.test017SetAttributeFacetAttributeConformingEObject(true);
    }

    @Ignore
    @Test
    public void test017SetAttributeFacetAttributeConformingEObjectNewAPI() throws Exception {
        this.test017SetAttributeFacetAttributeConformingEObject(false);
    }

    private void test017SetAttributeFacetAttributeConformingEObject(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        FacetAttribute conformanceAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), Boolean.TRUE, testOldAPI);
        facet.setConformanceTypedElement((ETypedElement)conformanceAttribute);
        FacetAttribute facetAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)EcorePackage.eINSTANCE.getEString(), null, testOldAPI);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        this.facetManager.set(eObject, (EStructuralFeature)facetAttribute, (Object)"aTestValue", null);
        String attributeValue = (String)this.facetManager.getOrInvoke(eObject, (ETypedElement)facetAttribute, String.class);
        Assert.assertEquals((Object)"aTestValue", (Object)attributeValue);
    }
}

