/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.cell.LayerCell;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidgetInternalUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

@Deprecated
public class NatTableDropListener
implements DropTargetListener {
    private final NatTable natTable;
    private final NatTableWidget natTableWidget;

    public NatTableDropListener(NatTable fNatTable, NatTableWidget natTableWidget) {
        this.natTable = fNatTable;
        this.natTableWidget = natTableWidget;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        GridElement gridElement;
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Object data = localTransfer.nativeToJava(event.currentDataType);
        List<PositionCoordinate> selectedCellsPositions = this.natTableWidget.getSelectedCellsPositions();
        Point point = this.natTableWidget.toControl(event.x, event.y);
        PositionCoordinate cellPosition = this.natTableWidget.getCellPositionAt(point.x, point.y);
        if (cellPosition == null) {
            if (selectedCellsPositions.size() != 0) {
                this.natTableWidget.getBodyLayer().getSelectionLayer().clear();
                this.natTable.redraw();
            }
            event.detail = 1;
            return;
        }
        if (selectedCellsPositions.size() != 1 || !selectedCellsPositions.get(0).equals((Object)cellPosition)) {
            this.natTableWidget.getBodyLayer().getSelectionLayer().selectCell(cellPosition.getColumnPosition(), cellPosition.getRowPosition(), false, false);
            this.natTable.redraw();
        }
        IStructuredSelection structuredSelection = null;
        if (data instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)data;
        }
        event.detail = (gridElement = this.getGridElement(cellPosition)) == null || !this.canDropOn(gridElement, structuredSelection) ? 0 : 16;
    }

    private boolean canDropOn(GridElement gridElement, IStructuredSelection structuredSelection) {
        Column columnDescription = gridElement.getColumnDescription();
        if (columnDescription instanceof MetaClassColumn || columnDescription instanceof DefaultLabelColumn || columnDescription instanceof EContainerColumn || columnDescription instanceof ContextColumn) {
            return false;
        }
        if (columnDescription instanceof ReferenceColumn || columnDescription instanceof AttributeColumn) {
            FeatureColumn featureColumn = (FeatureColumn)columnDescription;
            EStructuralFeature feature = featureColumn.getFeature();
            return this.canDropOnFeature(gridElement, structuredSelection, feature);
        }
        Logger.logError((String)("unhandled case:" + columnDescription.eClass().getName()), (Plugin)Activator.getDefault());
        return false;
    }

    private boolean canDropOnFeature(GridElement gridElement, IStructuredSelection structuredSelection, EStructuralFeature feature) {
        if (feature.getEType() instanceof EClass) {
            EClass eClass = (EClass)feature.getEType();
            Object element = gridElement.getElement();
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                if (!eObject.eClass().getEAllStructuralFeatures().contains((Object)feature)) {
                    return false;
                }
                if (structuredSelection != null) {
                    int nElements = 0;
                    for (Object object : structuredSelection) {
                        if (++nElements > 1 && !feature.isMany()) {
                            return false;
                        }
                        if (eClass.isInstance(object)) continue;
                        return false;
                    }
                    return this.natTableWidget.canBeDroped(structuredSelection, feature, element);
                }
                return true;
            }
        }
        return false;
    }

    public void drop(DropTargetEvent event) {
        Point point = this.natTableWidget.toControl(event.x, event.y);
        PositionCoordinate cellPosition = this.natTableWidget.getCellPositionAt(point.x, point.y);
        if (event.data instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)event.data;
            if (cellPosition == null) {
                this.dropInEmptySpace(structuredSelection);
            } else {
                GridElement gridElement = this.getGridElement(cellPosition);
                if (gridElement != null) {
                    this.dropOnGridElement(structuredSelection, gridElement);
                }
            }
        }
    }

    private GridElement getGridElement(PositionCoordinate cellPosition) {
        Object dataValue;
        LayerCell cell = this.natTableWidget.getCellAt(cellPosition.getColumnPosition(), cellPosition.getRowPosition());
        if (cell != null && (dataValue = cell.getDataValue()) instanceof GridElement) {
            GridElement gridElement = (GridElement)dataValue;
            return gridElement;
        }
        return null;
    }

    private void dropInEmptySpace(StructuredSelection structuredSelection) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (Object selectedElement : structuredSelection) {
            if (!(selectedElement instanceof EObject)) continue;
            EObject selectedEObject = (EObject)selectedElement;
            if (!NatTableWidgetInternalUtils.acceptsElement(selectedEObject, this.natTableWidget.getTableInstance().getTableConfiguration())) {
                MessageDialog.openWarning((Shell)this.natTableWidget.getShell(), (String)Messages.wrongEObjectType, (String)(String.valueOf(Messages.wrongEObjectTypeLong) + EcoreUtil.getURI((EObject)selectedEObject.eClass())));
                return;
            }
            list.add(selectedEObject);
        }
        this.natTableWidget.addRows(list);
    }

    private void dropOnGridElement(StructuredSelection structuredSelection, GridElement gridElement) {
        Column columnDescription = gridElement.getColumnDescription();
        if (columnDescription instanceof ReferenceColumn || columnDescription instanceof AttributeColumn) {
            FeatureColumn featureColumn = (FeatureColumn)columnDescription;
            this.dropOnFeature(structuredSelection, gridElement.getElement(), featureColumn.getFeature());
        } else {
            Logger.logError((String)("unhandled case:" + columnDescription.eClass().getName()), (Plugin)Activator.getDefault());
        }
    }

    private void dropOnFeature(StructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        if (!this.confirmMove((EObject)element, feature)) {
            return;
        }
        this.natTableWidget.drop(structuredSelection, element, feature);
    }

    private boolean confirmMove(EObject eObject, EStructuralFeature feature) {
        EReference reference;
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            Object list = eObject.eGet(feature);
            boolean empty = list == null || list instanceof List && ((List)list).isEmpty();
            String message = !empty && !feature.isMany() ? Messages.NatTableDropListener_valueWillBeMovedAndPreviousLost : Messages.NatTableDropListener_valueWillBeMoved;
            String fullMessage = String.valueOf(Messages.NatTableDropListener_compositeFeature) + message;
            return MessageDialog.openConfirm(null, (String)Messages.NatTableDropListener_moveElement, (String)fullMessage);
        }
        return true;
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

