/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.sdk.ui.internal.util.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class Utils {
    private Utils() {
    }

    public static EditingDomain getEditingDomain(ExecutionEvent event) {
        IWorkbenchPart part = Utils.getPart(event);
        IEditingDomainProvider edProvider = null;
        edProvider = part instanceof IEditingDomainProvider ? (IEditingDomainProvider)part : (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        EditingDomain editingDomain = null;
        if (edProvider != null) {
            editingDomain = edProvider.getEditingDomain();
        }
        return editingDomain;
    }

    private static IWorkbenchPart getPart(ExecutionEvent event) {
        IWorkbenchPart part = null;
        if (event.getApplicationContext() instanceof IEvaluationContext) {
            IEvaluationContext evalContext = (IEvaluationContext)event.getApplicationContext();
            part = (IWorkbenchPart)evalContext.getVariable("activePart");
        } else {
            IWorkbenchPage page;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                part = page.getActivePart();
            }
        }
        return part;
    }

    public static Display getDisplay(ExecutionEvent execEvent) {
        Display display = null;
        if (execEvent.getTrigger() instanceof Event) {
            Event event = (Event)execEvent.getTrigger();
            display = event.display;
        } else {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        return display;
    }
}

