/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.uicore.internal.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ColorProvider;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerLink
implements ITreeElement {
    private final EObject parent;
    private final ITreeElement treeParent;
    private final EObject container;
    private final AppearanceConfiguration appearanceConfiguration;

    public ContainerLink(EObject parent, ITreeElement treeParent, EObject container, AppearanceConfiguration appearanceConfiguration) {
        this.parent = parent;
        this.treeParent = treeParent;
        this.container = container;
        this.appearanceConfiguration = appearanceConfiguration;
    }

    @Override
    public String getText() {
        EStructuralFeature containingFeature;
        String oppositeLink = "";
        if (this.appearanceConfiguration.isShowOppositeLinks() && (containingFeature = this.parent.eContainingFeature()) != null) {
            oppositeLink = " <-> " + containingFeature.getName();
        }
        return "/eContainer" + oppositeLink;
    }

    @Override
    public Image getImage() {
        return ImageProvider.getInstance().getContainerIcon();
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    public List<ModelElementItem> getChildren() {
        if (this.container == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.appearanceConfiguration.getItemsFactory().createModelElementItem(this.container, this, this.appearanceConfiguration));
    }

    @Override
    public boolean hasChildren() {
        return this.container != null;
    }

    @Override
    public Font getFont() {
        return this.appearanceConfiguration.getCustomItalicFont();
    }

    @Override
    public Color getForeground() {
        if (this.container == null) {
            return ColorProvider.getInstance().getGray();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContainerLink) {
            ContainerLink other = (ContainerLink)obj;
            return Util.safeEquals(this.container, other.container) && this.parent.equals(other.parent);
        }
        return false;
    }

    public int hashCode() {
        int parentHashCode = this.parent.hashCode() + 13;
        if (this.container != null) {
            return this.container.hashCode() * 47 + parentHashCode;
        }
        return parentHashCode;
    }
}

