/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.facet.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.facet.infra.facet.edit.provider.FacetAttributeItemProvider;
import org.eclipse.emf.facet.infra.facet.edit.provider.FacetItemProvider;
import org.eclipse.emf.facet.infra.facet.edit.provider.FacetReferenceItemProvider;
import org.eclipse.emf.facet.infra.facet.edit.provider.FacetSetItemProvider;
import org.eclipse.emf.facet.infra.facet.edit.provider.ShortcutItemProvider;
import org.eclipse.emf.facet.infra.facet.util.FacetAdapterFactory;

public class FacetItemProviderAdapterFactory
extends FacetAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected FacetItemProvider facetItemProvider;
    protected FacetAttributeItemProvider facetAttributeItemProvider;
    protected FacetReferenceItemProvider facetReferenceItemProvider;
    protected FacetSetItemProvider facetSetItemProvider;
    protected ShortcutItemProvider shortcutItemProvider;

    public FacetItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createFacetAdapter() {
        if (this.facetItemProvider == null) {
            this.facetItemProvider = new FacetItemProvider((AdapterFactory)this);
        }
        return this.facetItemProvider;
    }

    public Adapter createFacetAttributeAdapter() {
        if (this.facetAttributeItemProvider == null) {
            this.facetAttributeItemProvider = new FacetAttributeItemProvider((AdapterFactory)this);
        }
        return this.facetAttributeItemProvider;
    }

    public Adapter createFacetReferenceAdapter() {
        if (this.facetReferenceItemProvider == null) {
            this.facetReferenceItemProvider = new FacetReferenceItemProvider((AdapterFactory)this);
        }
        return this.facetReferenceItemProvider;
    }

    public Adapter createFacetSetAdapter() {
        if (this.facetSetItemProvider == null) {
            this.facetSetItemProvider = new FacetSetItemProvider((AdapterFactory)this);
        }
        return this.facetSetItemProvider;
    }

    public Adapter createShortcutAdapter() {
        if (this.shortcutItemProvider == null) {
            this.shortcutItemProvider = new ShortcutItemProvider((AdapterFactory)this);
        }
        return this.shortcutItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.facetItemProvider != null) {
            this.facetItemProvider.dispose();
        }
        if (this.facetAttributeItemProvider != null) {
            this.facetAttributeItemProvider.dispose();
        }
        if (this.facetReferenceItemProvider != null) {
            this.facetReferenceItemProvider.dispose();
        }
        if (this.facetSetItemProvider != null) {
            this.facetSetItemProvider.dispose();
        }
        if (this.shortcutItemProvider != null) {
            this.shortcutItemProvider.dispose();
        }
    }
}

