/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.core.internal.filters;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.ui.IActionFilter;

public class QueryFilter
implements IActionFilter {
    public static final String QUERY = "isEmfFacetQuery";
    public static final String QUERY_SET = "isEmfFacetQuerySet";
    public static final String WORKSPACE_QUERY = "isWorkspaceQuery";
    public static final String WORKSPACE_QUERY_SET = "isWorkspaceQuerySet";

    public boolean testAttribute(Object target, String name, String value) {
        if (QUERY.equals(name)) {
            return Boolean.toString(target instanceof ModelQuery).equalsIgnoreCase(value);
        }
        if (QUERY_SET.equals(name)) {
            return Boolean.toString(target instanceof ModelQuerySet).equalsIgnoreCase(value);
        }
        if (WORKSPACE_QUERY.equals(name)) {
            if (target instanceof ModelQuery) {
                ModelQuery modelQuery = (ModelQuery)target;
                Resource resource = modelQuery.eResource();
                URI uri = resource.getURI();
                return Boolean.toString(uri.isPlatformResource()).equalsIgnoreCase(value);
            }
            return false;
        }
        if (WORKSPACE_QUERY_SET.equals(name) && target instanceof ModelQuerySet) {
            ModelQuerySet modelQuerySet = (ModelQuerySet)target;
            Resource resource = modelQuerySet.eResource();
            URI uri = resource.getURI();
            if (uri.isPlatform()) {
                return Boolean.toString(uri.isPlatformResource()).equalsIgnoreCase(value);
            }
            URI realUri = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName());
            return Boolean.toString(realUri.isPlatformResource()).equalsIgnoreCase(value);
        }
        return true;
    }
}

