/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Gregoire Dupe (Mia-Software) - Bug 339918 - To be able to have facet columns and to be able to have a local customization
 *    Nicolas Guyomar (Mia-Software) - Bug 339918 - To be able to have facet columns and to be able to have a local customization 
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Facet Attribute Column</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetAttributeColumnImpl#getFeature
 * <em>Feature</em>}</li>
 * <li>
 * {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetAttributeColumnImpl#getAttribute
 * <em>Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class FacetAttributeColumnImpl extends ColumnImpl implements FacetAttributeColumn {
	/**
	 * The cached value of the '{@link #getAttribute() <em>Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttribute()
	 * @generated
	 * @ordered
	 */
	protected FacetAttribute attribute;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FacetAttributeColumnImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TableinstancePackage.Literals.FACET_ATTRIBUTE_COLUMN;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EStructuralFeature getFeature() {
		EStructuralFeature feature = basicGetFeature();
		return feature != null && feature.eIsProxy() ? (EStructuralFeature)eResolveProxy((InternalEObject)feature) : feature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EStructuralFeature basicGetFeature() {
		return this.attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FacetAttribute getAttribute() {
		if (attribute != null && attribute.eIsProxy()) {
			InternalEObject oldAttribute = (InternalEObject)attribute;
			attribute = (FacetAttribute)eResolveProxy(oldAttribute);
			if (attribute != oldAttribute) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TableinstancePackage.FACET_ATTRIBUTE_COLUMN__ATTRIBUTE, oldAttribute, attribute));
			}
		}
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FacetAttribute basicGetAttribute() {
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttribute(final FacetAttribute newAttribute) {
		FacetAttribute oldAttribute = attribute;
		attribute = newAttribute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.FACET_ATTRIBUTE_COLUMN__ATTRIBUTE, oldAttribute, attribute));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(final int featureID, final boolean resolve, final boolean coreType) {
		switch (featureID) {
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN__FEATURE:
				if (resolve) return getFeature();
				return basicGetFeature();
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN__ATTRIBUTE:
				if (resolve) return getAttribute();
				return basicGetAttribute();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(final int featureID, final Object newValue) {
		switch (featureID) {
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN__ATTRIBUTE:
				setAttribute((FacetAttribute)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(final int featureID) {
		switch (featureID) {
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN__ATTRIBUTE:
				setAttribute((FacetAttribute)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(final int featureID) {
		switch (featureID) {
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN__FEATURE:
				return basicGetFeature() != null;
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN__ATTRIBUTE:
				return attribute != null;
		}
		return super.eIsSet(featureID);
	}

} //FacetAttributeColumnImpl
