/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetFeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * 
 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class TableinstanceAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TableinstancePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableinstanceAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = TableinstancePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(final Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableinstanceSwitch<Adapter> modelSwitch =
		new TableinstanceSwitch<Adapter>() {
			@Override
			public Adapter caseTableInstance(final TableInstance object) {
				return createTableInstanceAdapter();
			}
			@Override
			public Adapter caseQueryTableInstance(final QueryTableInstance object) {
				return createQueryTableInstanceAdapter();
			}
			@Override
			public Adapter caseColumn(final Column object) {
				return createColumnAdapter();
			}
			@Override
			public Adapter caseQueryColumn(final QueryColumn object) {
				return createQueryColumnAdapter();
			}
			@Override
			public Adapter caseReferenceColumn(final ReferenceColumn object) {
				return createReferenceColumnAdapter();
			}
			@Override
			public Adapter caseContextColumn(final ContextColumn object) {
				return createContextColumnAdapter();
			}
			@Override
			public Adapter caseMetaClassColumn(final MetaClassColumn object) {
				return createMetaClassColumnAdapter();
			}
			@Override
			public Adapter caseAttributeColumn(final AttributeColumn object) {
				return createAttributeColumnAdapter();
			}
			@Override
			public Adapter caseEContainerColumn(final EContainerColumn object) {
				return createEContainerColumnAdapter();
			}
			@Override
			public Adapter caseDefaultLabelColumn(final DefaultLabelColumn object) {
				return createDefaultLabelColumnAdapter();
			}
			@Override
			public Adapter caseFeatureColumn(final FeatureColumn object) {
				return createFeatureColumnAdapter();
			}
			@Override
			public Adapter caseRow(final Row object) {
				return createRowAdapter();
			}
			@Override
			public Adapter caseFacetAttributeColumn(final FacetAttributeColumn object) {
				return createFacetAttributeColumnAdapter();
			}
			@Override
			public Adapter caseFacetReferenceColumn(final FacetReferenceColumn object) {
				return createFacetReferenceColumnAdapter();
			}
			@Override
			public Adapter caseFacetFeatureColumn(final FacetFeatureColumn object) {
				return createFacetFeatureColumnAdapter();
			}
			@Override
			public Adapter defaultCase(final EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(final Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance <em>Table Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance
	 * @generated
	 */
	public Adapter createTableInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance <em>Query Table Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance
	 * @generated
	 */
	public Adapter createQueryTableInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column <em>Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column
	 * @generated
	 */
	public Adapter createColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn <em>Query Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn
	 * @generated
	 */
	public Adapter createQueryColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn <em>Reference Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn
	 * @generated
	 */
	public Adapter createReferenceColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn <em>Context Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn
	 * @generated
	 */
	public Adapter createContextColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn <em>Meta Class Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn
	 * @generated
	 */
	public Adapter createMetaClassColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn <em>Attribute Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn
	 * @generated
	 */
	public Adapter createAttributeColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn <em>EContainer Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn
	 * @generated
	 */
	public Adapter createEContainerColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn <em>Default Label Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn
	 * @generated
	 */
	public Adapter createDefaultLabelColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn <em>Feature Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn
	 * @generated
	 */
	public Adapter createFeatureColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row <em>Row</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row
	 * @generated
	 */
	public Adapter createRowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn <em>Facet Attribute Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn
	 * @generated
	 */
	public Adapter createFacetAttributeColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn <em>Facet Reference Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn
	 * @generated
	 */
	public Adapter createFacetReferenceColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetFeatureColumn <em>Facet Feature Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetFeatureColumn
	 * @generated
	 */
	public Adapter createFacetFeatureColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //TableinstanceAdapterFactory
