/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 *   Nicolas Guyomar (Mia-Software) - Bug 340941 - Need new row and column types in the table
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomPackage;
import org.eclipse.emf.facet.infra.facet.FacetPackage;
import org.eclipse.emf.facet.infra.query.runtime.RuntimePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Factory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class Tableinstance2PackageImpl extends EPackageImpl implements Tableinstance2Package {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tableInstance2EClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass queryRowEClass = null;
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass primitiveTypeQueryRowEClass = null;
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass eObjectQueryRowEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass valueColumnEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass queryTableInstance2EClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private Tableinstance2PackageImpl() {
		super(eNS_URI, Tableinstance2Factory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link Tableinstance2Package#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static Tableinstance2Package init() {
		if (isInited) return (Tableinstance2Package)EPackage.Registry.INSTANCE.getEPackage(Tableinstance2Package.eNS_URI);

		// Obtain or create and register package
		Tableinstance2PackageImpl theTableinstance2Package = (Tableinstance2PackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof Tableinstance2PackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new Tableinstance2PackageImpl());

		isInited = true;

		// Initialize simple dependencies
		TableinstancePackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theTableinstance2Package.createPackageContents();

		// Initialize created meta-data
		theTableinstance2Package.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theTableinstance2Package.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(Tableinstance2Package.eNS_URI, theTableinstance2Package);
		return theTableinstance2Package;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTableInstance2() {
		return tableInstance2EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTableInstance2_LocalCustomizations() {
		return (EReference)tableInstance2EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTableInstance2_Facets2() {
		return (EReference)tableInstance2EClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getQueryRow() {
		return queryRowEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getQueryRow_QueryResult() {
		return (EReference)queryRowEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPrimitiveTypeQueryRow() {
		return primitiveTypeQueryRowEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPrimitiveTypeQueryRow_Value() {
		return (EAttribute)primitiveTypeQueryRowEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEObjectQueryRow() {
		return eObjectQueryRowEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getValueColumn() {
		return valueColumnEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getQueryTableInstance2() {
		return queryTableInstance2EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getQueryTableInstance2_QueryResults2() {
		return (EReference)queryTableInstance2EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tableinstance2Factory getTableinstance2Factory() {
		return (Tableinstance2Factory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		tableInstance2EClass = createEClass(TABLE_INSTANCE2);
		createEReference(tableInstance2EClass, TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS);
		createEReference(tableInstance2EClass, TABLE_INSTANCE2__FACETS2);

		queryRowEClass = createEClass(QUERY_ROW);
		createEReference(queryRowEClass, QUERY_ROW__QUERY_RESULT);

		primitiveTypeQueryRowEClass = createEClass(PRIMITIVE_TYPE_QUERY_ROW);
		createEAttribute(primitiveTypeQueryRowEClass, PRIMITIVE_TYPE_QUERY_ROW__VALUE);

		eObjectQueryRowEClass = createEClass(EOBJECT_QUERY_ROW);

		valueColumnEClass = createEClass(VALUE_COLUMN);

		queryTableInstance2EClass = createEClass(QUERY_TABLE_INSTANCE2);
		createEReference(queryTableInstance2EClass, QUERY_TABLE_INSTANCE2__QUERY_RESULTS2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		TableinstancePackage theTableinstancePackage = (TableinstancePackage)EPackage.Registry.INSTANCE.getEPackage(TableinstancePackage.eNS_URI);
		UicustomPackage theUicustomPackage = (UicustomPackage)EPackage.Registry.INSTANCE.getEPackage(UicustomPackage.eNS_URI);
		FacetPackage theFacetPackage = (FacetPackage)EPackage.Registry.INSTANCE.getEPackage(FacetPackage.eNS_URI);
		RuntimePackage theRuntimePackage = (RuntimePackage)EPackage.Registry.INSTANCE.getEPackage(RuntimePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		tableInstance2EClass.getESuperTypes().add(theTableinstancePackage.getTableInstance());
		queryRowEClass.getESuperTypes().add(theTableinstancePackage.getRow());
		primitiveTypeQueryRowEClass.getESuperTypes().add(this.getQueryRow());
		eObjectQueryRowEClass.getESuperTypes().add(this.getQueryRow());
		valueColumnEClass.getESuperTypes().add(theTableinstancePackage.getColumn());
		queryTableInstance2EClass.getESuperTypes().add(theTableinstancePackage.getQueryTableInstance());
		queryTableInstance2EClass.getESuperTypes().add(this.getTableInstance2());

		// Initialize classes and features; add operations and parameters
		initEClass(tableInstance2EClass, TableInstance2.class, "TableInstance2", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTableInstance2_LocalCustomizations(), theUicustomPackage.getMetamodelView(), null, "localCustomizations", null, 1, -1, TableInstance2.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTableInstance2_Facets2(), theFacetPackage.getFacet(), null, "facets2", null, 0, -1, TableInstance2.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(queryRowEClass, QueryRow.class, "QueryRow", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getQueryRow_QueryResult(), theRuntimePackage.getModelQueryResult(), null, "queryResult", null, 0, 1, QueryRow.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(primitiveTypeQueryRowEClass, PrimitiveTypeQueryRow.class, "PrimitiveTypeQueryRow", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPrimitiveTypeQueryRow_Value(), ecorePackage.getEJavaObject(), "value", null, 0, 1, PrimitiveTypeQueryRow.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(eObjectQueryRowEClass, EObjectQueryRow.class, "EObjectQueryRow", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(valueColumnEClass, ValueColumn.class, "ValueColumn", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(queryTableInstance2EClass, QueryTableInstance2.class, "QueryTableInstance2", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getQueryTableInstance2_QueryResults2(), theRuntimePackage.getModelQueryResult(), null, "queryResults2", null, 0, -1, QueryTableInstance2.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} //Tableinstance2PackageImpl
