/**
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Bros (Mia-Software) - initial API and implementation
 * 
 */
package org.eclipse.emf.facet.infra.browser.custom.emf.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.facet.infra.browser.custom.emf.util.UicustomAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374109
 */
@Deprecated
public class UicustomItemProviderAdapterFactory extends UicustomAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UicustomItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.MetamodelView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetamodelViewItemProvider metamodelViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.MetamodelView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetamodelViewAdapter() {
		if (metamodelViewItemProvider == null) {
			metamodelViewItemProvider = new MetamodelViewItemProvider(this);
		}

		return metamodelViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.TypeView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeViewItemProvider typeViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.TypeView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeViewAdapter() {
		if (typeViewItemProvider == null) {
			typeViewItemProvider = new TypeViewItemProvider(this);
		}

		return typeViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.AttributeView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeViewItemProvider attributeViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.AttributeView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeViewAdapter() {
		if (attributeViewItemProvider == null) {
			attributeViewItemProvider = new AttributeViewItemProvider(this);
		}

		return attributeViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.ReferenceView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceViewItemProvider referenceViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.ReferenceView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceViewAdapter() {
		if (referenceViewItemProvider == null) {
			referenceViewItemProvider = new ReferenceViewItemProvider(this);
		}

		return referenceViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomViewFeatureItemProvider customViewFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomViewFeatureAdapter() {
		if (customViewFeatureItemProvider == null) {
			customViewFeatureItemProvider = new CustomViewFeatureItemProvider(this);
		}

		return customViewFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.FeatureValueCase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureValueCaseItemProvider featureValueCaseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.FeatureValueCase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureValueCaseAdapter() {
		if (featureValueCaseItemProvider == null) {
			featureValueCaseItemProvider = new FeatureValueCaseItemProvider(this);
		}

		return featureValueCaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.StaticFeatureValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StaticFeatureValueItemProvider staticFeatureValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.StaticFeatureValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStaticFeatureValueAdapter() {
		if (staticFeatureValueItemProvider == null) {
			staticFeatureValueItemProvider = new StaticFeatureValueItemProvider(this);
		}

		return staticFeatureValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.infra.browser.custom.DerivedFeatureValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DerivedFeatureValueItemProvider derivedFeatureValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.infra.browser.custom.DerivedFeatureValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDerivedFeatureValueAdapter() {
		if (derivedFeatureValueItemProvider == null) {
			derivedFeatureValueItemProvider = new DerivedFeatureValueItemProvider(this);
		}

		return derivedFeatureValueItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(final Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(final Notifier notifier, final Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(final Object object, final Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(final INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(final INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(final Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (metamodelViewItemProvider != null) metamodelViewItemProvider.dispose();
		if (typeViewItemProvider != null) typeViewItemProvider.dispose();
		if (attributeViewItemProvider != null) attributeViewItemProvider.dispose();
		if (referenceViewItemProvider != null) referenceViewItemProvider.dispose();
		if (customViewFeatureItemProvider != null) customViewFeatureItemProvider.dispose();
		if (featureValueCaseItemProvider != null) featureValueCaseItemProvider.dispose();
		if (staticFeatureValueItemProvider != null) staticFeatureValueItemProvider.dispose();
		if (derivedFeatureValueItemProvider != null) derivedFeatureValueItemProvider.dispose();
	}

}
