/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.swtbot;

import java.io.IOException;
import java.util.List;
import net.sourceforge.nattable.NatTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.nattable.tests.bug344563.internal.bug344563.MyEClass;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.tests.swtbot.SWTBotNatTable;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug344563Test {
    private static final int TIMEOUT = 30000;
    private static final int PREF_TIMEOUT = 5000;
    private static final int PREF_TYPE_INTERVAL = 10;
    private SWTWorkbenchBot bot;
    private static final String PROJECT_NAME = "projectBug344563";
    private static final String MODEL_FILE_NAME = "_Bug344563_model.xmi";
    private static final String TABLE_FILE_NAME = "_Bug344563_table.table";

    @BeforeClass
    public static void beforeClass() throws CoreException {
        SWTBotPreferences.TIMEOUT = 5000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        this.bot = new SWTWorkbenchBot();
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/Bug344563/_Bug344563_model.xmi", (IProject)testProject, (String)"/_Bug344563_model.xmi", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/Bug344563/_Bug344563_table.table", (IProject)testProject, (String)"/_Bug344563_table.table", (Bundle)bundle);
    }

    private void openFile(String fileName) {
        SWTBotUtils.captureScreenShot((String)"1");
        this.bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        SWTBotUtils.captureScreenShot((String)"2");
        SWTBotView view = this.bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)this.bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        item.doubleClick();
    }

    @Test(timeout=30000L)
    @Ignore
    public void testBug344563() {
        this.openFile(TABLE_FILE_NAME);
        final SWTBotEditor editor = this.bot.editorByTitle(TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTable().doubleClick(1, 4);
        final SWTBotCombo cellEditor = this.bot.comboBox("One");
        cellEditor.setText("");
        Assert.assertNotNull((Object)cellEditor);
        cellEditor.typeText("Wrong Enum Value");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                ((Combo)cellEditor.widget).notifyListeners(1, e);
            }
        });
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(INatTableWidgetProvider.class);
                INatTableWidget2 iNatTableWidget2 = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
                MyEClass class1 = (MyEClass)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"One", (Object)class1.getAttr().getLiteral());
            }
        });
        Bug344563Test.waitForResfreshJob(editor);
        this.getNatTable().doubleClick(1, 4);
        final SWTBotCombo cellEditor2 = this.bot.comboBox("One");
        Assert.assertNotNull((Object)cellEditor2);
        cellEditor2.setText("");
        cellEditor2.typeText("Two");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                ((Combo)cellEditor2.widget).notifyListeners(1, e);
            }
        });
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(INatTableWidgetProvider.class);
                INatTableWidget2 iNatTableWidget2 = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
                MyEClass class1 = (MyEClass)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"Two", (Object)class1.getAttr().getLiteral());
            }
        });
        this.bot.closeAllEditors();
    }

    private static void waitForResfreshJob(final SWTBotEditor editor) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(INatTableWidgetProvider.class);
                INatTableWidgetInternal iNatTableWidgetInternal = (INatTableWidgetInternal)natTableWidgetPart.getNatTableWidget();
                iNatTableWidgetInternal.waitForResfreshJob();
            }
        });
    }

    private SWTBotNatTable getNatTable() {
        NatTable nt = (NatTable)this.bot.widget(WidgetMatcherFactory.widgetOfType(NatTable.class));
        return new SWTBotNatTable(nt);
    }
}

