/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import net.sourceforge.nattable.painter.cell.BackgroundPainter;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.painter.cell.TextPainter;
import net.sourceforge.nattable.sort.painter.SortableHeaderTextPainter;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.internal.CustomizableLabelProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.HeaderImagePainter;
import org.eclipse.emf.facet.widgets.nattable.internal.HorizontalPainterWrapper;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class StyledColumnHeaderConfiguration
extends DefaultColumnHeaderStyleConfiguration {
    private static final String SELECTED_COLUMN_HEADER_BG_IMAGE = "selected_column_header_bg.png";
    private static final String COLUMN_HEADER_BG_IMAGE = "column_header_bg.png";
    private static final Color COLOR_GRAY = GUIHelper.getColor((int)192, (int)192, (int)192);
    private static final Color COLOR_LIGHT_GRAY = GUIHelper.getColor((int)230, (int)230, (int)230);
    private final NatTableWidget.BodyLayerStack bodyLayer;
    private final List<Column> columnDescriptions;
    private static final Image BG_IMAGE = new Image((Device)Display.getDefault(), StyledColumnHeaderConfiguration.class.getResourceAsStream("column_header_bg.png"));
    private static final Image SELECTED_BG_IMAGE = new Image((Device)Display.getDefault(), StyledColumnHeaderConfiguration.class.getResourceAsStream("selected_column_header_bg.png"));
    private final LabelProvider labelProvider;

    public StyledColumnHeaderConfiguration(NatTableWidget.BodyLayerStack bodyLayer, List<Column> columnDescriptions, CustomizableLabelProvider labelProvider) {
        this.bodyLayer = bodyLayer;
        this.columnDescriptions = columnDescriptions;
        this.labelProvider = labelProvider;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        this.addNormalModeStyling(configRegistry);
        this.addSelectedModeStyling(configRegistry);
        this.addCornerStyling(configRegistry);
    }

    private void addSelectedModeStyling(IConfigRegistry configRegistry) {
        BackgroundPainter selectedCellPainter = new BackgroundPainter((ICellPainter)this.createCellPainter());
        SortableHeaderTextPainter selectedHeaderPainter = new SortableHeaderTextPainter((ICellPainter)selectedCellPainter, false);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)selectedHeaderPainter, "SELECT", "COLUMN_HEADER");
    }

    private HorizontalPainterWrapper createCellPainter() {
        TextPainter txtPainter = new TextPainter(false, false);
        return new HorizontalPainterWrapper(new ICellPainter[]{new HeaderImagePainter(this.bodyLayer, this.columnDescriptions, this.labelProvider), txtPainter});
    }

    private void addNormalModeStyling(IConfigRegistry configurationRegistry) {
        BackgroundPainter normalCellPainter = new BackgroundPainter((ICellPainter)this.createCellPainter());
        SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter((ICellPainter)normalCellPainter, false);
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "COLUMN_HEADER");
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "SORT_DOWN");
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "SORT_UP");
    }

    private void addCornerStyling(IConfigRegistry configurationRegistry) {
        BackgroundPainter cornerPainter = new BackgroundPainter(this.createCellPainter()){

            public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
                if (cell.getColumnPosition() != 0) {
                    super.paintCell(cell, gc, rectangle, configRegistry);
                } else {
                    gc.setBackground(COLOR_LIGHT_GRAY);
                    gc.fillPolygon(new int[]{rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height});
                }
            }
        };
        SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter((ICellPainter)cornerPainter, false);
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "CORNER");
    }
}

