/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.notuithread;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.internal.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.nattable.internal.IPutOnTheTopQuestionDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class NatTableShowHideColumnsAPITests {
    private static final int TIMEOUT = 30000;
    private static final String RESOURCES = "/resources/v0_1/";
    private static final String RESOURCES_TEST = "tableTest.table";
    private static final String RESOURCES_ECORE_MODEL = "ecoreModel.ecore";
    private static final String PROJECT_NAME = "NatTableAPITestsProject";
    private INatTableWidget2 natTableWidget;
    private EditingDomain editingDomain;
    private Resource ecoreModel;
    private IProject project;
    private MetamodelView ecoreCustomization;

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public Resource getEcoreModel() {
        return this.ecoreModel;
    }

    public void setEcoreModel(Resource ecoreModel) {
        this.ecoreModel = ecoreModel;
    }

    public INatTableWidget2 getNatTableWidget() {
        return this.natTableWidget;
    }

    public void setNatTableWidget(INatTableWidget2 natTableWidget) {
        this.natTableWidget = natTableWidget;
    }

    public MetamodelView getEcoreCustomization() {
        return this.ecoreCustomization;
    }

    protected IEditorPart openEditorOnTable() throws PartInitException {
        IFile tableFile = this.project.getFile(RESOURCES_TEST);
        IEditorPart editor = NatTableShowHideColumnsAPITests.openEditor(tableFile);
        INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)editor.getAdapter(INatTableWidgetProvider.class);
        Assert.assertNotNull((Object)natTableWidgetPart);
        this.setNatTableWidget((INatTableWidget2)natTableWidgetPart.getNatTableWidget());
        return editor;
    }

    private static IEditorPart openEditor(IFile file) throws PartInitException {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        return editor;
    }

    protected void addEcoreCustomization() {
        EList customizations = this.getNatTableWidget().getTableInstance().getCustomizations();
        customizations.add(this.getEcoreCustomization());
        ((INatTableWidgetInternal)this.getNatTableWidget()).loadCustomizations((List)customizations);
    }

    @Before
    public void initResource() throws CoreException, IOException {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/tableTest.table", (IProject)this.project, (String)"/tableTest.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/ecoreModel.ecore", (IProject)this.project, (String)"/ecoreModel.ecore", (Bundle)bundle);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IEditorPart editor;
                try {
                    editor = NatTableShowHideColumnsAPITests.this.openEditorOnTable();
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertTrue((boolean)(editor instanceof IEditingDomainProvider));
                NatTableShowHideColumnsAPITests.this.setEditingDomain(((IEditingDomainProvider)editor).getEditingDomain());
                Assert.assertNotNull((Object)NatTableShowHideColumnsAPITests.this.getEditingDomain());
                NatTableShowHideColumnsAPITests.this.setEcoreModel(NatTableShowHideColumnsAPITests.this.getEditingDomain().getResourceSet().getResource(URI.createPlatformResourceURI((String)"NatTableAPITestsProject/ecoreModel.ecore", (boolean)true), true));
                Assert.assertNotNull((Object)NatTableShowHideColumnsAPITests.this.getEcoreModel());
                EObject element = (EObject)NatTableShowHideColumnsAPITests.this.getNatTableWidget().getTableInstance().getElements().get(0);
                ResourceSet resourceSet = element.eResource().getResourceSet();
                URI uri = URI.createPlatformPluginURI((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + NatTableShowHideColumnsAPITests.RESOURCES + "ecore.uiCustom"), (boolean)false);
                Resource resource = resourceSet.getResource(uri, true);
                NatTableShowHideColumnsAPITests.this.setEcoreCustomization((MetamodelView)resource.getContents().get(0));
                Assert.assertNotNull((Object)NatTableShowHideColumnsAPITests.this.getEcoreCustomization());
            }
        });
    }

    @Test(timeout=30000L)
    public void addACustomizationTest() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Assert.assertTrue((boolean)(NatTableShowHideColumnsAPITests.this.getNatTableWidget() instanceof INatTableWidgetInternal));
                Assert.assertFalse((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().getTableInstance().getCustomizations().contains((Object)NatTableShowHideColumnsAPITests.this.getEcoreCustomization()));
                NatTableShowHideColumnsAPITests.this.addEcoreCustomization();
                Assert.assertTrue((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().getTableInstance().getCustomizations().contains((Object)NatTableShowHideColumnsAPITests.this.getEcoreCustomization()));
            }
        });
    }

    @Test(timeout=30000L)
    public void changeLocalCustomIndexTest() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Assert.assertTrue((boolean)(NatTableShowHideColumnsAPITests.this.getNatTableWidget() instanceof INatTableWidgetInternal));
                NatTableShowHideColumnsAPITests.this.addEcoreCustomization();
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheBottom();
                Assert.assertTrue((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().isOneOfTheLocalCustomizationsNotOnTheTop());
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheTop();
                Assert.assertFalse((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().isOneOfTheLocalCustomizationsNotOnTheTop());
            }
        });
    }

    @Test(timeout=30000L)
    public void showHideColumnsDeselectAllTest() {
        org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().setValue("nattable_editor_select_column_to_hide", true);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheTop();
            }
        });
        final IColumnsToHideDialog[] dialog = new IColumnsToHideDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0] = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).openColumnsToHideDialog();
            }
        });
        Assert.assertNotNull((Object)dialog);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0].deselectAll();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0].ok();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                List visibleColumnsAfter = NatTableShowHideColumnsAPITests.this.getNatTableWidget().getVisibleColumns(true);
                Assert.assertTrue((boolean)visibleColumnsAfter.isEmpty());
                visibleColumnsAfter = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).getVisibleColumnsUsingTheLayer();
                Assert.assertTrue((boolean)visibleColumnsAfter.isEmpty());
            }
        });
    }

    @Test(timeout=30000L)
    public void showHideColumnsSelectAllTest() {
        org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().setValue("nattable_editor_select_column_to_hide", true);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheTop();
            }
        });
        final IColumnsToHideDialog[] dialog = new IColumnsToHideDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0] = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).openColumnsToHideDialog();
            }
        });
        Assert.assertNotNull((Object)dialog);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0].selectAll();
                dialog[0].ok();
                List visibleColumnsAfter = NatTableShowHideColumnsAPITests.this.getNatTableWidget().getVisibleColumns(true);
                Assert.assertTrue((visibleColumnsAfter.size() == NatTableShowHideColumnsAPITests.this.getNatTableWidget().getTableInstance().getColumns().size() ? 1 : 0) != 0);
                visibleColumnsAfter = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).getVisibleColumnsUsingTheLayer();
                Assert.assertTrue((visibleColumnsAfter.size() == NatTableShowHideColumnsAPITests.this.getNatTableWidget().getTableInstance().getColumns().size() ? 1 : 0) != 0);
            }
        });
    }

    @Test(timeout=30000L)
    public void showHideColumnsUserAnswerIsYesTest() {
        org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().setValue("nattable_editor_select_column_to_hide", false);
        final IPutOnTheTopQuestionDialog[] putDialog = new IPutOnTheTopQuestionDialog[1];
        final IColumnsToHideDialog[] dialog = new IColumnsToHideDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.addEcoreCustomization();
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheBottom();
                dialog[0] = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).openColumnsToHideDialog();
                Assert.assertNotNull((Object)dialog);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0] = dialog[0].getPutOnTheTopQuestionDialog();
                Assert.assertNotNull((Object)putDialog[0]);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0].yes();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0].ok();
                Assert.assertFalse((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().isOneOfTheLocalCustomizationsNotOnTheTop());
                Assert.assertFalse((boolean)org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().getBoolean("nattable_editor_select_column_to_hide"));
            }
        });
    }

    @Test(timeout=30000L)
    public void showHideColumnsUserAnswerIsNoTest() {
        org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().setValue("nattable_editor_select_column_to_hide", false);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.addEcoreCustomization();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheBottom();
            }
        });
        final IColumnsToHideDialog[] dialog = new IColumnsToHideDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0] = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).openColumnsToHideDialog();
            }
        });
        Assert.assertNotNull((Object)dialog[0]);
        final IPutOnTheTopQuestionDialog[] putDialog = new IPutOnTheTopQuestionDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0] = dialog[0].getPutOnTheTopQuestionDialog();
                Assert.assertNotNull((Object)putDialog);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0].no();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0].ok();
                Assert.assertTrue((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().isOneOfTheLocalCustomizationsNotOnTheTop());
                Assert.assertFalse((boolean)org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().getBoolean("nattable_editor_select_column_to_hide"));
            }
        });
    }

    @Test(timeout=30000L)
    public void showHideColumnsDontAskTheNextTimeWithYesTest() {
        org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().setValue("nattable_editor_select_column_to_hide", false);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.addEcoreCustomization();
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheBottom();
            }
        });
        final IColumnsToHideDialog[] dialog = new IColumnsToHideDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0] = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).openColumnsToHideDialog();
            }
        });
        Assert.assertNotNull((Object)dialog[0]);
        final IPutOnTheTopQuestionDialog[] putDialog = new IPutOnTheTopQuestionDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0] = dialog[0].getPutOnTheTopQuestionDialog();
                Assert.assertNotNull((Object)putDialog);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0].check();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0].yes();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0].ok();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().isOneOfTheLocalCustomizationsNotOnTheTop());
                Assert.assertTrue((boolean)org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().getBoolean("nattable_editor_select_column_to_hide"));
                Assert.assertTrue((boolean)org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().getString("answer_nattable_editor_select_column_to_hide").equals("Yes"));
            }
        });
    }

    @Test(timeout=30000L)
    public void showHideColumnsDontAskTheNextTimeWithNoTest() {
        org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().setValue("nattable_editor_select_column_to_hide", false);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.addEcoreCustomization();
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().putLocalCustomizationOnTheBottom();
            }
        });
        final IColumnsToHideDialog[] dialog = new IColumnsToHideDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0] = ((INatTableWidgetInternal)NatTableShowHideColumnsAPITests.this.getNatTableWidget()).openColumnsToHideDialog();
            }
        });
        Assert.assertNotNull((Object)dialog[0]);
        final IPutOnTheTopQuestionDialog[] putDialog = new IPutOnTheTopQuestionDialog[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0] = dialog[0].getPutOnTheTopQuestionDialog();
                Assert.assertNotNull((Object)putDialog[0]);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0].check();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                putDialog[0].no();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog[0].ok();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Assert.assertTrue((boolean)NatTableShowHideColumnsAPITests.this.getNatTableWidget().isOneOfTheLocalCustomizationsNotOnTheTop());
                Assert.assertTrue((boolean)org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().getBoolean("nattable_editor_select_column_to_hide"));
                Assert.assertTrue((boolean)org.eclipse.emf.facet.widgets.nattable.internal.Activator.getDefault().getPreferenceStore().getString("answer_nattable_editor_select_column_to_hide").equals("No"));
            }
        });
    }

    @Test(timeout=30000L)
    public void sortAToZ() {
        String[] wantedOrder = new String[]{"[Label]", "[Metaclass]", "/eContainer", "abstract", "/defaultValue", "/eAllAttributes", "/eAllContainments", "/eAllGenericSuperTypes", "/eAllOperations", "/eAllReferences", "/eAllStructuralFeatures", "/eAllSuperTypes", "eAnnotations", "/eAttributes", "eGenericSuperTypes", "/eIDAttribute", "eOperations", "ePackage", "/eReferences", "eStructuralFeatures", "eSuperTypes", "eTypeParameters", "/instanceClass", "instanceClassName", "instanceTypeName", "interface", "name"};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().sortColumnByNameAtoZ();
            }
        });
        EList columns = this.getNatTableWidget().getTableInstance().getColumns();
        Assert.assertTrue((String)"This test is not correctly written", (wantedOrder.length == columns.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < columns.size()) {
            Assert.assertTrue((String)("The column " + wantedOrder[i] + " is misplaced."), (boolean)wantedOrder[i].equals(NatTableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i)))));
            ++i;
        }
    }

    @Ignore
    @Test(timeout=30000L)
    public void sortZToA() {
        String[] wantedOrder = new String[]{"name", "interface", "instanceTypeName", "instanceClassName", "/instanceClass", "eTypeParameters", "eSuperTypes", "eStructuralFeatures", "/eReferences", "ePackage", "eOperations", "/eIDAttribute", "eGenericSuperTypes", "/eAttributes", "eAnnotations", "/eAllSuperTypes", "/eAllStructuralFeatures", "/eAllReferences", "/eAllOperations", "/eAllGenericSuperTypes", "/eAllContainments", "/eAllAttributes", "/defaultValue", "abstract", "/eContainer", "[Metaclass]", "[Label]"};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NatTableShowHideColumnsAPITests.this.getNatTableWidget().sortColumnByNameZtoA();
            }
        });
        EList columns = this.getNatTableWidget().getTableInstance().getColumns();
        Assert.assertTrue((String)"This test is not correctly written", (wantedOrder.length == columns.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < columns.size()) {
            Assert.assertTrue((String)("The column " + wantedOrder[i] + " is misplaced."), (boolean)wantedOrder[i].equals(NatTableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i)))));
            ++i;
        }
    }

    @After
    public void closeAllEditors() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
    }

    public void setEcoreCustomization(MetamodelView ecoreCustomization) {
        this.ecoreCustomization = ecoreCustomization;
    }
}

