/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot;

import java.io.IOException;
import java.util.List;
import net.sourceforge.nattable.NatTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.ScreenShotUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot.SWTBotNatTable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class NatTableUITests {
    protected static final String RESOURCES = "/resources/v0_1/testUiResources/";
    protected static final int TIMEOUT = 30000;
    protected static final int PREF_TIMEOUT = 30000;
    protected static final int PREF_TYPE_INTERVAL = 10;
    protected static final String PROJECT_NAME = "tableTestProject";
    protected static final String ECORE_TABLE_FILE_NAME = "_test_tableEcoreTest2.table";
    protected static final String ECORE_FILE_NAME = "_test_EcoreModel.ecore";
    private int state = 0;
    private INatTableWidget2 natTableWidget2;
    protected boolean actionsNotified;

    protected INatTableWidget2 getNatTableWidget2() {
        return this.natTableWidget2;
    }

    protected void setNatTableWidget2(INatTableWidget2 natTableWidget) {
        this.natTableWidget2 = natTableWidget;
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.TIMEOUT = 30000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/testUiResources/_test_tableEcoreTest2.table", (IProject)testProject, (String)"/_test_tableEcoreTest2.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/testUiResources/_test_EcoreModel.ecore", (IProject)testProject, (String)"/_test_EcoreModel.ecore", (Bundle)bundle);
    }

    protected void sync() {
        this.state = ((INatTableWidgetInternal)this.natTableWidget2).waitForResfreshJob();
    }

    protected void syncAndScreenShot(String message) {
        this.state = ((INatTableWidgetInternal)this.natTableWidget2).waitForResfreshJob();
        ScreenShotUtils.capture((String)message, (int)1);
    }

    protected void addQueryColumn() throws Exception {
        SWTBotUtils.executeCommand((String)"org.eclipse.emf.facet.widgets.nattable.addQueryColumnCommand");
    }

    @Test(timeout=30000L)
    public void testCopySelectionToClipboard() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        final SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTable().selectColumn(1);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                iNatTableWidget2.copySelectionToClipboard();
                Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                String textData = (String)clipboard.getContents((Transfer)textTransfer);
                String newline = System.getProperty("line.separator");
                Assert.assertEquals((Object)("[Label]" + newline + "Class1" + newline + "Class2" + newline + "Class3" + newline + "MyPackage"), (Object)textData);
            }
        });
    }

    @Test(timeout=30000L)
    public void testIsColumnSelected() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        final SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTable().selectColumn(1);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertTrue((boolean)iNatTableWidget2.isColumnSelected());
            }
        });
        this.getNatTable().click(1, 1, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertFalse((boolean)iNatTableWidget2.isColumnSelected());
            }
        });
    }

    @Test(timeout=30000L)
    public void testIsSelectedCellEditable() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        final SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTable().click(1, 5, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertTrue((boolean)iNatTableWidget2.isSelectedCellEditable());
            }
        });
        this.getNatTable().click(1, 4, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertTrue((boolean)iNatTableWidget2.isSelectedCellEditable());
            }
        });
        this.getNatTable().click(1, 3, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertFalse((boolean)iNatTableWidget2.isSelectedCellEditable());
            }
        });
    }

    @Test(timeout=30000L)
    @Ignore
    public void testOpenLoadCustomizationDialog() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.natTableWidget2 = this.getNatTableWidget(editor);
        EditingDomain editingDomain = this.getEditingDomain(editor);
        EList custom = this.natTableWidget2.getTableInstance().getCustomizations();
        Assert.assertEquals((long)1L, (long)custom.size());
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBot dialogBot1 = bot.shell("Load Customizations").bot();
        SWTBotUtils.captureScreenShot((String)"1 opened Load Customizations dialog");
        final SWTBotTree availableCustomTree = dialogBot1.treeWithLabel("Available Customizations");
        SWTBotTree loadedCustomTree = dialogBot1.treeWithLabel("Feature");
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return availableCustomTree.rowCount() != 1 || !"Loading...".equals(availableCustomTree.getAllItems()[0].getText());
            }

            public String getFailureMessage() {
                return "waiting for customizations tree to load";
            }
        });
        SWTBotUtils.captureScreenShot((String)"2 Load Customizations dialog finished loading");
        int availableCustomCount = availableCustomTree.getAllItems().length;
        int loadedCustomCount = loadedCustomTree.getAllItems().length;
        Assert.assertTrue((loadedCustomCount >= 1 ? 1 : 0) != 0);
        availableCustomTree.select(new int[]{0});
        dialogBot1.button(">").click();
        Assert.assertEquals((long)(availableCustomCount - 1), (long)availableCustomTree.getAllItems().length);
        dialogBot1.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        editingDomain.getCommandStack().redo();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        SWTBotUtils.captureScreenShot((String)"3 opened Load Customizations dialog");
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBot dialogBot = bot.shell("Load Customizations").bot();
        SWTBotTree loadedCustomTree2 = dialogBot.treeWithLabel("Feature");
        SWTBotUtils.waitUntilNotEmpty((SWTBotTree)loadedCustomTree2, (int)30000);
        SWTBotUtils.captureScreenShot((String)"4 Load Customizations dialog finished loading");
        loadedCustomTree2.setFocus();
        loadedCustomTree2.getAllItems()[0].select();
        dialogBot.button("<").click();
        SWTBotUtils.captureScreenShot((String)"5 First item removed from the list");
        SWTBot warningDialogBot = bot.shell("Load Customizations Warning").bot();
        warningDialogBot.button("OK").click();
        SWTBotTree loadedCustomTree3 = dialogBot.treeWithLabel("Feature");
        loadedCustomTree3.select(new int[]{1});
        dialogBot.button("<").click();
        dialogBot.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        editingDomain.getCommandStack().redo();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        EList columns = this.natTableWidget2.getTableInstance().getColumns();
        Assert.assertEquals((long)33L, (long)columns.size());
        ScreenShotUtils.capture((String)"BEGIN Load the test customization without loading associated facetSet");
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        ScreenShotUtils.capture((String)"After to have clicked on 'Load a Customization'");
        SWTBot dialog2Bot = bot.shell("Load Customizations").bot();
        SWTBotTree availableCustomTree2 = dialog2Bot.treeWithLabel("Available Customizations");
        SWTBotUtils.waitUntilNotEmpty((SWTBotTree)availableCustomTree2, (int)30000);
        availableCustomTree2.select(new String[]{"testUIEcoreUICustom"});
        ScreenShotUtils.capture((String)"After to have clicked on 'testUIEcoreUICustom'");
        dialog2Bot.button(">").click();
        dialog2Bot.checkBox().deselect();
        dialog2Bot.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        SWTBotUtils.waitUntilAssertListSize((int)33, (List)columns);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)33, (List)columns);
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBotUtils.captureScreenShot((String)"1 opened load customization dialog");
        SWTBotShell dialogShell = bot.shell("Load Customizations");
        SWTBot dialog3Bot = dialogShell.bot();
        final SWTBotTree availableCustomTree3 = dialog3Bot.treeWithLabel("Available Customizations");
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return availableCustomTree3.rowCount() != 1 || !"Loading...".equals(availableCustomTree3.getAllItems()[0].getText());
            }

            public String getFailureMessage() {
                return "waiting for customizations tree to load";
            }
        });
        SWTBotUtils.captureScreenShot((String)"1a Load Customizations dialog finished loading");
        availableCustomTree3.select(new String[]{"testUIEcoreUICustom"});
        dialog3Bot.button(">").click();
        SWTBotUtils.captureScreenShot((String)"2 selected customization");
        dialog3Bot.checkBox().select();
        SWTBotUtils.captureScreenShot((String)"3 before clicking OK");
        dialog3Bot.button("OK").click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)dialogShell));
        SWTBotUtils.captureScreenShot((String)"4 dialog closed");
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        SWTBotUtils.waitUntilAssertListSize((int)34, (List)columns);
        editingDomain.getCommandStack().undo();
        editor.save();
    }

    @Test(timeout=30000L)
    @Ignore
    public void testOpenLoadFacetDialog() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        FacetSetCatalog.getSingleton();
        SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.natTableWidget2 = this.getNatTableWidget(editor);
        EditingDomain editingDomain = this.getEditingDomain(editor);
        EList facets = ((TableInstance2)this.natTableWidget2.getTableInstance()).getFacets2();
        Assert.assertEquals((long)0L, (long)facets.size());
        SWTBotUtils.getToolbarButton((String)"Load an EMF Facet", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBot dialogBot = bot.shell("Load Facets").bot();
        dialogBot.tree().getTreeItem("testUIEcoreFacetSet").check();
        dialogBot.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)facets);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)0, (List)facets);
        editingDomain.getCommandStack().redo();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)facets);
        SWTBotUtils.getToolbarButton((String)"Load an EMF Facet", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBot dialog2Bot = bot.shell("Load Facets").bot();
        SWTBotTreeItem facetItem = dialog2Bot.tree().getTreeItem("testUIEcoreFacetSet");
        Assert.assertTrue((boolean)facetItem.isChecked());
        facetItem.uncheck();
        dialog2Bot.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)0, (List)facets);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)facets);
        editingDomain.getCommandStack().redo();
        SWTBotUtils.waitUntilAssertListSize((int)0, (List)facets);
        editor.save();
    }

    protected void setActionsNotified(boolean value) {
        this.actionsNotified = value;
    }

    @Test(timeout=30000L)
    public void testActionDelegateRegistration() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        this.actionsNotified = false;
        this.natTableWidget2 = this.getNatTableWidget(editor);
        IActionDelegate actiondelegate = new IActionDelegate(){

            public void selectionChanged(IAction action, ISelection selection) {
                UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                    public void run() {
                        NatTableUITests.this.setActionsNotified(true);
                    }
                });
            }

            public void run(IAction action) {
            }
        };
        this.natTableWidget2.registerActionDelegate(actiondelegate);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                NatTableUITests.this.natTableWidget2.sortColumnByNameAtoZ();
                NatTableUITests.this.sync();
            }
        });
        bot.sleep(500L);
        Assert.assertTrue((boolean)this.actionsNotified);
        this.natTableWidget2.unregisterActionDelegate(actiondelegate);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                NatTableUITests.this.setActionsNotified(false);
                NatTableUITests.this.natTableWidget2.sortColumnsByType();
                NatTableUITests.this.sync();
            }
        });
        bot.sleep(500L);
        Assert.assertFalse((boolean)this.actionsNotified);
        editor.save();
    }

    protected INatTableWidget2 getNatTableWidget(SWTBotEditor editor) {
        INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(INatTableWidgetProvider.class);
        return (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
    }

    protected EditingDomain getEditingDomain(SWTBotEditor editor) {
        return ((IEditingDomainProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(IEditingDomainProvider.class)).getEditingDomain();
    }

    protected SWTBotNatTable getNatTable() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        NatTable nt = (NatTable)bot.widget(WidgetMatcherFactory.widgetOfType(NatTable.class));
        return new SWTBotNatTable(nt);
    }

    protected void openTableFile(String fileName) {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.captureScreenShot((String)"1");
        bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        SWTBotUtils.captureScreenShot((String)"2");
        SWTBotView view = bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        item.doubleClick();
    }
}

