/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.uithread;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.junit.core.internal.exported.AbstractLogListenerTest;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableEditorFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public abstract class Bug345730CheckTableIntegrityOnOpening
extends AbstractLogListenerTest {
    private static final int TIMEOUT = 30000;
    private static final String WIDGET_NATTABLE_PLUGIN_ID = "org.eclipse.emf.facet.widgets.nattable";
    private static final String ECORE_FILE_NAME = "Bug345730CheckTableIntegrityOnOpening.ecore";
    private static final String TABLE_FILE_NAME = "Bug345730CheckTableIntegrityOnOpening.table";
    private static final String RESOURCE_FOLDER = "/resources/v0_2/Bug345730/";
    private static final int NB_ROWS_IN_THE_TABLE_MODEL = 4;
    private static final int NB_VALID_ROWS_IN_THE_TABLE_MODEL = 2;
    private Resource ecoreResource;
    private ITableWidget tableWidget;
    private Table tableInstance;
    private static final int NB_NOT_FEATURE_COLUMN = 3;
    private static final String DEBUG_OPTION = "org.eclipse.emf.facet.widgets.nattable.tests/debug/Bug345730CheckTableIntegrityOnOpening";
    private static final boolean DEBUG = Activator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.widgets.nattable.tests/debug/Bug345730CheckTableIntegrityOnOpening"));
    private int allColumnsSize;
    private EditingDomain editingDomain;
    private Resource tableInstanceResource;
    private EPackage ePackage;
    private String projectName;

    @Before
    public void beforeTests() throws CoreException, IOException {
        this.projectName = ((Object)((Object)this)).getClass().getName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IProject testProject = workspace.getRoot().getProject(this.projectName);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/Bug345730/Bug345730CheckTableIntegrityOnOpening.ecore", (IProject)testProject, (String)"/Bug345730CheckTableIntegrityOnOpening.ecore", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/Bug345730/Bug345730CheckTableIntegrityOnOpening.table", (IProject)testProject, (String)"/Bug345730CheckTableIntegrityOnOpening.table", (Bundle)bundle);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.ecoreResource = resourceSet.getResource(URI.createPlatformResourceURI((String)(String.valueOf(this.projectName) + '/' + ECORE_FILE_NAME), (boolean)false), true);
        Assert.assertNotNull((Object)this.ecoreResource);
        Assert.assertTrue((boolean)(this.ecoreResource.getContents().get(0) instanceof EPackage));
        this.ePackage = (EPackage)this.ecoreResource.getContents().get(0);
        this.tableInstanceResource = resourceSet.getResource(URI.createPlatformResourceURI((String)(String.valueOf(this.projectName) + '/' + TABLE_FILE_NAME), (boolean)false), true);
        Assert.assertNotNull((Object)this.tableInstanceResource);
        this.tableInstance = (Table)this.tableInstanceResource.getContents().get(0);
        Assert.assertEquals((long)4L, (long)this.tableInstance.getRows().size());
        this.countStructuralFeatures();
        this.editingDomain = this.initEditingDomain((ResourceSet)resourceSet);
        ITableEditorFactory.DEFAULT.openOn(this.tableInstance, this.editingDomain);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        ITableWidgetProvider tableWidgetProvider = (ITableWidgetProvider)editor.getAdapter(ITableWidgetProvider.class);
        this.tableWidget = tableWidgetProvider.getTableWidget();
        this.tableInstance = this.tableWidget.getTable();
        Assert.assertEquals((Object)this.tableInstance, (Object)this.tableWidget.getTable());
        Assert.assertEquals((Object)this.tableInstanceResource, (Object)this.tableWidget.getTable().eResource());
        Assert.assertEquals((Object)this.tableInstanceResource.getResourceSet(), (Object)resourceSet);
        Assert.assertEquals((Object)this.ecoreResource.getResourceSet(), (Object)resourceSet);
    }

    private void countStructuralFeatures() {
        EList eObjectFeatures;
        HashSet features = new HashSet();
        EcoreUtil.resolveAll((EObject)this.ePackage);
        for (EObject eObject : this.ePackage.getEClassifiers()) {
            eObjectFeatures = eObject.eClass().getEAllStructuralFeatures();
            features.addAll(eObjectFeatures);
        }
        for (EObject eObject : this.ePackage.getEAnnotations()) {
            eObjectFeatures = eObject.eClass().getEAllStructuralFeatures();
            features.addAll(eObjectFeatures);
        }
        this.allColumnsSize = features.size() + 3;
        if (DEBUG) {
            for (EStructuralFeature structuralFeature : features) {
                System.out.println("org.eclipse.emf.facet.widgets.nattable.tests.internal.uithread.Bug345730CheckTableIntegrityOnOpening.countStructuralFeatures(): " + EcoreUtil.getURI((EObject)structuralFeature));
            }
        }
    }

    protected abstract EditingDomain initEditingDomain(ResourceSet var1);

    @Test(timeout=30000L)
    public void checkTableIntegrityOnOpening() {
        for (Column column : this.tableInstance.getColumns()) {
            if (!(column instanceof FeatureColumn)) continue;
            FeatureColumn featureColumn = (FeatureColumn)column;
            ETypedElement feature = featureColumn.getFeature();
            String featureName = feature.getName();
            Assert.assertNotNull((Object)featureName);
            EObject eContainer = feature.eContainer();
            Assert.assertFalse((String)("The column " + featureName + " should have been removed."), (eContainer == EcorePackage.eINSTANCE.getEEnum() ? 1 : 0) != 0);
            System.out.println();
        }
        Assert.assertEquals((long)2L, (long)this.tableInstance.getRows().size());
        if (DEBUG && this.allColumnsSize != this.tableInstance.getColumns().size()) {
            for (Column column : this.tableInstance.getColumns()) {
                String columnName;
                if (column instanceof FeatureColumn) {
                    FeatureColumn featureColumn = (FeatureColumn)column;
                    ETypedElement feature = featureColumn.getFeature();
                    URI featureURI = EcoreUtil.getURI((EObject)feature);
                    columnName = featureURI.toString();
                } else {
                    columnName = column.getClass().getName();
                }
                System.out.println("org.eclipse.emf.facet.widgets.nattable.tests.internal.uithread.Bug345730CheckTableIntegrityOnOpening.checkTableIntegrityOnOpening(): " + columnName);
            }
        }
        Assert.assertEquals((long)this.allColumnsSize, (long)this.tableInstance.getColumns().size());
    }

    @After
    public void afterTests() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.closeAllEditors(false);
    }

    protected Bundle[] getPluginsToListen() {
        return new Bundle[]{Platform.getBundle((String)WIDGET_NATTABLE_PLUGIN_ID)};
    }
}

