/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.uithread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.junit.core.internal.exported.AbstractLogListenerTest;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.TableTestUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableEditorFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public abstract class Bug346465Test2
extends AbstractLogListenerTest {
    private static final int TIMEOUT = 30000;
    private static final String PROJECT_NAME = "projectBug346465";
    private static final String ECORE_FILE_NAME = "_Bug346465_Ecore.ecore";
    private static final String TABLE_CONFIGURATION_FILE_PATH = "resources/v0_2/Bug346465/_Bug346465_EcoreTableConfiguration.tableconfiguration";
    private Resource ecoreModel;
    private ITableWidget ITableWidget;
    private Table tableInstance;
    private static final int NB_NOT_FEATURE_COLUMN = 3;
    private static final String WIDGET_NATTABLE_PLUGIN_ID = "org.eclipse.emf.facet.widgets.nattable";
    private int allColumnsSize;
    private int columnsSizeWithoutEENum;
    private int columnsSizeWithoutEClasses;
    private int columnsSizeWithoutEClassesAndEENum;
    private EditingDomain editingDomain;
    private Column facetAttributeColumn;

    @Before
    public void beforeTests() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IProject testProject = workspace.getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/Bug346465/_Bug346465_Ecore.ecore", (IProject)testProject, (String)"/_Bug346465_Ecore.ecore", (Bundle)bundle);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.ecoreModel = resourceSet.getResource(URI.createPlatformResourceURI((String)"projectBug346465/_Bug346465_Ecore.ecore", (boolean)false), true);
        Assert.assertNotNull((Object)this.ecoreModel);
        Assert.assertTrue((boolean)(this.ecoreModel.getContents().get(0) instanceof EPackage));
        EPackage ePackage = (EPackage)this.ecoreModel.getContents().get(0);
        ArrayList eObjectsToAddInTheTable = new ArrayList();
        eObjectsToAddInTheTable.addAll(ePackage.getEClassifiers());
        eObjectsToAddInTheTable.addAll(ePackage.getEAnnotations());
        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + '/' + TABLE_CONFIGURATION_FILE_PATH), (boolean)false);
        Resource resource = resourceSet.getResource(uri, true);
        TableConfiguration tableConfiguration = (TableConfiguration)resource.getContents().get(0);
        this.editingDomain = this.initEditingDomain((ResourceSet)resourceSet);
        ITableEditorFactory.DEFAULT.openOn(eObjectsToAddInTheTable, this.editingDomain, "", tableConfiguration, null, null);
        this.ITableWidget = TableTestUtils.getNatTableWidgetOfActivePart();
        this.tableInstance = this.ITableWidget.getTable();
        this.facetAttributeColumn = (Column)this.ITableWidget.getTable().getColumns().get(34);
        Assert.assertTrue((boolean)(this.facetAttributeColumn instanceof FeatureColumn));
        HashSet features = new HashSet();
        HashSet featuresWithoutEEnum = new HashSet();
        HashSet featuresWithoutEClass = new HashSet();
        HashSet featuresWithoutEClassAndEEnum = new HashSet();
        for (EObject eObject : eObjectsToAddInTheTable) {
            EList eObjectFeatures = eObject.eClass().getEAllStructuralFeatures();
            features.addAll(eObjectFeatures);
            ArrayList facetFeatures = new ArrayList();
            for (Facet facet : tableConfiguration.getDefaultFacets()) {
                Assert.assertNull((Object)facet.getConformanceTypedElement());
                if (!facet.getExtendedMetaclass().isInstance((Object)eObject)) continue;
                facetFeatures.addAll(facet.getFacetElements());
            }
            features.addAll(facetFeatures);
            if (!(eObject instanceof EEnum)) {
                featuresWithoutEEnum.addAll(eObjectFeatures);
                featuresWithoutEEnum.addAll(facetFeatures);
            }
            if (!(eObject instanceof EClass)) {
                featuresWithoutEClass.addAll(eObjectFeatures);
                featuresWithoutEClass.addAll(facetFeatures);
            }
            if (eObject instanceof EClass || eObject instanceof EEnum) continue;
            featuresWithoutEClassAndEEnum.addAll(eObjectFeatures);
            featuresWithoutEClassAndEEnum.addAll(facetFeatures);
        }
        this.allColumnsSize = features.size() + 3;
        this.columnsSizeWithoutEENum = featuresWithoutEEnum.size() + 3;
        this.columnsSizeWithoutEClasses = featuresWithoutEClass.size() + 3;
        this.columnsSizeWithoutEClassesAndEENum = featuresWithoutEClassAndEEnum.size() + 3;
    }

    protected abstract EditingDomain initEditingDomain(ResourceSet var1);

    @Ignore
    @Test(timeout=30000L)
    public void testBug346465DeleteSelection() {
        junit.framework.Assert.fail();
    }

    @Ignore
    @Test(timeout=30000L)
    public void testBug346465RemoveLine() {
        int initialNbRows = this.tableInstance.getRows().size();
        Assert.assertEquals((long)this.allColumnsSize, (long)this.tableInstance.getColumns().size());
        this.ITableWidget.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.ITableWidget.removeLine();
        Assert.assertEquals((long)this.allColumnsSize, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.ITableWidget.getTable().getColumns().contains((Object)this.facetAttributeColumn));
        int expectedRowSize = initialNbRows - 1;
        Assert.assertEquals((long)expectedRowSize, (long)this.tableInstance.getRows().size());
        this.ITableWidget.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(1)).getElement());
        this.ITableWidget.removeLine();
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)this.columnsSizeWithoutEENum, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)(--expectedRowSize), (long)this.tableInstance.getRows().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)this.allColumnsSize, (long)this.tableInstance.getColumns().size());
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)this.allColumnsSize, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        this.ITableWidget.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.ITableWidget.removeLine();
        Assert.assertEquals((long)(--expectedRowSize), (long)this.tableInstance.getRows().size());
        this.ITableWidget.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.ITableWidget.removeLine();
        Assert.assertEquals((long)(--expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.columnsSizeWithoutEClasses, (long)this.tableInstance.getColumns().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        this.ITableWidget.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.ITableWidget.removeLine();
        Assert.assertEquals((long)(--expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.columnsSizeWithoutEClassesAndEENum, (long)this.tableInstance.getColumns().size());
        this.ITableWidget.selectDefaultLabelCell(((Row)this.tableInstance.getRows().get(0)).getElement());
        this.ITableWidget.removeLine();
        Assert.assertEquals((long)(--expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().isEmpty());
        Assert.assertTrue((boolean)this.tableInstance.getRows().isEmpty());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.columnsSizeWithoutEClassesAndEENum, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertTrue((boolean)this.tableInstance.getColumns().contains((Object)this.facetAttributeColumn));
        Assert.assertEquals((long)this.columnsSizeWithoutEClasses, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().redo();
        Assert.assertEquals((long)(--expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.columnsSizeWithoutEClassesAndEENum, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().redo();
        Assert.assertEquals((long)(--expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)0L, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.columnsSizeWithoutEClassesAndEENum, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.columnsSizeWithoutEClasses, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.allColumnsSize, (long)this.tableInstance.getColumns().size());
        this.editingDomain.getCommandStack().undo();
        Assert.assertEquals((long)(++expectedRowSize), (long)this.tableInstance.getRows().size());
        Assert.assertEquals((long)this.allColumnsSize, (long)this.tableInstance.getColumns().size());
    }

    @After
    public void closeAllEditors() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
    }

    protected Bundle[] getPluginsToListen() {
        return new Bundle[]{Platform.getBundle((String)WIDGET_NATTABLE_PLUGIN_ID)};
    }
}

