/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal.serialization;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.internal.CastUtils;
import org.eclipse.emf.facet.efacet.core.internal.exception.SaveStructuralFeatureInstanceModelException;
import org.eclipse.emf.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;
import org.eclipse.emf.facet.efacet.core.internal.serialization.ILinkToExtendedEObjectReference;
import org.eclipse.emf.facet.efacet.core.internal.serialization.ILinkToExtendedEObjectReferenceAdapterFactory;
import org.eclipse.emf.facet.efacet.core.internal.serialization.LinkToExtendedEObjectReferenceAdapter;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.AbstractAttributeInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.AbstractReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.ExtendedEObjectReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.MultiValuedAttributeInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.MultiValuedContainmentReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.MultiValuedReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SerializationFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SingleValuedAttributeInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SingleValuedContainmentReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SingleValuedReferenceInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationManager {
    private Resource sfInstResource;
    private final IFacetManager facetManager;

    public SerializationManager(Resource sfInstResource, IFacetManager facetManager) {
        this.facetManager = facetManager;
        this.setSerializationResource(sfInstResource);
    }

    private static MultiValuedContainmentReferenceInstance createMultiValuedContainmentReferenceInstance(EReference reference, List<EObject> values, ExtendedEObjectReference extendedEObjRef) {
        MultiValuedContainmentReferenceInstance containmentRI = SerializationFactory.eINSTANCE.createMultiValuedContainmentReferenceInstance();
        containmentRI.setEReference(reference);
        if (values != null) {
            containmentRI.getOwnedElements().addAll(values);
        }
        extendedEObjRef.getReferenceInstances().add((Object)containmentRI);
        return containmentRI;
    }

    private static ExtendedEObjectReference getExtendedEObjectReference(EObject eObject) {
        ExtendedEObjectReference result = null;
        for (Adapter adapter : eObject.eAdapters()) {
            if (!adapter.isAdapterForType(ILinkToExtendedEObjectReference.class)) continue;
            LinkToExtendedEObjectReferenceAdapter castedAdapter = (LinkToExtendedEObjectReferenceAdapter)adapter;
            result = castedAdapter.getExtendedEObjectReference();
            break;
        }
        return result;
    }

    private static MultiValuedAttributeInstance createMultiValuedAttributeInstance(EAttribute attribute, List<Object> values, ExtendedEObjectReference extendedEObjRef) {
        MultiValuedAttributeInstance attributeInstance = SerializationFactory.eINSTANCE.createMultiValuedAttributeInstance();
        attributeInstance.setEAttribute(attribute);
        if (values != null) {
            attributeInstance.getValues().addAll(values);
        }
        EList attInstances = extendedEObjRef.getAttributeInstances();
        attInstances.add((Object)attributeInstance);
        return attributeInstance;
    }

    private static MultiValuedReferenceInstance createMultiValuedReferenceInstance(EReference reference, List<EObject> values, ExtendedEObjectReference extendedEObjRef) {
        MultiValuedReferenceInstance referenceInstance = SerializationFactory.eINSTANCE.createMultiValuedReferenceInstance();
        referenceInstance.setEReference(reference);
        if (values != null) {
            referenceInstance.getReferencedElements().addAll(values);
        }
        extendedEObjRef.getReferenceInstances().add((Object)referenceInstance);
        return referenceInstance;
    }

    private static SingleValuedAttributeInstance getSingleValuedAttributeInstance(ExtendedEObjectReference extendedEObjRef, EAttribute eAttribute) {
        SingleValuedAttributeInstance result = null;
        EList attInstances = extendedEObjRef.getAttributeInstances();
        for (AbstractAttributeInstance attributeInstance : attInstances) {
            if (!eAttribute.equals(attributeInstance.getEAttribute())) continue;
            if (attributeInstance instanceof SingleValuedAttributeInstance) {
                result = (SingleValuedAttributeInstance)attributeInstance;
                break;
            }
            throw new IllegalStateException("single valued attribute should be associated to an instance of SingleValuedAttributeInstance");
        }
        return result;
    }

    private static MultiValuedAttributeInstance getMultiValuedAttributeInstance(ExtendedEObjectReference extendedEObjRef, EAttribute eAttribute) {
        MultiValuedAttributeInstance result = null;
        EList attInstances = extendedEObjRef.getAttributeInstances();
        for (AbstractAttributeInstance attributeInstance : attInstances) {
            if (!eAttribute.equals(attributeInstance.getEAttribute())) continue;
            if (attributeInstance instanceof MultiValuedAttributeInstance) {
                result = (MultiValuedAttributeInstance)attributeInstance;
                break;
            }
            throw new IllegalStateException("multi valued attribute should be associated to an instance of MultiValuedAttributeInstance");
        }
        return result;
    }

    private static SingleValuedReferenceInstance getSingleValuedReferenceInstance(ExtendedEObjectReference extendedEObjRef, EReference eReference) {
        SingleValuedReferenceInstance result = null;
        EList refInstances = extendedEObjRef.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : refInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof SingleValuedReferenceInstance) {
                result = (SingleValuedReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a single valued non-containment reference should be associated to an instance of SingleValuedReferenceInstance");
        }
        return result;
    }

    private static SingleValuedContainmentReferenceInstance getSingleValuedContainmentReferenceInstance(ExtendedEObjectReference extendedEObjRef, EReference eReference) {
        SingleValuedContainmentReferenceInstance result = null;
        EList refInstances = extendedEObjRef.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : refInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof SingleValuedContainmentReferenceInstance) {
                result = (SingleValuedContainmentReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a single valued containment reference should be associated to an instance of SingleValuedContainmentReferenceInstance");
        }
        return result;
    }

    private static MultiValuedReferenceInstance getMultiValuedReferenceInstance(ExtendedEObjectReference extendedEObjRef, EReference eReference) {
        MultiValuedReferenceInstance result = null;
        EList refInstances = extendedEObjRef.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : refInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof MultiValuedReferenceInstance) {
                result = (MultiValuedReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a multi valued non-containment reference should be associated to an instance of MultiValuedReferenceInstance");
        }
        return result;
    }

    private static MultiValuedContainmentReferenceInstance getMultiValuedContainmentReferenceInstance(ExtendedEObjectReference extendedEObjRef, EReference eReference) {
        MultiValuedContainmentReferenceInstance result = null;
        EList refInstances = extendedEObjRef.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : refInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof MultiValuedContainmentReferenceInstance) {
                result = (MultiValuedContainmentReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a multi valued containment reference should be associated to an instance of MultiValuedContainmentReferenceInstance");
        }
        return result;
    }

    public void saveStructuralFeatureInstanceModel() throws SaveStructuralFeatureInstanceModelException {
        if (this.sfInstResource == null) {
            throw new SaveStructuralFeatureInstanceModelException("This facet manager has been initailized with a null structural feature instances resource");
        }
        try {
            this.sfInstResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new SaveStructuralFeatureInstanceModelException(e);
        }
    }

    private ExtendedEObjectReference getOrCreateExtendedEObjectReference(EObject eObject) {
        ExtendedEObjectReference extendedEObjRef = SerializationManager.getExtendedEObjectReference(eObject);
        if (extendedEObjRef == null) {
            extendedEObjRef = SerializationFactory.eINSTANCE.createExtendedEObjectReference();
            extendedEObjRef.setExtendedEObject(eObject);
            if (this.sfInstResource != null) {
                this.sfInstResource.getContents().add((Object)extendedEObjRef);
            }
            LinkToExtendedEObjectReferenceAdapter adapter = (LinkToExtendedEObjectReferenceAdapter)ILinkToExtendedEObjectReferenceAdapterFactory.INSTANCE.adapt((Notifier)eObject, ILinkToExtendedEObjectReference.class);
            adapter.setExtendedEObjectReference(extendedEObjRef);
        }
        return extendedEObjRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(EObject eObject, EAttribute attribute, Object newValue) {
        ExtendedEObjectReference extendedEObjRef = this.getOrCreateExtendedEObjectReference(eObject);
        if (attribute.isMany()) {
            if (!(newValue instanceof List)) throw new IllegalArgumentException("The given FacetAttribute is multiplicity-many, so the value must be a List");
            List list = (List)newValue;
            MultiValuedAttributeInstance attributeInstance = SerializationManager.getMultiValuedAttributeInstance(extendedEObjRef, attribute);
            if (attributeInstance == null) {
                SerializationManager.createMultiValuedAttributeInstance(attribute, list, extendedEObjRef);
                return;
            } else {
                attributeInstance.getValues().clear();
                attributeInstance.getValues().addAll((Collection)list);
            }
            return;
        } else {
            SingleValuedAttributeInstance attributeInstance = SerializationManager.getSingleValuedAttributeInstance(extendedEObjRef, attribute);
            if (attributeInstance == null) {
                SerializationManager.createSingleValuedAttributeInstance(attribute, newValue, extendedEObjRef);
                return;
            } else {
                attributeInstance.setValue(newValue);
            }
        }
    }

    private static SingleValuedAttributeInstance createSingleValuedAttributeInstance(EAttribute attribute, Object value, ExtendedEObjectReference extendedEObjRef) {
        SingleValuedAttributeInstance attributeInstance = SerializationFactory.eINSTANCE.createSingleValuedAttributeInstance();
        attributeInstance.setEAttribute(attribute);
        attributeInstance.setValue(value);
        extendedEObjRef.getAttributeInstances().add((Object)attributeInstance);
        return attributeInstance;
    }

    private static SingleValuedReferenceInstance createSingleValuedReferenceInstance(EReference reference, EObject value, ExtendedEObjectReference extendedEObjRef) {
        SingleValuedReferenceInstance referenceInstance = SerializationFactory.eINSTANCE.createSingleValuedReferenceInstance();
        referenceInstance.setEReference(reference);
        referenceInstance.setReferencedElement(value);
        EList refInstances = extendedEObjRef.getReferenceInstances();
        refInstances.add((Object)referenceInstance);
        return referenceInstance;
    }

    public void setReference(EObject eObject, EReference reference, Object newValue) {
        ExtendedEObjectReference extendedEObjRef = this.getOrCreateExtendedEObjectReference(eObject);
        if (reference.isMany()) {
            List<EObject> newList;
            try {
                newList = CastUtils.castToExpectedListType(newValue, EObject.class);
            }
            catch (UnmatchingExpectedTypeException e) {
                String message = String.format("The reference %s.%s is multivaluted, that's why the new value must be a list of EObjet.", reference.getName(), reference.getEContainingClass().getName());
                throw new IllegalArgumentException(message, e);
            }
            MultiValuedReferenceInstance mValuedRefInst = SerializationManager.getMultiValuedReferenceInstance(extendedEObjRef, reference);
            mValuedRefInst.getReferencedElements().clear();
            mValuedRefInst.getReferencedElements().addAll(newList);
        } else {
            if (newValue != null && !(newValue instanceof EObject)) {
                throw new IllegalArgumentException("newValue should be an EObject because eStructuralFeature is an EReference");
            }
            EObject newEObjectValue = (EObject)newValue;
            if (reference.isContainment()) {
                SingleValuedContainmentReferenceInstance referenceInstance = SerializationManager.getSingleValuedContainmentReferenceInstance(extendedEObjRef, reference);
                if (referenceInstance == null) {
                    SerializationManager.createSingleValuedContainmentReferenceInstance(reference, newEObjectValue, extendedEObjRef);
                } else {
                    referenceInstance.setOwnedElement(newEObjectValue);
                }
            } else {
                SingleValuedReferenceInstance referenceInstance = SerializationManager.getSingleValuedReferenceInstance(extendedEObjRef, reference);
                if (referenceInstance == null) {
                    SerializationManager.createSingleValuedReferenceInstance(reference, newEObjectValue, extendedEObjRef);
                } else {
                    referenceInstance.setReferencedElement(newEObjectValue);
                }
            }
        }
    }

    private static SingleValuedContainmentReferenceInstance createSingleValuedContainmentReferenceInstance(EReference reference, EObject value, ExtendedEObjectReference extendedEObjRef) {
        SingleValuedContainmentReferenceInstance containmentRefI = SerializationFactory.eINSTANCE.createSingleValuedContainmentReferenceInstance();
        containmentRefI.setEReference(reference);
        containmentRefI.setOwnedElement(value);
        extendedEObjRef.getReferenceInstances().add((Object)containmentRefI);
        return containmentRefI;
    }

    private List<?> getMultiValuedStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        EList result = null;
        ExtendedEObjectReference extendedEObjRef = this.getOrCreateExtendedEObjectReference(eObject);
        if (structuralFeature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)structuralFeature;
            MultiValuedAttributeInstance attributeInstance = SerializationManager.getMultiValuedAttributeInstance(extendedEObjRef, eAttribute);
            if (attributeInstance != null) {
                result = attributeInstance.getValues();
            }
        } else if (structuralFeature instanceof EReference) {
            EReference eReference = (EReference)structuralFeature;
            if (eReference.isContainment()) {
                MultiValuedContainmentReferenceInstance referenceInstance = SerializationManager.getMultiValuedContainmentReferenceInstance(extendedEObjRef, eReference);
                if (referenceInstance == null) {
                    referenceInstance = SerializationManager.createMultiValuedContainmentReferenceInstance(eReference, null, extendedEObjRef);
                    result = referenceInstance.getOwnedElements();
                } else {
                    result = referenceInstance.getOwnedElements();
                }
            } else {
                MultiValuedReferenceInstance referenceInstance = SerializationManager.getMultiValuedReferenceInstance(extendedEObjRef, eReference);
                if (referenceInstance == null) {
                    referenceInstance = SerializationManager.createMultiValuedReferenceInstance(eReference, null, extendedEObjRef);
                    result = referenceInstance.getReferencedElements();
                } else {
                    result = referenceInstance.getReferencedElements();
                }
            }
        } else {
            throw new UnsupportedOperationException("Getting a structural feature of type '" + structuralFeature.getClass().getName() + "' is not implemented");
        }
        return result;
    }

    private static Object getSingleValuedStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        Object result = null;
        ExtendedEObjectReference extendedEObjRef = SerializationManager.getExtendedEObjectReference(eObject);
        if (extendedEObjRef != null) {
            if (structuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)structuralFeature;
                SingleValuedAttributeInstance attributeInstance = SerializationManager.getSingleValuedAttributeInstance(extendedEObjRef, eAttribute);
                if (attributeInstance != null) {
                    result = attributeInstance.getValue();
                }
            } else if (structuralFeature instanceof EReference) {
                EReference eReference = (EReference)structuralFeature;
                if (eReference.isContainment()) {
                    SingleValuedContainmentReferenceInstance referenceInstance = SerializationManager.getSingleValuedContainmentReferenceInstance(extendedEObjRef, eReference);
                    result = referenceInstance.getOwnedElement();
                } else {
                    SingleValuedReferenceInstance referenceInstance = SerializationManager.getSingleValuedReferenceInstance(extendedEObjRef, eReference);
                    result = referenceInstance.getReferencedElement();
                }
            } else {
                throw new IllegalArgumentException("Unexpected structuralFeature kind");
            }
        }
        return result;
    }

    public Object getNotDerivedValue(EObject eObject, EStructuralFeature structuralFeature) {
        List<?> result = structuralFeature.isMany() ? this.getMultiValuedStructuralFeature(eObject, structuralFeature) : SerializationManager.getSingleValuedStructuralFeature(eObject, structuralFeature);
        return result;
    }

    public Resource getSerializationResource() {
        return this.sfInstResource;
    }

    public final void setSerializationResource(Resource resource) {
        this.sfInstResource = resource;
        if (this.sfInstResource != null) {
            EList contents = this.sfInstResource.getContents();
            for (EObject eObject : contents) {
                if (!(eObject instanceof ExtendedEObjectReference)) continue;
                ExtendedEObjectReference extendedEObjRef = (ExtendedEObjectReference)eObject;
                EObject extendedEObject = extendedEObjRef.getExtendedEObject();
                LinkToExtendedEObjectReferenceAdapter adapter = (LinkToExtendedEObjectReferenceAdapter)ILinkToExtendedEObjectReferenceAdapterFactory.INSTANCE.adapt((Notifier)extendedEObject, ILinkToExtendedEObjectReference.class);
                adapter.setExtendedEObjectReference(extendedEObjRef);
                EList attInstances = extendedEObjRef.getAttributeInstances();
                for (AbstractAttributeInstance attributeInstance : attInstances) {
                    EAttribute attribute = attributeInstance.getEAttribute();
                    this.loadParentFacetSet((EStructuralFeature)attribute);
                }
                EList refInstances = extendedEObjRef.getReferenceInstances();
                for (AbstractReferenceInstance referenceInstance : refInstances) {
                    EReference reference = referenceInstance.getEReference();
                    this.loadParentFacetSet((EStructuralFeature)reference);
                }
            }
        }
    }

    private void loadParentFacetSet(EStructuralFeature sFeature) {
        FacetSet facetSet = FacetUtils.getFacetSet((ETypedElement)sFeature);
        this.facetManager.getManagedFacetSets().add(facetSet);
    }
}

