/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.CustomFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationTable;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.InternalTableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateTableUtils {
    private CreateTableUtils() {
    }

    private static void applyDefaultSettings(TableConfiguration tableConfig, Table table) {
        if (tableConfig != null) {
            CreateTableUtils.applyDefaultFacets(tableConfig, table);
            CreateTableUtils.applyDefaultCustom(tableConfig, table);
            CreateTableUtils.applyDefaultLocalCustom(tableConfig, table);
            table.setCanBePresentedInTheTable((ETypedElement)tableConfig.getCanBePresentedInTheTable());
        }
    }

    private static void applyDefaultLocalCustom(TableConfiguration tableConfig, Table table) {
        for (Customization custom : tableConfig.getDefaultLocalCustomizations()) {
            if (table.getLocalCustomizations().contains((Object)custom)) continue;
            table.getLocalCustomizations().add((Object)custom);
        }
    }

    private static void applyDefaultCustom(TableConfiguration tableConfig, Table table) {
        for (Customization custom : tableConfig.getDefaultCustomizations()) {
            if (table.getCustomizations().contains((Object)custom)) continue;
            table.getCustomizations().add((Object)custom);
        }
    }

    private static void applyDefaultFacets(TableConfiguration tableConfig, Table table) {
        for (Facet facet : tableConfig.getDefaultFacets()) {
            try {
                if (table.getFacetSets().contains((Object)facet.eContainer())) continue;
                table.getFacetSets().add((Object)((FacetSet)facet.eContainer()));
            }
            catch (Exception exception) {
                Logger.logError((String)("The referenced facet:" + facet + " could not be loaded"), (Plugin)Activator.getDefault());
            }
        }
    }

    public static void createColumns(Table table) {
        if (table instanceof NavigationTable) {
            table.getColumns().add((Object)TableFactory.eINSTANCE.createSourceColumn());
            for (Row row : table.getRows()) {
                if (!(row instanceof PrimitiveTypeQueryRow)) continue;
                table.getColumns().add((Object)TableFactory.eINSTANCE.createValueColumn());
                break;
            }
        }
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        if (table.getTableConfiguration() != null) {
            features.addAll((Collection<EStructuralFeature>)table.getTableConfiguration().getDefaultColumns());
        }
        for (EStructuralFeature eStructuralFeature : InternalTableUtils.getAllStructuralFeatures(table)) {
            if (features.contains(eStructuralFeature)) continue;
            features.add(eStructuralFeature);
        }
        for (ETypedElement eTypedElement : features) {
            FeatureColumn fColumn = TableFactory.eINSTANCE.createFeatureColumn();
            fColumn.setFeature(eTypedElement);
            table.getColumns().add((Object)fColumn);
        }
    }

    public static Table createTableInstance(List<? extends EObject> elements, String description, TableConfiguration tableConfig, EObject context, Object parameter) {
        Table table = TableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(tableConfig);
        table.setContext(context);
        table.setParameter(parameter);
        table.setDescription(description);
        HashSet<EObject> added = new HashSet<EObject>();
        for (EObject eObject : elements) {
            if (added.contains(eObject)) continue;
            Row row = TableFactory.eINSTANCE.createRow();
            row.setElement(eObject);
            table.getRows().add((Object)row);
            added.add(eObject);
        }
        CreateTableUtils.applyDefaultSettings(tableConfig, table);
        CreateTableUtils.createColumns(table);
        CreateTableUtils.createLocalCustoms(table);
        return table;
    }

    private static void createLocalCustoms(Table table) {
        HashSet<Object> alreadyDone = new HashSet<Object>();
        Set<EStructuralFeature> allFeatures = InternalTableUtils.getAllStructuralFeatures(table);
        for (EStructuralFeature structuralFeature : allFeatures) {
            EPackage ePackage;
            EObject sfContainerL1 = structuralFeature.eContainer();
            EObject sfContainerL2 = null;
            if (sfContainerL1 != null) {
                sfContainerL2 = sfContainerL1.eContainer();
            }
            if (!(sfContainerL2 instanceof EPackage) || alreadyDone.contains(ePackage = (EPackage)sfContainerL2) || CustomizationUtils.findCustomizationExtendingEPackage((List<Customization>)table.getLocalCustomizations(), ePackage) != null) continue;
            Customization customizaion = CustomFactory.eINSTANCE.createCustomization();
            table.getLocalCustomizations().add((Object)customizaion);
            alreadyDone.add(ePackage);
        }
        for (FacetSet container : table.getFacetSets()) {
            if (alreadyDone.contains(container) || CustomizationUtils.findCustomizationExtendingEPackage((List<Customization>)table.getLocalCustomizations(), (EPackage)container) != null) continue;
            Customization metamodelView = CustomFactory.eINSTANCE.createCustomization();
            table.getLocalCustomizations().add((Object)metamodelView);
            alreadyDone.add(container);
        }
        table.getCustomizations().addAll(0, (Collection)table.getLocalCustomizations());
    }
}

