/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.RuntimeFactory;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.FacetTestUtils;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedTypedElementResultSerializationTests {
    @Test
    public void testSerializeDerivedTypedElementStringResult() throws Exception {
        this.testSerializePrimitiveTypeResult(EcorePackage.eINSTANCE.getEString(), "testValue");
    }

    @Test
    public void testSerializeDerivedTypedElementIntResult() throws Exception {
        Integer value = 174;
        this.testSerializePrimitiveTypeResult(EcorePackage.eINSTANCE.getEInt(), value);
    }

    @Test
    public void testSerializeDerivedTypedElementBooleanResult() throws Exception {
        Boolean value = Boolean.TRUE;
        this.testSerializePrimitiveTypeResult(EcorePackage.eINSTANCE.getEBoolean(), value);
    }

    @Test
    public void testSerializeDerivedTypedElementDoubleResult() throws Exception {
        Double value = Double.MAX_VALUE;
        this.testSerializePrimitiveTypeResult(EcorePackage.eINSTANCE.getEDouble(), value);
    }

    @Test
    public void testSerializeDerivedTypedElementBigDecimalResult() throws Exception {
        BigInteger value = new BigInteger("1234567890754863418676541567897465153789512379");
        this.testSerializePrimitiveTypeResult(EcorePackage.eINSTANCE.getEBigDecimal(), value);
    }

    private void testSerializePrimitiveTypeResult(EDataType type, Object value) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        FacetAttribute facetAttribute = FacetTestUtils.createSingleValuedFacetAttribute(facet, (EClassifier)type, value);
        ETypedElementPrimitiveTypeResult result = RuntimeFactory.eINSTANCE.createETypedElementPrimitiveTypeResult();
        EClass eObject = EcorePackage.eINSTANCE.getEClass();
        result.setSource((EObject)eObject);
        result.setResult(value);
        result.setDerivedTypedElement((ETypedElement)facetAttribute);
        File testFile = File.createTempFile("testSerialization", ".xmi");
        URI fileURI = URI.createFileURI((String)testFile.getPath());
        ResourceSetImpl resourceSet1 = new ResourceSetImpl();
        Resource resource1 = resourceSet1.createResource(fileURI);
        resource1.getContents().add((Object)result);
        resource1.save(null);
        System.out.println("test primitive type serialization (" + value + ") : " + testFile.getPath());
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        Resource resource2 = resourceSet2.getResource(fileURI, true);
        resource2.load(null);
        EObject result2 = (EObject)resource2.getContents().get(0);
        Assert.assertTrue((boolean)(result2 instanceof ETypedElementPrimitiveTypeResult));
        ETypedElementPrimitiveTypeResult reloadedResult = (ETypedElementPrimitiveTypeResult)result2;
        Assert.assertEquals((Object)value, (Object)reloadedResult.getResult());
    }

    @Test
    public void testSerializeDerivedTypedElementStringListResultOldAPI() throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        values.add("one");
        values.add("two");
        values.add("three");
        this.testSerializePrimitiveTypeListResult(EcorePackage.eINSTANCE.getEString(), values, true);
    }

    @Test
    public void testSerializeDerivedTypedElementStringListResult() throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        values.add("one");
        values.add("two");
        values.add("three");
        this.testSerializePrimitiveTypeListResult(EcorePackage.eINSTANCE.getEString(), values, false);
    }

    @Test
    public void testSerializeDerivedTypedElementIntListResultOldAPI() throws Exception {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(12);
        values.add(153);
        values.add(7);
        this.testSerializePrimitiveTypeListResult(EcorePackage.eINSTANCE.getEInt(), values, true);
    }

    @Test
    public void testSerializeDerivedTypedElementIntListResult() throws Exception {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(12);
        values.add(153);
        values.add(7);
        this.testSerializePrimitiveTypeListResult(EcorePackage.eINSTANCE.getEInt(), values, false);
    }

    private void testSerializePrimitiveTypeListResult(EDataType type, Collection<?> values, boolean testOldAPI) throws Exception, IOException {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        FacetAttribute facetAttribute = FacetTestUtils.createMultiValuedFacetAttribute(facet, (EClassifier)type, values, testOldAPI);
        ETypedElementPrimitiveTypeListResult result = RuntimeFactory.eINSTANCE.createETypedElementPrimitiveTypeListResult();
        EClass eObject = EcorePackage.eINSTANCE.getEClass();
        result.setSource((EObject)eObject);
        result.getResultList().addAll(values);
        result.setDerivedTypedElement((ETypedElement)facetAttribute);
        File testFile = File.createTempFile("testSerialization", ".xmi");
        URI fileURI = URI.createFileURI((String)testFile.getPath());
        ResourceSetImpl resourceSet1 = new ResourceSetImpl();
        Resource resource1 = resourceSet1.createResource(fileURI);
        resource1.getContents().add((Object)result);
        resource1.save(null);
        System.out.println("test primitive type list serialization (" + values + ") : " + testFile.getPath());
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        Resource resource2 = resourceSet2.getResource(fileURI, true);
        resource2.load(null);
        EObject result2 = (EObject)resource2.getContents().get(0);
        Assert.assertTrue((boolean)(result2 instanceof ETypedElementPrimitiveTypeListResult));
        ETypedElementPrimitiveTypeListResult reloadedResult = (ETypedElementPrimitiveTypeListResult)result2;
        Assert.assertEquals(values, (Object)reloadedResult.getResultList());
    }

    @Test
    public void testSerializeDerivedTypedElementEObjectResultOldAPI() throws Exception {
        this.testSerializeDerivedTypedElementEObjectResult(true);
    }

    @Test
    public void testSerializeDerivedTypedElementEObjectResultNewAPI() throws Exception {
        this.testSerializeDerivedTypedElementEObjectResult(false);
    }

    private void testSerializeDerivedTypedElementEObjectResult(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        EClass value = EcorePackage.eINSTANCE.getEParameter();
        FacetReference facetReference = FacetTestUtils.createSingleValuedFacetReference(facet, EcorePackage.eINSTANCE.getEClass(), (EObject)value, testOldAPI);
        ETypedElementEObjectResult result = RuntimeFactory.eINSTANCE.createETypedElementEObjectResult();
        EClass eObject = EcorePackage.eINSTANCE.getEClass();
        result.setSource((EObject)eObject);
        result.setResult((EObject)value);
        result.setDerivedTypedElement((ETypedElement)facetReference);
        File testFile = File.createTempFile("testSerialization", ".xmi");
        URI fileURI = URI.createFileURI((String)testFile.getPath());
        ResourceSetImpl resourceSet1 = new ResourceSetImpl();
        Resource resource1 = resourceSet1.createResource(fileURI);
        resource1.getContents().add((Object)result);
        resource1.save(null);
        System.out.println("testSerializeDerivedTypedElementEObjectResult: " + testFile.getPath());
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        Resource resource2 = resourceSet2.getResource(fileURI, true);
        resource2.load(null);
        EObject result2 = (EObject)resource2.getContents().get(0);
        Assert.assertTrue((boolean)(result2 instanceof ETypedElementEObjectResult));
        ETypedElementEObjectResult reloadedResult = (ETypedElementEObjectResult)result2;
        Assert.assertEquals((Object)value, (Object)reloadedResult.getResult());
    }

    @Test
    public void testSerializeDerivedTypedElementEObjectListResultOldAPI() throws Exception {
        this.testSerializeDerivedTypedElementEObjectListResult(true);
    }

    @Test
    public void testSerializeDerivedTypedElementEObjectListResultNewAPI() throws Exception {
        this.testSerializeDerivedTypedElementEObjectListResult(false);
    }

    private void testSerializeDerivedTypedElementEObjectListResult(boolean testOldAPI) throws Exception {
        Facet facet = FacetTestUtils.createFacet("testFacet");
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(EcorePackage.eINSTANCE.getEParameter());
        values.add(EcorePackage.eINSTANCE.getEInt());
        values.add(EcorePackage.eINSTANCE.getEClass__GetOperationCount());
        FacetReference facetReference = FacetTestUtils.createMultiValuedFacetReference(facet, EcorePackage.eINSTANCE.getEClass(), values, testOldAPI);
        ETypedElementEObjectListResult result = RuntimeFactory.eINSTANCE.createETypedElementEObjectListResult();
        EClass eObject = EcorePackage.eINSTANCE.getEClass();
        result.setSource((EObject)eObject);
        result.getResultList().addAll(values);
        result.setDerivedTypedElement((ETypedElement)facetReference);
        File testFile = File.createTempFile("testSerialization", ".xmi");
        URI fileURI = URI.createFileURI((String)testFile.getPath());
        ResourceSetImpl resourceSet1 = new ResourceSetImpl();
        Resource resource1 = resourceSet1.createResource(fileURI);
        resource1.getContents().add((Object)result);
        resource1.save(null);
        System.out.println("testSerializeDerivedTypedElementEObjectListResult: " + testFile.getPath());
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        Resource resource2 = resourceSet2.getResource(fileURI, true);
        resource2.load(null);
        EObject result2 = (EObject)resource2.getContents().get(0);
        Assert.assertTrue((boolean)(result2 instanceof ETypedElementEObjectListResult));
        ETypedElementEObjectListResult reloadedResult = (ETypedElementEObjectListResult)result2;
        Assert.assertEquals(values, (Object)reloadedResult.getResultList());
    }
}

