/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialogInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IMustRemoveNonConformingElementsDialog;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.TableEditorConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class CanBePresentedInTheTableDialogTest {
    private static final String QUERY_WHICH_RETURNS_E_BOOLEAN_OBJECT = "queryWhichReturnsEBooleanObject";
    private static final String QUERY_WHICH_RETURNS_ECORE_BOOLEAN = "queryWhichReturnsEcoreBoolean";
    private static final String QUERY_WHICH_RETURNS_UML_BOOLEAN = "queryWhichReturnsUmlBoolean";
    private static final String FACET_NAME = "presentabilityQueries";
    private static final String NON_APPLICABLE_QUERY = "nonApplicableQuery";
    private static final String REJECTING_QUERY = "isEClassifier";
    private static final String NOT_REJECTING_QUERY = "isNamedElement";
    private static final String RESOURCES = "/resources/v0_2/Bug367335/";
    private static final String BUG_ID = "Bug367335";
    private static final String TABLE_FILENAME = "presentabilityTest.table";
    private static final String PROJECT_NAME = CanBePresentedInTheTableDialogTest.class.getSimpleName();
    private ITableWidget tableWidget;
    private ResourceSet resourceSet = new ResourceSetImpl();
    private static IProject project;

    @BeforeClass
    public static void initResource() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            project2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        project = workspace.getRoot().getProject(PROJECT_NAME);
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/Bug367335/presentabilityTest.table", (IProject)project, (String)"/presentabilityTest.table", (Bundle)bundle);
    }

    @Test
    public void notRejectingQuery() throws Exception {
        this.tableWidget = this.init();
        int initNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        IAllowedContentsETypedElementSelectionDialogInternal dialog1 = (IAllowedContentsETypedElementSelectionDialogInternal)this.tableWidget.openCanBePresentedInTheTableDialog();
        Assert.assertEquals((String)"The selected query in the dialog must be the current canBePresentedQuery of the table widget", (Object)this.tableWidget.getCanBePresentedInTheTable(), (Object)dialog1.getSelectedETypedElement());
        ETypedElement newQuery = this.getNotRejectingQuery();
        dialog1.select(newQuery);
        IMustRemoveNonConformingElementsDialog dialog2 = dialog1.pressOk();
        Assert.assertNull((String)"The IMustRemoveNonConformingElementsDialog dialog must not be opened.", (Object)dialog2);
        int currentNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        Assert.assertTrue((String)"The number of elements in the table must not change.", (initNbElement == currentNbElement ? 1 : 0) != 0);
        Assert.assertEquals((String)"The query must now be the new presentability query", (Object)newQuery, (Object)this.tableWidget.getCanBePresentedInTheTable());
    }

    @Test
    public void rejectingQueryAndRemoveElements() throws Exception {
        this.tableWidget = this.init();
        int initNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        this.rejectingQueryAndRemoveElements(true);
        int currentNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        Assert.assertTrue((String)"The number of elements in the table must have decreased.", (initNbElement > currentNbElement ? 1 : 0) != 0);
    }

    @Test
    public void rejectingQueryAndNotRemoveElements() throws Exception {
        this.tableWidget = this.init();
        int initNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        this.rejectingQueryAndRemoveElements(false);
        int currentNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        Assert.assertTrue((String)"The number of elements in the table must not change.", (initNbElement == currentNbElement ? 1 : 0) != 0);
    }

    private void rejectingQueryAndRemoveElements(boolean removeRejectedElements) {
        IAllowedContentsETypedElementSelectionDialogInternal dialog1 = (IAllowedContentsETypedElementSelectionDialogInternal)this.tableWidget.openCanBePresentedInTheTableDialog();
        Assert.assertEquals((String)"The selected query in the dialog must be the current canBePresentedQuery of the table widget", (Object)this.tableWidget.getCanBePresentedInTheTable(), (Object)dialog1.getSelectedETypedElement());
        ETypedElement newQuery = this.getRejectingQuery();
        dialog1.select(newQuery);
        IMustRemoveNonConformingElementsDialog dialog2 = dialog1.pressOk();
        Assert.assertNotNull((String)"The IMustRemoveNonConformingElementsDialog dialog must be opened.", (Object)dialog2);
        if (removeRejectedElements) {
            dialog2.pressYes();
            Assert.assertTrue((boolean)dialog2.getMustRemoveNonConformingElements());
        } else {
            dialog2.pressNo();
            Assert.assertFalse((boolean)dialog2.getMustRemoveNonConformingElements());
        }
        Assert.assertEquals((String)"The query must now be the new presentability query", (Object)newQuery, (Object)this.tableWidget.getCanBePresentedInTheTable());
    }

    @Test
    public void testInitialSelection() throws Exception {
        this.tableWidget = this.init();
        ETypedElement query = this.getNotRejectingQuery();
        this.tableWidget.setCanBePresentedInTheTable(query, false);
        IAllowedContentsETypedElementSelectionDialogInternal dialog1 = (IAllowedContentsETypedElementSelectionDialogInternal)this.tableWidget.openCanBePresentedInTheTableDialog();
        ETypedElement selectedQuery = dialog1.getSelectedETypedElement();
        Assert.assertEquals((String)"The selected query in the dialog must be the current presentability query of the table widget", (Object)query, (Object)selectedQuery);
        dialog1.pressCancel();
    }

    @Test
    public void testCancel() throws Exception {
        this.tableWidget = this.init();
        ETypedElement queryBefore = this.getRejectingQuery();
        this.tableWidget.setCanBePresentedInTheTable(queryBefore, false);
        ETypedElement query = this.getNotRejectingQuery();
        IAllowedContentsETypedElementSelectionDialogInternal dialog1 = (IAllowedContentsETypedElementSelectionDialogInternal)this.tableWidget.openCanBePresentedInTheTableDialog();
        dialog1.select(query);
        dialog1.pressCancel();
        Assert.assertEquals((String)"The query must not be changed after cancelling the dialog", (Object)queryBefore, (Object)this.tableWidget.getCanBePresentedInTheTable());
    }

    @Test
    public void testSetAndGetPresentabilityQuery() throws Exception {
        this.tableWidget = this.init();
        ETypedElement query = this.getNotRejectingQuery();
        this.tableWidget.setCanBePresentedInTheTable(query, false);
        ETypedElement query2 = this.tableWidget.getCanBePresentedInTheTable();
        Assert.assertEquals((String)"The query was not set", (Object)query, (Object)query2);
    }

    @Test
    @Ignore
    public void testGetApplicableCanBePresentedQueries() throws Exception {
        this.tableWidget = this.init();
        List queries = this.tableWidget.getApplicableCanBePresentedQueries();
        Assert.assertNotNull((Object)queries);
        Assert.assertTrue((boolean)queries.contains(this.getRejectingQuery()));
        Assert.assertTrue((boolean)queries.contains(this.getNotRejectingQuery()));
        Assert.assertFalse((boolean)queries.contains(this.getNonApplicableQuery()));
        Assert.assertTrue((boolean)queries.contains(this.getQueryWhichReturnsEcoreBoolean()));
        Assert.assertTrue((boolean)queries.contains(this.getQueryWhichReturnsEBooleanObject()));
        Assert.assertTrue((boolean)queries.contains(this.getQueryWhichReturnsUMLBoolean()));
    }

    @Test
    public void testUndoRedo() throws Exception {
        this.tableWidget = this.init();
        ETypedElement query = this.getNotRejectingQuery();
        this.tableWidget.setCanBePresentedInTheTable(query, false);
        Assert.assertEquals((String)"Query must be set", (Object)query, (Object)this.tableWidget.getCanBePresentedInTheTable());
        ((ITableWidgetInternal)this.tableWidget).undo();
        Assert.assertNull((String)"Query must be unset after undo", (Object)this.tableWidget.getCanBePresentedInTheTable());
        ((ITableWidgetInternal)this.tableWidget).redo();
        Assert.assertEquals((String)"Query must be set after redo", (Object)query, (Object)this.tableWidget.getCanBePresentedInTheTable());
    }

    @Test
    public void testUndoRedoWithTwoQueries() throws Exception {
        this.tableWidget = this.init();
        ETypedElement query1 = this.getRejectingQuery();
        ETypedElement query2 = this.getNotRejectingQuery();
        this.tableWidget.setCanBePresentedInTheTable(query1, false);
        this.tableWidget.setCanBePresentedInTheTable(query2, false);
        Assert.assertEquals((String)"Query 2 must be set", (Object)query2, (Object)this.tableWidget.getCanBePresentedInTheTable());
        ((ITableWidgetInternal)this.tableWidget).undo();
        Assert.assertEquals((String)"Query 1 must be set after undo", (Object)query1, (Object)this.tableWidget.getCanBePresentedInTheTable());
        ((ITableWidgetInternal)this.tableWidget).redo();
        Assert.assertEquals((String)"Query 2 must be set after redo", (Object)query2, (Object)this.tableWidget.getCanBePresentedInTheTable());
    }

    private void testSetQuery(ETypedElementProvider typedElementProvider) throws Exception {
        this.tableWidget = this.init();
        int initNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        IAllowedContentsETypedElementSelectionDialogInternal dialog1 = (IAllowedContentsETypedElementSelectionDialogInternal)this.tableWidget.openCanBePresentedInTheTableDialog();
        ETypedElement eTypedElement = typedElementProvider.getETypedElement();
        dialog1.select(eTypedElement);
        IMustRemoveNonConformingElementsDialog dialog2 = dialog1.pressOk();
        Assert.assertNull((String)"The IMustRemoveNonConformingElementsDialog dialog must not be opened.", (Object)dialog2);
        int currentNbElement = TableWidgetUtils.getElements((Table)this.tableWidget.getTable()).size();
        Assert.assertTrue((String)"The number of elements in the table must not change.", (initNbElement == currentNbElement ? 1 : 0) != 0);
        Assert.assertEquals((String)"The query must now be the new presentability query", (Object)eTypedElement, (Object)this.tableWidget.getCanBePresentedInTheTable());
    }

    @Test
    public void testQueryWhichReturnsEcoreBoolean() throws Exception {
        this.testSetQuery(new ETypedElementProvider(){

            public ETypedElement getETypedElement() {
                return CanBePresentedInTheTableDialogTest.this.getQueryWhichReturnsEcoreBoolean();
            }
        });
    }

    @Test
    public void testQueryWhichReturnsEBooleanObject() throws Exception {
        this.testSetQuery(new ETypedElementProvider(){

            public ETypedElement getETypedElement() {
                return CanBePresentedInTheTableDialogTest.this.getQueryWhichReturnsEBooleanObject();
            }
        });
    }

    @Test
    @Ignore
    public void testQueryWhichReturnsUMLBoolean() throws Exception {
        this.testSetQuery(new ETypedElementProvider(){

            public ETypedElement getETypedElement() {
                return CanBePresentedInTheTableDialogTest.this.getQueryWhichReturnsUMLBoolean();
            }
        });
    }

    private ITableWidget init() throws Exception {
        final IFile tableFile = project.getFile(TABLE_FILENAME);
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    editor[0] = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)tableFile, (String)TableEditorConstants.getEditorID());
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ITableWidgetProvider tableWidgetProvider = (ITableWidgetProvider)editor[0].getAdapter(ITableWidgetProvider.class);
        Assert.assertNotNull((Object)tableWidgetProvider);
        return tableWidgetProvider.getTableWidget();
    }

    private ETypedElement getNotRejectingQuery() {
        return this.getETypedElement(NOT_REJECTING_QUERY);
    }

    private ETypedElement getRejectingQuery() {
        return this.getETypedElement(REJECTING_QUERY);
    }

    private ETypedElement getNonApplicableQuery() {
        return this.getETypedElement(NON_APPLICABLE_QUERY);
    }

    private ETypedElement getETypedElement(String name) {
        ETypedElement result = null;
        IFacetSetCatalogManager facetSetCatalogManager = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.tableWidget.getTable().eResource().getResourceSet());
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)facetSetCatalogManager.getRegisteredFacetSets(), (String)FACET_NAME);
        Facet facet = FacetUtils.getFacet((Collection)FacetUtils.getFacets((FacetSet)facetSet), (String)FACET_NAME);
        if (facet != null) {
            result = FacetUtils.getETypedElement((Facet)facet, (String)name, EAttribute.class);
        }
        Assert.assertNotNull((String)(String.valueOf(name) + " must not be null"), (Object)result);
        return result;
    }

    protected ETypedElement getQueryWhichReturnsUMLBoolean() {
        return this.getETypedElement(QUERY_WHICH_RETURNS_UML_BOOLEAN);
    }

    protected ETypedElement getQueryWhichReturnsEcoreBoolean() {
        return this.getETypedElement(QUERY_WHICH_RETURNS_ECORE_BOOLEAN);
    }

    protected ETypedElement getQueryWhichReturnsEBooleanObject() {
        return this.getETypedElement(QUERY_WHICH_RETURNS_E_BOOLEAN_OBJECT);
    }

    @Before
    public void before() {
        CanBePresentedInTheTableDialogTest.closeEditorsAndViews();
    }

    @After
    public void after() {
        CanBePresentedInTheTableDialogTest.closeEditorsAndViews();
    }

    private static void closeEditorsAndViews() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IViewReference[] viewReferences;
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = activePage.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewReference = iViewReferenceArray[n2];
                    activePage.hideView(viewReference);
                    ++n2;
                }
            }
        });
    }

    static interface ETypedElementProvider {
        public ETypedElement getETypedElement();
    }
}

