/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.workbench.internal.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.view.TableView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewInTableHandler
extends AbstractHandler {
    private static final String DESCRIPTION = "";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection;
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            EditingDomain editingDomain = null;
            if (editor instanceof IEditingDomainProvider) {
                IEditingDomainProvider edProvider = (IEditingDomainProvider)editor;
                editingDomain = edProvider.getEditingDomain();
            }
            if (!((selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection()) instanceof IStructuredSelection)) {
                throw new Exception("Unexpected selection");
            }
            List<EObject> eObjects = ViewInTableHandler.getEObjects((IStructuredSelection)selection);
            TableView.openOn(eObjects, editingDomain, DESCRIPTION, null, null, null);
        }
        catch (Exception e) {
            MessageDialog.openWarning(null, (String)Messages.ViewInTableHandler_0, (String)Messages.ViewInTableHandler_1);
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return null;
    }

    private static List<EObject> getEObjects(IStructuredSelection selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object selectedElement : selection) {
            if (selectedElement instanceof EObject) {
                EObject eObject = (EObject)selectedElement;
                result.add(eObject);
                continue;
            }
            Logger.logWarning((String)"Cannot open table editor: selected objects are not all model elements", (Plugin)Activator.getDefault());
        }
        return result;
    }
}

