/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogFactory;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogInternal;
import org.eclipse.emf.facet.util.swt.internal.exported.SWTTestUtils;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetSetSelectionDialogTests {
    private static final String HIERARCHICAL_FACET_SET = "Bug372865_hierarchical";
    private static final String HIERARCHICAL_FACET_SET_1 = "Bug372865_hierarchical_1";
    private static final String HIERARCHICAL_FACET_SET_1_1 = "Bug372865_hierarchical_1_1";
    private static final String HIERARCHICAL_FACET_SET_1_2 = "Bug372865_hierarchical_1_2";
    private static final String HIERARCHICAL_FACET_SET_2 = "Bug372865_hierarchical_2";
    private static final String FACET_SET_NAME = "Bug372865";
    private static Collection<FacetSet> registeredFacetSets;
    private static FacetSet facetSet;
    private static FacetSet hierarchicalFacetSet;
    private static FacetSet hierarchicalFacetSet1;
    private static FacetSet hierarchicalFacetSet11;
    private static FacetSet hierarchicalFacetSet12;
    private static FacetSet hierarchicalFacetSet2;

    public static FacetSet getFacetSet() {
        return facetSet;
    }

    @BeforeClass
    public static void init() {
        registeredFacetSets = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl()).getRegisteredFacetSets();
        facetSet = FacetUtils.getFacetSet(registeredFacetSets, (String)FACET_SET_NAME);
        Assert.assertNotNull((String)"The facetSet Bug372865 must be found", (Object)facetSet);
        hierarchicalFacetSet = FacetUtils.getFacetSet(registeredFacetSets, (String)HIERARCHICAL_FACET_SET);
        Assert.assertNotNull((String)"The facetSet Bug372865_hierarchical must be found", (Object)hierarchicalFacetSet);
        hierarchicalFacetSet1 = FacetSetSelectionDialogTests.getSubFacetSet(hierarchicalFacetSet, HIERARCHICAL_FACET_SET_1);
        Assert.assertNotNull((String)"The facetSet Bug372865_hierarchical_1 must be found", (Object)hierarchicalFacetSet1);
        hierarchicalFacetSet11 = FacetSetSelectionDialogTests.getSubFacetSet(hierarchicalFacetSet1, HIERARCHICAL_FACET_SET_1_1);
        Assert.assertNotNull((String)"The facetSet Bug372865_hierarchical_1_1 must be found", (Object)hierarchicalFacetSet11);
        hierarchicalFacetSet12 = FacetSetSelectionDialogTests.getSubFacetSet(hierarchicalFacetSet1, HIERARCHICAL_FACET_SET_1_2);
        Assert.assertNotNull((String)"The facetSet Bug372865_hierarchical_1_2 must be found", (Object)hierarchicalFacetSet12);
        hierarchicalFacetSet2 = FacetSetSelectionDialogTests.getSubFacetSet(hierarchicalFacetSet, HIERARCHICAL_FACET_SET_2);
        Assert.assertNotNull((String)"The facetSet Bug372865_hierarchical_2 must be found", (Object)hierarchicalFacetSet2);
    }

    private static FacetSet getSubFacetSet(FacetSet parentFacetSet, String name) {
        FacetSet result = null;
        EList eSubpackages = parentFacetSet.getESubpackages();
        for (EPackage ePackage : eSubpackages) {
            FacetSet subFacetSet;
            if (!(ePackage instanceof FacetSet) || !name.equals((subFacetSet = (FacetSet)ePackage).getName())) continue;
            result = subFacetSet;
            break;
        }
        return result;
    }

    private static int selectionMaxSize(boolean multiSelection) {
        int result = multiSelection ? Integer.MAX_VALUE : 1;
        return result;
    }

    private static IFacetSetSelectionDialogInternal<?> openDialog(boolean multiSelection, boolean allowEmptySelection, IDialogCallback<List<FacetSet>> callback) {
        IFacetSetSelectionDialogInternal dialog = (IFacetSetSelectionDialogInternal)IFacetSetSelectionDialogFactory.DEFAULT.openFacetSetSelectionDialog(registeredFacetSets, FacetSetSelectionDialogTests.selectionMaxSize(multiSelection), allowEmptySelection, callback, null);
        return dialog;
    }

    private void testDialogSelection(final List<FacetSet> facetSetsToSelect) throws Exception {
        final boolean[] okPressed = new boolean[1];
        IFacetSetSelectionDialogInternal<?> dialog = FacetSetSelectionDialogTests.openDialog(true, true, new IDialogCallback<List<FacetSet>>(){

            public void committed(List<FacetSet> selection) {
                Assert.assertEquals((String)"Only the FacetSets that were selected must be in the selection", (long)facetSetsToSelect.size(), (long)selection.size());
                for (FacetSet facetSetToSelect : facetSetsToSelect) {
                    Assert.assertTrue((String)"The FacetSets that were selected must be in the selection", (boolean)selection.contains(facetSetToSelect));
                }
                okPressed[0] = true;
            }
        });
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(facetSetsToSelect);
        dialog.pressOk();
        Assert.assertTrue((String)"The dialog callback must be called when pressing Ok", (boolean)okPressed[0]);
    }

    @Test
    public void testDialogSelection() throws Exception {
        this.testDialogSelection(Collections.singletonList(FacetSetSelectionDialogTests.getFacetSet()));
    }

    @Test
    public void testCancelDialog() throws Exception {
        IFacetSetSelectionDialogInternal<?> dialog = FacetSetSelectionDialogTests.openDialog(true, true, new IDialogCallback<List<FacetSet>>(){

            public void committed(List<FacetSet> selection) {
                Assert.fail((String)"The dialog callback must not be called when pressing Cancel");
            }
        });
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogTests.getFacetSet()));
        dialog.pressCancel();
    }

    private IFacetSetSelectionDialogInternal<TestPrecommitDialog> openDialogWithPrecommitCallback(boolean multiSelection, boolean allowEmptySelection, IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog> callback) {
        IFacetSetSelectionDialogInternal dialog = (IFacetSetSelectionDialogInternal)IFacetSetSelectionDialogFactory.DEFAULT.openFacetSetSelectionDialog(registeredFacetSets, FacetSetSelectionDialogTests.selectionMaxSize(multiSelection), allowEmptySelection, callback, null);
        return dialog;
    }

    @Test
    public void testDialogSelectionWithPrecommitCallback() throws Exception {
        final boolean[] okPressed = new boolean[1];
        IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog> dialogCallbackWithPreCommit = new IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog>(){

            public void committed(List<FacetSet> selection, Boolean precommitResult) {
                Assert.assertEquals((String)"Only the FacetSet that was selected must be in the selection", (long)1L, (long)selection.size());
                Assert.assertEquals((String)"The FacetSet that was selected must be in the selection", (Object)FacetSetSelectionDialogTests.getFacetSet(), (Object)selection.get(0));
                okPressed[0] = true;
            }

            public TestPrecommitDialog openPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
                return new TestPrecommitDialog(precommitCallback);
            }
        };
        IFacetSetSelectionDialogInternal<TestPrecommitDialog> dialog = this.openDialogWithPrecommitCallback(true, false, dialogCallbackWithPreCommit);
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogTests.getFacetSet()));
        TestPrecommitDialog precommitDialog = (TestPrecommitDialog)dialog.pressOk();
        Assert.assertNotNull((String)"the precommit dialog must not be null", (Object)precommitDialog);
        precommitDialog.pressOk();
        Assert.assertTrue((String)"The dialog callback must be called when pressing Ok", (boolean)okPressed[0]);
    }

    @Test
    public void testCancelDialogWithPrecommitCallback() throws Exception {
        IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog> dialogCallbackWithPreCommit = new IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog>(){

            public void committed(List<FacetSet> selection, Boolean precommitResult) {
                Assert.fail((String)"The dialog callback must not be called when pressing Cancel");
            }

            public TestPrecommitDialog openPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
                Assert.fail((String)"The precommit dialog must not be opened when pressing Cancel");
                return null;
            }
        };
        IFacetSetSelectionDialogInternal<TestPrecommitDialog> dialog = this.openDialogWithPrecommitCallback(true, false, dialogCallbackWithPreCommit);
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogTests.getFacetSet()));
        dialog.pressCancel();
    }

    @Test
    public void testCancelPrecommitDialogWithPrecommitCallback() throws Exception {
        IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog> dialogCallbackWithPreCommit = new IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog>(){

            public void committed(List<FacetSet> selection, Boolean precommitResult) {
                Assert.fail((String)"The dialog callback must not be called when pressing Cancel");
            }

            public TestPrecommitDialog openPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
                return new TestPrecommitDialog(precommitCallback);
            }
        };
        IFacetSetSelectionDialogInternal<TestPrecommitDialog> dialog = this.openDialogWithPrecommitCallback(true, false, dialogCallbackWithPreCommit);
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogTests.getFacetSet()));
        TestPrecommitDialog precommitDialog = (TestPrecommitDialog)dialog.pressOk();
        Assert.assertNotNull((String)"the precommit dialog must not be null", (Object)precommitDialog);
        precommitDialog.pressCancel();
    }

    @Test
    public void testHierarchicalFacetSets() throws Exception {
        final IFacetSetSelectionDialogInternal<?> dialog = FacetSetSelectionDialogTests.openDialog(true, true, new IDialogCallback<List<FacetSet>>(){

            public void committed(List<FacetSet> selection) {
                Assert.fail((String)"shouldn't be called when cancelled");
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.getTreeViewer().expandAll();
                TreeItem[] items = dialog.getTreeViewer().getTree().getItems();
                TreeItem rootFacetSet = SWTTestUtils.findTreeItem((String)FacetSetSelectionDialogTests.HIERARCHICAL_FACET_SET, (TreeItem[])items);
                Assert.assertNotNull((String)"The root FacetSet must appear", (Object)rootFacetSet);
                TreeItem facetSet1 = SWTTestUtils.findTreeItem((String)FacetSetSelectionDialogTests.HIERARCHICAL_FACET_SET_1, (TreeItem[])rootFacetSet.getItems());
                Assert.assertNotNull((String)"Bug372865_hierarchical_1 must appear", (Object)facetSet1);
                Assert.assertNotNull((String)"Bug372865_hierarchical_1_1 must appear", (Object)SWTTestUtils.findTreeItem((String)FacetSetSelectionDialogTests.HIERARCHICAL_FACET_SET_1_1, (TreeItem[])facetSet1.getItems()));
                Assert.assertNotNull((String)"Bug372865_hierarchical_1_2 must appear", (Object)SWTTestUtils.findTreeItem((String)FacetSetSelectionDialogTests.HIERARCHICAL_FACET_SET_1_2, (TreeItem[])facetSet1.getItems()));
                Assert.assertNotNull((String)"Bug372865_hierarchical_2 must appear", (Object)SWTTestUtils.findTreeItem((String)FacetSetSelectionDialogTests.HIERARCHICAL_FACET_SET_2, (TreeItem[])rootFacetSet.getItems()));
            }
        });
        dialog.pressCancel();
    }

    @Test
    public void testSelectHierarchicalFacetSet() throws Exception {
        this.testDialogSelection(Collections.singletonList(hierarchicalFacetSet));
    }

    @Test
    public void testSelectHierarchicalFacetSet1() throws Exception {
        this.testDialogSelection(Collections.singletonList(hierarchicalFacetSet1));
    }

    @Test
    public void testSelectHierarchicalFacetSet11() throws Exception {
        this.testDialogSelection(Collections.singletonList(hierarchicalFacetSet11));
    }

    @Test
    public void testSelectHierarchicalFacetSet12() throws Exception {
        this.testDialogSelection(Collections.singletonList(hierarchicalFacetSet12));
    }

    @Test
    public void testSelectHierarchicalFacetSet2() throws Exception {
        this.testDialogSelection(Collections.singletonList(hierarchicalFacetSet2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestPrecommitDialog {
        private final IDialogCallback<Boolean> precommitCallback;

        public TestPrecommitDialog(IDialogCallback<Boolean> precommitCallback) {
            this.precommitCallback = precommitCallback;
        }

        public void pressOk() {
            this.precommitCallback.committed((Object)Boolean.TRUE);
        }

        public void pressCancel() {
        }
    }
}

