/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.efacet.ocl.core.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.efacet.ocl.core.internal.Activator;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationHaltedException;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFacetOCLEvaluationEnvironment
extends EcoreEvaluationEnvironment {
    public EFacetOCLEvaluationEnvironment() {
    }

    public EFacetOCLEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        super(parent);
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) {
        Object result = null;
        if (property.getEAnnotation("EFacetOCLEnvironment") == null) {
            result = super.navigateProperty(property, qualifiers, target);
        } else if (target instanceof EObject) {
            EObject eObject = (EObject)target;
            String referenceName = property.getName();
            result = EFacetOCLEvaluationEnvironment.getFacetReferences(eObject, referenceName);
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static Object getFacetReferences(EObject eObject, String referenceName) {
        Object result = null;
        Resource eResource = eObject.eResource();
        ResourceSet resourceSet = eResource.getResourceSet();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(resourceSet);
        ETypedElement query = null;
        List managedFacetSets = facetManager.getManagedFacetSets();
        Iterator facetSetIter = managedFacetSets.iterator();
        while (query == null && facetSetIter.hasNext()) {
            FacetSet facetSet = (FacetSet)facetSetIter.next();
            EList eClassifiers = facetSet.getEClassifiers();
            Iterator facetIter = eClassifiers.iterator();
            while (query == null && facetIter.hasNext()) {
                EClassifier classifier = (EClassifier)facetIter.next();
                if (!(classifier instanceof Facet)) continue;
                Facet facet = (Facet)classifier;
                query = EFacetOCLEvaluationEnvironment.getTypedElement(facetManager, facet, eObject, referenceName);
            }
        }
        try {
            result = facetManager.getOrInvoke(eObject, query, Object.class);
        }
        catch (FacetManagerException e) {
            throw new EvaluationHaltedException("FacetManager is not loaded:", (Throwable)e);
        }
        return result;
    }

    private static ETypedElement getTypedElement(IFacetManager facetManager, Facet facet, EObject eObject, String referenceName) {
        ETypedElement query;
        block3: {
            query = null;
            try {
                if (!facetManager.isConforming(eObject, facet)) break block3;
                for (ETypedElement etypeElt : facet.getFacetElements()) {
                    if (!etypeElt.getName().equals(referenceName)) continue;
                    query = etypeElt;
                    break;
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((String)e.getMessage(), (Plugin)Activator.getDefault());
            }
        }
        return query;
    }
}

