/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.ui.internal.exported.handler;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.ui.internal.Activator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class HandlerUtils {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());

    private HandlerUtils() {
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        final IWorkbenchWindow[] result = new IWorkbenchWindow[1];
        Runnable runnable = new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                DebugUtils.debug((boolean)DEBUG, (String)("PlatformUI.getWorkbench()==" + workbench));
                if (workbench != null) {
                    IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
                    DebugUtils.debug((boolean)DEBUG, (String)("PlatformUI.getWorkbench().getWorkbenchWindows().length==" + workbenchWindows.length));
                    if (workbenchWindows.length > 0 && workbenchWindows[0].getSelectionService() != null) {
                        result[0] = workbenchWindows[0];
                    }
                }
            }
        };
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
        return result[0];
    }

    public static IStructuredSelection getStructuredSelection() {
        ISelection selection;
        IStructuredSelection result = null;
        IWorkbenchWindow workbenchWindow = HandlerUtils.getWorkbenchWindow();
        if (workbenchWindow != null && (selection = workbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            result = (IStructuredSelection)selection;
        }
        return result;
    }

    public static Object getSelection() {
        Object result = null;
        IStructuredSelection structSelection = HandlerUtils.getStructuredSelection();
        if (structSelection != null) {
            result = structSelection.getFirstElement();
        }
        return result;
    }

    public static Shell getWorkbenchWindowShell() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getPages()[0];
        IWorkbenchPart activePart = iWorkbenchPage.getActivePart();
        IWorkbenchPartSite site = activePart.getSite();
        return site.getShell();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window;
        IWorkbenchPage activePage = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            activePage = window.getActivePage();
        }
        return activePage;
    }

    public static IWorkbenchPart getActivePart() {
        IWorkbenchPart activePart = null;
        IWorkbenchPage activePage = HandlerUtils.getActivePage();
        if (activePage != null) {
            activePart = activePage.getActivePart();
        }
        return activePart;
    }
}

