/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Bros (Mia-Software) - Bug 331675 - NatTable : copy cells as text - initial API and implementation
 *   Gregoire Dupe (Mia-Software) - Bug 366804 - [Restructuring] Table widget upgrade
 *   Gregoire Dupe (Mia-Software) - Bug 367613 - Table widget refactoring
 *   Gregoire Dupe (Mia-Software) - Bug 373078 - API Cleaning
 *   Nicolas Bros (Mia-Software) - Bug 377614 - [Table] getSelection should return all the elements underlying the selected cells
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.handler;

import net.sourceforge.nattable.copy.command.CopyDataCommandHandler;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;

import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyToClipboardCommandHandler extends CopyDataCommandHandler {

	private static final String NEWLINE = System.getProperty("line.separator"); //$NON-NLS-1$
	private final NatTableWidget natTableWidget;

	public CopyToClipboardCommandHandler(final SelectionLayer selectionLayer,
			final NatTableWidget natTableWidget) {
		super(selectionLayer);
		this.natTableWidget = natTableWidget;
	}

	@Override
	public boolean doCommand(final CopyDataToClipboardCommand command) {
		LayerCell[][] copiedCells = assembleCopiedDataStructure();
		serializeToClipboard(command, copiedCells);
		return true;
	}

	public void serializeToClipboard(final CopyDataToClipboardCommand command,
			final LayerCell[][] copiedCells) {
		final Clipboard clipboard = command.getClipboard();
		final String cellDelimeter = command.getCellDelimeter();
		final String rowDelimeter = CopyToClipboardCommandHandler.NEWLINE;

		final TextTransfer textTransfer = TextTransfer.getInstance();
		final StringBuilder textData = new StringBuilder();
		int currentRow = 0;
		ICustomizedLabelProvider tableLabelProvider = this.natTableWidget
				.getController().getTableLabelProvider();
		String[] columnNames = this.natTableWidget.getColumnNames();
		for (LayerCell[] cells : copiedCells) {
			// first, a line with column names
			if (currentRow == 0) {
				boolean first = true;
				for (LayerCell cell : cells) {
					if (first) {
						first = false;
					} else {
						textData.append(cellDelimeter);
					}
					int originColumnPosition = cell.getOriginColumnPosition();
					int converted = this.natTableWidget
							.convertColumnPositionSelectionToData(originColumnPosition);
					textData.append(columnNames[converted]);
				}
				textData.append(rowDelimeter);
			}

			boolean first = true;
			for (LayerCell cell : cells) {
				if (first) {
					first = false;
				} else {
					textData.append(cellDelimeter);
				}
				if (cell != null) {
					Object dataValue = cell.getDataValue();
					if (dataValue instanceof IGridElement) {
						IGridElement gridElement = (IGridElement) dataValue;
						int originColumnPosition = cell.getOriginColumnPosition();
						String text = tableLabelProvider.getText(gridElement
								.getElement(), ((FeatureColumn) gridElement
								.getColumn()).getFeature());
						textData.append(text);
					}
				}
			}
			if (++currentRow < copiedCells.length) {
				textData.append(rowDelimeter);
			}
		}
		String string = textData.toString();
		if (string.length() > 0) {
			clipboard.setContents(new Object[] { textData.toString() },
					new Transfer[] { textTransfer });
		}
	}
}
