/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.aggregate.tests.internal;

import org.eclipse.emf.facet.common.ui.internal.views.ElementsView;
import org.eclipse.emf.facet.efacet.ui.internal.exported.EFacetUIConstants;
import org.eclipse.emf.facet.util.swt.internal.exported.SWTTestUtils;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class FacetSetsCatalogViewTests {
    private static final String AGGREGATE_NAME = "Bug372626_Aggregates_aggregate";
    private static final String FACET_SET_NAME = "Bug372626_Aggregates_facetSet";
    private static final String CUSTOM_NAME = "Bug372626_Aggregates_custom";
    private ElementsView elementsView;

    protected void setElementsView(ElementsView elementsView) {
        this.elementsView = elementsView;
    }

    public ElementsView getElementsView() {
        return this.elementsView;
    }

    private void openView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    FacetSetsCatalogViewTests.this.setElementsView((ElementsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(EFacetUIConstants.getFacetSetsCatalogViewId()));
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testCustomizationsView() throws Exception {
        TestUtils.closeWelcomePage();
        this.openView();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                FacetSetsCatalogViewTests.this.testView();
            }
        });
    }

    protected void testView() {
        if (!"win32".equals(System.getProperty("osgi.os"))) {
            TreeViewer treeViewer = this.getElementsView().getViewer();
            treeViewer.expandAll();
            Tree tree = treeViewer.getTree();
            TreeItem aggregate = SWTTestUtils.findRootTreeItem((String)AGGREGATE_NAME, (Tree)tree);
            SWTBotUtils.captureScreenShot((String)"Facet sets catalog view with aggregates");
            String message = "The aggregate must be in the view, only the following items are available : " + SWTTestUtils.itemsStr((TreeItem[])tree.getItems());
            Assert.assertNotNull((String)message, (Object)aggregate);
            Assert.assertNotNull((String)"The custom must be in the view", (Object)SWTTestUtils.findRootTreeItem((String)CUSTOM_NAME, (Tree)tree));
            Assert.assertNotNull((String)"The FacetSet must be in the view", (Object)SWTTestUtils.findRootTreeItem((String)FACET_SET_NAME, (Tree)tree));
            Assert.assertNotNull((String)"The custom must appear under the aggregate", (Object)SWTTestUtils.findTreeItem((String)CUSTOM_NAME, (TreeItem[])aggregate.getItems()));
            Assert.assertNotNull((String)"The FacetSet must appear under the aggregate", (Object)SWTTestUtils.findTreeItem((String)FACET_SET_NAME, (TreeItem[])aggregate.getItems()));
        }
    }
}

