/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.edit.ui.internal.provider;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.edit.ui.internal.provider.FacetPropertySource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class FacetPropertiesSourceProvider
implements IPropertySourceProvider {
    private final AdapterFactory adapterFactory;
    private final AdapterFactoryEditingDomain editingDomain;
    private final ILabelProvider labelProvider;
    private final IFacetManager facetManager;

    public FacetPropertiesSourceProvider(AdapterFactory adapterFactory, AdapterFactoryEditingDomain editingDomain, ILabelProvider labelProvider, IFacetManager facetManager) {
        this.adapterFactory = adapterFactory;
        this.editingDomain = editingDomain;
        this.labelProvider = labelProvider;
        this.facetManager = facetManager;
    }

    public IPropertySource getPropertySource(Object object) {
        IPropertySource result = null;
        if (object instanceof IPropertySource) {
            result = (IPropertySource)object;
        } else {
            IItemPropertySource itemPropSrc = null;
            if (!(object instanceof EObject) || ((EObject)object).eClass() != null) {
                itemPropSrc = (IItemPropertySource)this.adapterFactory.adapt(object, IItemPropertySource.class);
            }
            if (itemPropSrc != null) {
                result = this.createPropertySource(object, itemPropSrc);
            }
        }
        return result;
    }

    protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropSrc) {
        PropertySource result = null;
        if (object instanceof EObject && this.facetManager != null) {
            EObject eObject = (EObject)object;
            result = new FacetPropertySource(eObject, itemPropSrc, this.editingDomain, this.labelProvider, this.facetManager);
        }
        if (result == null) {
            result = new PropertySource(object, itemPropSrc);
        }
        return result;
    }
}

